package mods.flammpfeil.slashblade.client.renderer.event;

import com.google.common.cache.LoadingCache;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.init.DefaultResources;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

// 模型资源预加载（防止启动游戏就直接爆玩家显存，只给了原版用）
public class ModelResourceLoader implements class_3302, IdentifiableResourceReloadListener {
    private static final class_2960 MODEL_DIR = SlashBlade.prefix("model");
    private static final String FILE_TYPES = ".obj";

    private void loadResources(class_3300 manager) {
        BladeModelManager instance = BladeModelManager.getInstance();
        LoadingCache<class_2960, WavefrontObject> cache = instance.cache;
        cache.invalidateAll();
        instance.defaultModel = new WavefrontObject(DefaultResources.resourceDefaultModel);

        Map<class_2960, class_3298> resources = manager.method_14488(
                MODEL_DIR.method_12832(),
                resLoc -> resLoc.method_12832().endsWith(FILE_TYPES)
        );

        resources.keySet().forEach(resourceLocation -> {
            instance.getModel(resourceLocation);
        });
    }

    @Override
    public CompletableFuture<Void> method_25931(class_4045 stage,
                                          class_3300 resourceManager,
                                          class_3695 preparationsProfiler,
                                          class_3695 reloadProfiler,
                                          Executor backgroundExecutor,
                                          Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> {
            loadResources(resourceManager);
        }, backgroundExecutor).thenCompose(stage::method_18352);
    }

    private static final class_2960 ID = SlashBlade.prefix("model_loader");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}