package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.network.MotionBroadcastPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class BladeMotionEventBroadcaster {

    private static final class SingletonHolder {
        private static final BladeMotionEventBroadcaster instance = new BladeMotionEventBroadcaster();
    }

    public static BladeMotionEventBroadcaster getInstance() {
        return SingletonHolder.instance;
    }

    private BladeMotionEventBroadcaster() {
    }

    public void register() {
        BladeMotionEvent.CALLBACK.register(this::onBladeMotion);
    }

    public void onBladeMotion(BladeMotionEvent event) {
        if (!(event.getEntity() instanceof class_3222 sp))
            return;

        // if(msg.combo == Extra.EX_JUDGEMENT_CUT.getName())
        {
            for (class_3222 player : PlayerLookup.around(sp.method_51469(), new class_243(
                    sp.method_23317(),
                    sp.method_23318(),
                    sp.method_23321()
            ), 20)) {
                ServerPlayNetworking.send(player, new MotionBroadcastPacket(sp.method_5667(), event.getCombo().toString()));
            }
        }

    }
}
