package mods.flammpfeil.slashblade.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class SlashBladeShapedRecipeSerializer implements class_1865<SlashBladeShapedRecipe> {
    public static final MapCodec<SlashBladeShapedRecipe> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            Codec.STRING.optionalFieldOf("group", "").forGetter(SlashBladeShapedRecipe::method_8112),
            class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter(SlashBladeShapedRecipe::method_45441),
            class_8957.field_47321.forGetter(SlashBladeShapedRecipe::getPattern),
            class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.result),
            Codec.BOOL.optionalFieldOf("show_notification", true).forGetter(SlashBladeShapedRecipe::method_49188),
            class_2960.field_25139.fieldOf("blade").forGetter(SlashBladeShapedRecipe::getOutputBlade)
    ).apply(instance, SlashBladeShapedRecipe::new));

    public static final class_9139<class_9129, SlashBladeShapedRecipe> STREAM_CODEC = class_9139.method_56437(
            SlashBladeShapedRecipeSerializer::toNetwork, SlashBladeShapedRecipeSerializer::fromNetwork);

    @NotNull
    public static SlashBladeShapedRecipe fromNetwork(@NotNull class_9129 buf) {
        String group = buf.method_19772();
        class_7710 craftingBookCategory = buf.method_10818(class_7710.class);
        class_8957 shapedRecipePattern = class_8957.field_48359.decode(buf);
        class_1799 itemStack = class_1799.field_48349.decode(buf);
        boolean showNotification = buf.readBoolean();
        class_2960 blade = buf.method_10810();
        return new SlashBladeShapedRecipe(group, craftingBookCategory, shapedRecipePattern, itemStack, showNotification, blade);
    }

    public static void toNetwork(@NotNull class_9129 buf, @NotNull SlashBladeShapedRecipe recipe) {
        buf.method_10814(recipe.group);
        buf.method_10817(recipe.category);
        class_8957.field_48359.encode(buf, recipe.pattern);
        class_1799.field_48349.encode(buf, recipe.result);
        buf.method_52964(recipe.showNotification);
        buf.method_10812(recipe.outputBlade);
    }

    @Override
    public MapCodec<SlashBladeShapedRecipe> method_53736() {
        return CODEC;
    }

    @Override
    public class_9139<class_9129, SlashBladeShapedRecipe> method_56104() {
        return STREAM_CODEC;
    }
}