/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nymmd.struct;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.nyatla.nymmd.MmdException;

public class DataReader {
    private ByteBuffer _buf;

    public DataReader(InputStream i_stream) throws MmdException {
        try {
            int buf_len;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            int file_len = i_stream.available();
            if (file_len < 1) {
                file_len = 0x200000;
            }
            byte[] buf = new byte[file_len];
            while ((buf_len = i_stream.read(buf)) != -1) {
                buffer.write(buf, 0, buf_len);
            }
            this._buf = ByteBuffer.wrap(buffer.toByteArray());
            this._buf.order(ByteOrder.LITTLE_ENDIAN);
            return;
        }
        catch (Exception e) {
            throw new MmdException();
        }
    }

    public int readByte() {
        return this._buf.get();
    }

    public int read() {
        int v = this._buf.get();
        return v >= 0 ? v : 255 + v;
    }

    public short readShort() {
        return this._buf.getShort();
    }

    public int readUnsignedShort() {
        int v = this._buf.getShort();
        return v >= 0 ? v : 65535 + v;
    }

    public int readInt() {
        return this._buf.getInt();
    }

    public float readFloat() {
        return this._buf.getFloat();
    }

    public double readDouble() {
        return this._buf.getDouble();
    }

    public String readAscii(int i_length) throws MmdException {
        try {
            int i;
            String ret = "";
            int len = 0;
            byte[] tmp = new byte[i_length];
            for (i = 0; i < i_length; ++i) {
                byte b = this._buf.get();
                if (b == 0) {
                    ++i;
                    break;
                }
                tmp[i] = b;
                ++len;
            }
            ret = new String(tmp, 0, len, "Shift_JIS");
            while (i < i_length) {
                this._buf.get();
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            throw new MmdException();
        }
    }
}

