/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.event.client.RenderOverrideEvent;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_918;

public class BladeRenderState
extends class_4668 {
    private static final Color defaultColor;
    private static Color col;
    public static final int MAX_LIGHT = 0xF000E0;
    private static final Map<class_2960, class_1921> slashBladeBlendCache;
    private static final Map<class_2960, class_1921> slashBladeBlendColorWriteCache;
    private static final Map<class_2960, class_1921> slashBladeBlendLuminousCache;
    private static final Map<ChargeEffectKey, class_1921> chargeEffectCache;
    private static final Map<class_2960, class_1921> luminousDepthWriteCache;
    private static final Map<class_2960, class_1921> reverseLuminousCache;
    public static final class_1921 SLASHBLADE_GLINT;
    public static final class_1921 SLASHBLADE_ITEM_GLINT;
    protected static final class_4668.class_4685 LIGHTNING_ADDITIVE_TRANSPARENCY;
    protected static final class_4668.class_4685 LIGHTNING_REVERSE_TRANSPARENCY;

    public static void setCol(int rgba) {
        BladeRenderState.setCol(rgba, true);
    }

    public static void setCol(int rgb, boolean hasAlpha) {
        BladeRenderState.setCol(new Color(rgb, hasAlpha));
    }

    public static void setCol(Color value) {
        col = value;
    }

    public static void resetCol() {
        col = defaultColor;
    }

    public BladeRenderState(String p_i225973_1_, Runnable p_i225973_2_, Runnable p_i225973_3_) {
        super(p_i225973_1_, p_i225973_2_, p_i225973_3_);
    }

    public static void renderOverrided(class_1799 stack, WavefrontObject model, String target, class_2960 texture, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlend, true);
    }

    public static void renderOverridedColorWrite(class_1799 stack, WavefrontObject model, String target, class_2960 texture, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlendColorWrite, true);
    }

    public static void renderChargeEffect(class_1799 stack, float f, WavefrontObject model, String target, class_2960 texture, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, loc -> BladeRenderState.getChargeEffect(loc, f * 0.1f % 1.0f, f * 0.01f % 1.0f), false);
    }

    public static void renderOverridedLuminous(class_1799 stack, WavefrontObject model, String target, class_2960 texture, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlendLuminous, false);
    }

    public static void renderOverridedLuminousDepthWrite(class_1799 stack, WavefrontObject model, String target, class_2960 texture, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlendLuminousDepthWrite, false);
    }

    public static void renderOverridedReverseLuminous(class_1799 stack, WavefrontObject model, String target, class_2960 texture, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlendReverseLuminous, false);
    }

    public static void renderOverrided(class_1799 stack, WavefrontObject model, String target, class_2960 texture, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, Function<class_2960, class_1921> getRenderType, boolean enableEffect) {
        RenderOverrideEvent event = RenderOverrideEvent.onRenderOverride(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, getRenderType, enableEffect);
        if (event.isCanceled()) {
            return;
        }
        class_2960 loc = event.getTexture();
        class_1921 rt = event.getGetRenderType().apply(loc);
        class_4588 vb = bufferIn.getBuffer(rt);
        Face.setCol(col);
        Face.setLightMap(event.getPackedLightIn());
        Face.setMatrix(matrixStackIn);
        event.getModel().tessellateOnly(vb, event.getTarget());
        if (stack.method_7958() && event.isEnableEffect()) {
            vb = bufferIn.getBuffer(target.startsWith("item_") ? SLASHBLADE_ITEM_GLINT : SLASHBLADE_GLINT);
            event.getModel().tessellateOnly(vb, event.getTarget());
        }
        Face.resetMatrix();
        Face.resetLightMap();
        Face.resetCol();
        Face.resetAlphaOverride();
        Face.resetUvOperator();
        BladeRenderState.resetCol();
    }

    public static class_1921 getSlashBladeBlend(class_2960 texture) {
        return slashBladeBlendCache.computeIfAbsent(texture, t -> {
            class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(class_4668.field_29405).method_23610(class_4668.field_25643).method_34577((class_4668.class_5939)new class_4668.class_4683(t, false, true)).method_23615(class_4668.field_21370).method_23608(field_21383).method_23611(field_21385).method_23616(class_4668.field_21349).method_23617(true);
            return class_1921.method_24049((String)("slashblade_blend_" + String.valueOf(t)), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)state);
        });
    }

    public static class_1921 getSlashBladeGlint() {
        class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(field_29421).method_34577((class_4668.class_5939)new class_4668.class_4683(class_918.field_43086, true, false)).method_23616(field_21350).method_23603(field_21345).method_23604(field_21347).method_23615(field_21368).method_23610(field_25643).method_23614(field_21382).method_23611(field_21385).method_23617(false);
        return class_1921.method_24049((String)"slashblade_glint", (class_293)class_290.field_1585, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)state);
    }

    public static class_1921 getSlashBladeItemGlint() {
        class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(field_29421).method_34577((class_4668.class_5939)new class_4668.class_4683(class_918.field_43087, true, false)).method_23616(field_21350).method_23603(field_21345).method_23604(field_21347).method_23615(field_21368).method_23610(field_25643).method_23614(field_21381).method_23611(field_21385).method_23617(false);
        return class_1921.method_24049((String)"slashblade_glint", (class_293)class_290.field_1585, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)state);
    }

    public static class_1921 getSlashBladeBlendColorWrite(class_2960 texture) {
        return slashBladeBlendColorWriteCache.computeIfAbsent(texture, t -> {
            class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(class_4668.field_38344).method_23610(class_4668.field_25643).method_34577((class_4668.class_5939)new class_4668.class_4683(t, false, true)).method_23615(LIGHTNING_ADDITIVE_TRANSPARENCY).method_23608(field_21383).method_23611(field_21385).method_23616(field_21350).method_23617(false);
            return class_1921.method_24049((String)("slashblade_blend_write_color_" + String.valueOf(t)), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)state);
        });
    }

    public static class_1921 getSlashBladeBlendLuminous(class_2960 texture) {
        return slashBladeBlendLuminousCache.computeIfAbsent(texture, t -> {
            class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(class_4668.field_38344).method_23610(field_25643).method_23603(class_4668.field_21345).method_34577((class_4668.class_5939)new class_4668.class_4683(t, true, true)).method_23615(LIGHTNING_ADDITIVE_TRANSPARENCY).method_23608(class_4668.field_21383).method_23611(field_21385).method_23616(field_21350).method_23617(false);
            return class_1921.method_24049((String)("slashblade_blend_luminous_" + String.valueOf(t)), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)state);
        });
    }

    public static class_1921 getChargeEffect(class_2960 texture, float x, float y) {
        ChargeEffectKey key = new ChargeEffectKey(texture, x, y);
        return chargeEffectCache.computeIfAbsent(key, k -> {
            class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(field_29415).method_23610(field_25643).method_23603(class_4668.field_21345).method_34577((class_4668.class_5939)new class_4668.class_4683(k.texture, false, true)).method_23614((class_4668.class_4684)new class_4668.class_4682(k.x, k.y)).method_23615(LIGHTNING_ADDITIVE_TRANSPARENCY).method_23608(class_4668.field_21383).method_23611(field_21385).method_23616(class_4668.field_21350).method_23617(false);
            return class_1921.method_24049((String)("slashblade_charge_effect_" + String.valueOf(k.texture) + "_" + k.x + "_" + k.y), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)state);
        });
    }

    public static class_1921 getSlashBladeBlendLuminousDepthWrite(class_2960 texture) {
        return luminousDepthWriteCache.computeIfAbsent(texture, t -> {
            class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(field_38344).method_23610(class_4668.field_25281).method_34577((class_4668.class_5939)new class_4668.class_4683(t, true, true)).method_23615(LIGHTNING_ADDITIVE_TRANSPARENCY).method_23608(class_4668.field_21383).method_23611(field_21385).method_23616(field_21349).method_23617(false);
            return class_1921.method_24049((String)("slashblade_blend_luminous_depth_write_" + String.valueOf(t)), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)state);
        });
    }

    public static class_1921 getSlashBladeBlendReverseLuminous(class_2960 texture) {
        return reverseLuminousCache.computeIfAbsent(texture, t -> {
            class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(field_38344).method_23610(class_4668.field_25643).method_34577((class_4668.class_5939)new class_4668.class_4683(t, true, true)).method_23615(LIGHTNING_REVERSE_TRANSPARENCY).method_23608(class_4668.field_21383).method_23611(field_21385).method_23616(field_21350).method_23617(false);
            return class_1921.method_24049((String)("slashblade_blend_reverse_luminous_" + String.valueOf(t)), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)state);
        });
    }

    static {
        col = defaultColor = Color.white;
        slashBladeBlendCache = new HashMap<class_2960, class_1921>();
        slashBladeBlendColorWriteCache = new HashMap<class_2960, class_1921>();
        slashBladeBlendLuminousCache = new HashMap<class_2960, class_1921>();
        chargeEffectCache = new HashMap<ChargeEffectKey, class_1921>();
        luminousDepthWriteCache = new HashMap<class_2960, class_1921>();
        reverseLuminousCache = new HashMap<class_2960, class_1921>();
        SLASHBLADE_GLINT = BladeRenderState.getSlashBladeGlint();
        SLASHBLADE_ITEM_GLINT = BladeRenderState.getSlashBladeItemGlint();
        LIGHTNING_ADDITIVE_TRANSPARENCY = new class_4668.class_4685("lightning_additive_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        LIGHTNING_REVERSE_TRANSPARENCY = new class_4668.class_4685("lightning_reverse_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.blendEquation((int)32779);
        }, () -> {
            RenderSystem.blendEquation((int)32774);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
    }

    private static class ChargeEffectKey {
        final class_2960 texture;
        final float x;
        final float y;

        ChargeEffectKey(class_2960 texture, float x, float y) {
            this.texture = texture;
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChargeEffectKey that = (ChargeEffectKey)o;
            return Float.compare(that.x, this.x) == 0 && Float.compare(that.y, this.y) == 0 && this.texture.equals((Object)that.texture);
        }

        public int hashCode() {
            int result = this.texture.hashCode();
            result = 31 * result + Float.floatToIntBits(this.x);
            result = 31 * result + Float.floatToIntBits(this.y);
            return result;
        }
    }
}

