/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.item;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.api.extension.ISlashBladeCapabilityProvider;
import cn.sh1rocu.slashblade.api.extension.ItemSlashBladeExtension;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.SlashBladeTEISR;
import mods.flammpfeil.slashblade.data.tag.SlashBladeItemTags;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ReachModifier;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.registry.specialeffects.SpecialEffect;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_756;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSlashBlade
extends class_1829
implements ItemSlashBladeExtension,
ISlashBladeCapabilityProvider {
    protected static final class_2960 PLAYER_REACH_AMPLIFIER = SlashBlade.prefix("player_reach_amplifier");
    public static final List<class_5321<class_1887>> exEnchantment = List.of(class_1893.field_23071, class_1893.field_9103, class_1893.field_9129, class_1893.field_9095, class_1893.field_9097);
    protected int attackDamageIn;
    protected float attackSpeedIn;
    public static final String BREAK_ACTION_TIMEOUT = "BreakActionTimeout";
    RangeMap<Comparable<?>, Object> refineColor = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Integer.valueOf(10)), (Object)class_124.field_1080).put(Range.closedOpen((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(50)), (Object)class_124.field_1054).put(Range.closedOpen((Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)), (Object)class_124.field_1060).put(Range.closedOpen((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(150)), (Object)class_124.field_1075).put(Range.closedOpen((Comparable)Integer.valueOf(150), (Comparable)Integer.valueOf(200)), (Object)class_124.field_1078).put(Range.atLeast((Comparable)Integer.valueOf(200)), (Object)class_124.field_1076).build();

    public ItemSlashBlade(class_1832 tier, int attackDamageIn, float attackSpeedIn, class_1792.class_1793 builder) {
        super(tier, builder);
        this.attackDamageIn = attackDamageIn;
        this.attackSpeedIn = attackSpeedIn;
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        if (enchantment.method_40230().isPresent() && exEnchantment.contains(enchantment.method_40230().get())) {
            return true;
        }
        return super.canBeEnchantedWith(stack, enchantment, context);
    }

    @Nullable
    public String getCreatorNamespace(class_1799 itemStack) {
        return super.getCreatorNamespace(itemStack);
    }

    @Override
    @NotNull
    public class_9285 getDefaultAttributeModifiers(@NotNull class_1799 stack) {
        class_9285.class_9286 builder = class_9285.method_57480();
        builder.method_57487(class_5134.field_23723, new class_1322(field_8001, (double)this.attackSpeedIn, class_1322.class_1323.field_6328), class_9274.field_49217);
        AtomicReference<Double> finalDamage = new AtomicReference<Double>(Double.valueOf((float)this.attackDamageIn + this.method_8022().method_8028()));
        Optional<ISlashBladeState> state = CapabilitySlashBlade.getBladeState(stack);
        state.ifPresent(s -> {
            EnumSet<SwordType> swordType = SwordType.from(stack);
            float baseAttackModifier = s.getBaseAttackModifier();
            int refine = s.getRefine();
            float attackAmplifier = s.getAttackAmplifier();
            if (s.isBroken()) {
                attackAmplifier = -0.5f - baseAttackModifier;
            } else {
                float refineFactor = swordType.contains((Object)SwordType.FIERCEREDGE) ? 0.1f : 0.05f;
                attackAmplifier = (1.0f - 1.0f / (1.0f + refineFactor * (float)refine)) * baseAttackModifier;
            }
            double damage = (double)baseAttackModifier + (double)attackAmplifier - 1.0;
            SlashBladeEvent.UpdateAttackEvent event = new SlashBladeEvent.UpdateAttackEvent(stack, (ISlashBladeState)s, damage);
            ((SlashBladeEvent.UpdateAttack)SlashBladeEvent.UPDATE_ATTACK.invoker()).onUpdateAttack(event);
            finalDamage.set(event.getNewDamage());
            builder.method_57487(class_5134.field_47759, new class_1322(PLAYER_REACH_AMPLIFIER, s.isBroken() ? ReachModifier.BrokendReach() : ReachModifier.BladeReach(), class_1322.class_1323.field_6328), class_9274.field_49217);
        });
        class_1322 attack = new class_1322(field_8006, finalDamage.get().doubleValue(), class_1322.class_1323.field_6328);
        builder.method_57487(class_5134.field_23721, attack, class_9274.field_49217);
        return builder.method_57486();
    }

    @Override
    @NotNull
    public class_1814 getRarity(class_1799 stack) {
        EnumSet<SwordType> type = SwordType.from(stack);
        if (type.contains((Object)SwordType.BEWITCHED)) {
            return class_1814.field_8904;
        }
        if (type.contains((Object)SwordType.ENCHANTED)) {
            return class_1814.field_8903;
        }
        return class_1814.field_8906;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 itemstack = playerIn.method_5998(handIn);
        if (handIn == class_1268.field_5810 && !(playerIn.method_6047().method_7909() instanceof ItemSlashBlade)) {
            return class_1271.method_22430((Object)itemstack);
        }
        boolean result = CapabilitySlashBlade.getBladeState(itemstack).map(state -> {
            CapabilityInputState.INPUT_STATE.maybeGet((Object)playerIn).ifPresent(s -> s.getCommands().add(InputCommand.R_CLICK));
            class_2960 combo = state.progressCombo((class_1309)playerIn);
            CapabilityInputState.INPUT_STATE.maybeGet((Object)playerIn).ifPresent(s -> s.getCommands().remove((Object)InputCommand.R_CLICK));
            if (!combo.equals((Object)ComboStateRegistry.getId(ComboStateRegistry.NONE))) {
                playerIn.method_6104(handIn);
            }
            return true;
        }).orElse(false);
        playerIn.method_6019(handIn);
        return new class_1271(result ? class_1269.field_5812 : class_1269.field_5814, (Object)itemstack);
    }

    @Override
    public boolean onLeftClickEntity(class_1799 itemstack, class_1657 playerIn, class_1297 entity) {
        Optional<ISlashBladeState> stateHolder = CapabilitySlashBlade.getBladeState(itemstack).filter(state -> !state.onClick());
        stateHolder.ifPresent(state -> {
            CapabilityInputState.INPUT_STATE.maybeGet((Object)playerIn).ifPresent(s -> s.getCommands().add(InputCommand.L_CLICK));
            state.progressCombo((class_1309)playerIn);
            CapabilityInputState.INPUT_STATE.maybeGet((Object)playerIn).ifPresent(s -> s.getCommands().remove((Object)InputCommand.L_CLICK));
        });
        return stateHolder.isPresent();
    }

    @Override
    public void setDamage(class_1799 stack, int damage) {
        int maxDamage = stack.method_7936();
        if (maxDamage < 0) {
            return;
        }
        ISlashBladeState state = CapabilitySlashBlade.getBladeState(stack).orElseThrow(NullPointerException::new);
        if (state.isBroken()) {
            if (damage <= 0 && !state.isSealed()) {
                state.setBroken(false);
            } else if (maxDamage < damage) {
                damage = Math.min(damage, maxDamage - 1);
            }
        }
        state.setDamage(damage);
    }

    @Override
    public <T extends class_1309> int damageItem(class_1799 stack, int amount, @Nullable T entity, Consumer<class_1792> onBroken) {
        if (stack.method_7936() <= 0) {
            return 0;
        }
        if (amount <= 0) {
            return 0;
        }
        ISlashBladeState cap = CapabilitySlashBlade.getBladeState(stack).orElseThrow(NullPointerException::new);
        boolean current = cap.isBroken();
        if (stack.method_7919() + amount >= stack.method_7936()) {
            amount = 0;
            stack.method_7974(stack.method_7936() - 1);
            SlashBladeEvent.BreakEvent event = new SlashBladeEvent.BreakEvent(stack, cap);
            ((SlashBladeEvent.Break)SlashBladeEvent.BREAK.invoker()).onBreak(event);
            cap.setBroken(!event.isCanceled());
        }
        if (current != cap.isBroken()) {
            class_3222 player;
            onBroken.accept(stack.method_7909());
            if (entity instanceof class_3222) {
                player = (class_3222)entity;
                class_174.field_1198.method_8821(player, stack);
            }
            if (entity instanceof class_1657) {
                player = (class_1657)entity;
                player.method_7259(class_3468.field_15383.method_14956((Object)stack.method_7909()));
            }
        }
        if (cap.isBroken() && this.isDestructable(stack)) {
            stack.method_7934(1);
        }
        return amount;
    }

    public static Consumer<class_1792> getOnBroken(class_1799 stack, class_1309 user) {
        return item -> {
            user.method_20235(item, class_1304.field_6173);
            ISlashBladeState state = CapabilitySlashBlade.getBladeState(stack).orElseThrow(NullPointerException::new);
            if (stack.method_7942()) {
                int count = state.getProudSoulCount() >= (Integer)SlashBladeConfig.MAX_ENCHANTED_PROUDSOUL_DROP.get() * 100 ? (Integer)SlashBladeConfig.MAX_ENCHANTED_PROUDSOUL_DROP.get() : Math.max(1, state.getProudSoulCount() / 100);
                List<class_5321> enchantments = user.method_56673().method_46762(class_7924.field_41265).method_46754().filter(enchantment -> stack.canBeEnchantedWith((class_6880)user.method_56673().method_46762(class_7924.field_41265).method_46747(enchantment), EnchantingContext.ACCEPTABLE)).filter(enchantment -> !((List)SlashBladeConfig.NON_DROPPABLE_ENCHANTMENT.get()).contains(enchantment.method_29177().toString())).toList();
                for (int i = 0; i < count; ++i) {
                    class_1799 enchanted_soul = new class_1799((class_1935)SBItems.proudsoul_tiny);
                    Optional enchant = user.method_56673().method_46762(class_7924.field_41265).method_46746(enchantments.get(user.method_59922().method_43051(0, enchantments.size())));
                    if (enchant.isPresent()) {
                        enchanted_soul.method_7978((class_6880)enchant.get(), 1);
                        class_1542 itemEntity = new class_1542(user.method_37908(), user.method_23317(), user.method_23318(), user.method_23321(), enchanted_soul);
                        itemEntity.method_6988();
                        user.method_37908().method_8649((class_1297)itemEntity);
                    }
                    state.setProudSoulCount(state.getProudSoulCount() - 100);
                }
            }
            class_1799 soul = new class_1799((class_1935)SBItems.proudsoul_tiny);
            int count = state.getProudSoulCount() >= (Integer)SlashBladeConfig.MAX_PROUDSOUL_DROP.get() * 100 ? (Integer)SlashBladeConfig.MAX_PROUDSOUL_DROP.get() : Math.max(1, state.getProudSoulCount() / 100);
            soul.method_7939(count);
            state.setProudSoulCount(state.getProudSoulCount() - count * 100);
            class_1542 itementity = new class_1542(user.method_37908(), user.method_23317(), user.method_23318(), user.method_23321(), soul);
            BladeItemEntity e = new BladeItemEntity((class_1299)SBEntityTypes.BladeItem, user.method_37908()){
                static final String isReleased = "isReleased";

                @Override
                public boolean method_5747(float distance, float damageMultiplier, class_1282 ds) {
                    class_2487 tag = this.sb$getPersistentData();
                    if (!tag.method_10577(isReleased)) {
                        class_1297 thrower;
                        this.sb$getPersistentData().method_10556(isReleased, true);
                        if (this.method_37908() instanceof class_3218 && (thrower = this.method_24921()) != null) {
                            ((EntityExtension)thrower).sb$getPersistentData().method_10551(ItemSlashBlade.BREAK_ACTION_TIMEOUT);
                        }
                    }
                    return super.method_5747(distance, damageMultiplier, ds);
                }
            };
            e.method_5878((class_1297)itementity);
            e.init();
            e.method_5762(0.0, 0.4, 0.0);
            e.setModel(state.getModel().orElse(DefaultResources.resourceDefaultModel));
            e.setTexture(state.getTexture().orElse(DefaultResources.resourceDefaultTexture));
            e.method_6982(40);
            e.method_5834(true);
            e.method_5855(-1);
            e.method_6981((class_1297)user);
            user.method_37908().method_8649((class_1297)e);
            ((EntityExtension)user).sb$getPersistentData().method_10544(BREAK_ACTION_TIMEOUT, user.method_37908().method_8510() + 100L);
        };
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        CapabilitySlashBlade.getBladeState(stack).ifPresent(state -> {
            class_2960 loc = state.resolvCurrentComboState(attacker);
            ComboState cs = ComboStateRegistry.COMBO_STATE.method_10223(loc) != null ? (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(loc) : ComboStateRegistry.NONE;
            SlashBladeEvent.HitEvent event = new SlashBladeEvent.HitEvent(stack, (ISlashBladeState)state, target, attacker);
            ((SlashBladeEvent.Hit)SlashBladeEvent.HIT.invoker()).onHit(event);
            if (event.isCanceled()) {
                return;
            }
            cs.hitEffect(target, attacker);
            class_1937 patt0$temp = attacker.method_37908();
            if (patt0$temp instanceof class_3218) {
                class_3222 sp;
                class_3218 serverLevel = (class_3218)patt0$temp;
                class_3222 serverPlayer = attacker instanceof class_3222 ? (sp = (class_3222)attacker) : null;
                stack.method_7956(1, serverLevel, serverPlayer, ItemSlashBlade.getOnBroken(stack, attacker));
            }
        });
        return true;
    }

    public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 state, class_2338 pos, class_1309 entityLiving) {
        if (state.method_26214((class_1922)worldIn, pos) != 0.0f) {
            CapabilitySlashBlade.getBladeState(stack).ifPresent(s -> {
                class_1937 patt0$temp = entityLiving.method_37908();
                if (patt0$temp instanceof class_3218) {
                    class_3222 sp;
                    class_3218 serverLevel = (class_3218)patt0$temp;
                    class_3222 serverPlayer = entityLiving instanceof class_3222 ? (sp = (class_3222)entityLiving) : null;
                    stack.method_7956(1, serverLevel, serverPlayer, ItemSlashBlade.getOnBroken(stack, entityLiving));
                }
            });
        }
        return true;
    }

    public void method_7840(class_1799 stack, class_1937 worldIn, class_1309 entityLiving, int timeLeft) {
        int elapsed = this.method_7881(stack, entityLiving) - timeLeft;
        if (!worldIn.method_8608()) {
            CapabilitySlashBlade.getBladeState(stack).ifPresent(state -> {
                EnumSet<SwordType> swordType = SwordType.from(stack);
                if (state.isBroken() || state.isSealed() || !swordType.contains((Object)SwordType.ENCHANTED)) {
                    return;
                }
                class_2960 sa = state.doChargeAction(entityLiving, elapsed);
                boolean isCreative = false;
                if (!sa.equals((Object)ComboStateRegistry.getId(ComboStateRegistry.NONE))) {
                    if (entityLiving instanceof class_1657) {
                        class_1657 player = (class_1657)entityLiving;
                        isCreative = player.method_31549().field_7477;
                    }
                    if (!isCreative) {
                        int cost = state.getSlashArts().getProudSoulCost();
                        if (state.getProudSoulCount() >= cost) {
                            state.setProudSoulCount(state.getProudSoulCount() - cost);
                        } else {
                            class_1937 patt0$temp = entityLiving.method_37908();
                            if (patt0$temp instanceof class_3218) {
                                class_3222 sp;
                                class_3218 serverLevel = (class_3218)patt0$temp;
                                class_3222 serverPlayer = entityLiving instanceof class_3222 ? (sp = (class_3222)entityLiving) : null;
                                stack.method_7956(1, serverLevel, serverPlayer, ItemSlashBlade.getOnBroken(stack, entityLiving));
                            }
                        }
                    }
                    entityLiving.method_6104(class_1268.field_5808);
                }
            });
        }
    }

    public void method_7852(class_1937 level, class_1309 player, class_1799 stack, int count) {
        CapabilitySlashBlade.getBladeState(stack).ifPresent(state -> {
            (ComboStateRegistry.COMBO_STATE.method_10223(state.getComboSeq()) != null ? (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(state.getComboSeq()) : ComboStateRegistry.NONE).holdAction(player);
            EnumSet<SwordType> swordType = SwordType.from(stack);
            if (state.isBroken() || state.isSealed() || !swordType.contains((Object)SwordType.ENCHANTED)) {
                return;
            }
            if (!player.method_37908().method_8608()) {
                int ticks = player.method_6048();
                int fullChargeTicks = state.getFullChargeTicks(player);
                if (0 < ticks && ticks == fullChargeTicks) {
                    class_243 pos = player.method_5836(1.0f).method_1019(player.method_5720());
                    ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11214, pos.field_1352, pos.field_1351, pos.field_1350, 7, 0.7, 0.7, 0.7, 0.02);
                }
            }
        });
    }

    public void method_7888(class_1799 stack, class_1937 worldIn, class_1297 entityIn, int itemSlot, boolean isSelected) {
        super.method_7888(stack, worldIn, entityIn, itemSlot, isSelected);
        if (stack == null) {
            return;
        }
        if (entityIn == null) {
            return;
        }
        CapabilitySlashBlade.getBladeState(stack).ifPresent(state -> {
            SlashBladeEvent.UpdateEvent event = new SlashBladeEvent.UpdateEvent(stack, (ISlashBladeState)state, worldIn, entityIn, itemSlot, isSelected);
            ((SlashBladeEvent.Update)SlashBladeEvent.UPDATE.invoker()).onUpdate(event);
            if (event.isCanceled()) {
                return;
            }
            if (!isSelected) {
                EnumSet<SwordType> swordType = SwordType.from(stack);
                if (entityIn instanceof class_1657) {
                    boolean hasHunger;
                    class_1657 player = (class_1657)entityIn;
                    if (!((Boolean)SlashBladeConfig.SELF_REPAIR_ENABLE.get()).booleanValue()) {
                        return;
                    }
                    boolean bl = hasHunger = player.method_6059(class_1294.field_5903) && (Boolean)SlashBladeConfig.HUNGER_CAN_REPAIR.get() != false;
                    if ((swordType.contains((Object)SwordType.BEWITCHED) || hasHunger) && stack.method_7919() > 0 && player.method_7344().method_7586() > 0) {
                        int hungerAmplifier = hasHunger ? player.method_6112(class_1294.field_5903).method_5578() : 0;
                        int level = 1 + hungerAmplifier;
                        Boolean expCostFlag = (Boolean)SlashBladeConfig.SELF_REPAIR_COST_EXP.get();
                        int expCost = (Integer)SlashBladeConfig.BEWITCHED_EXP_COST.get() * level;
                        if (expCostFlag.booleanValue() && player.field_7520 < expCost) {
                            return;
                        }
                        player.method_7255(expCostFlag != false ? -expCost : 0);
                        player.method_7322(((Double)SlashBladeConfig.BEWITCHED_HUNGER_EXHAUSTION.get()).floatValue() * (float)level);
                        stack.method_7974(stack.method_7919() - level);
                    }
                }
            }
            if (entityIn instanceof class_1309) {
                ComboState cs;
                class_1309 living = (class_1309)entityIn;
                CapabilityInputState.INPUT_STATE.maybeGet((Object)entityIn).ifPresent(mInput -> mInput.getScheduler().onTick(living));
                class_2960 loc = state.resolvCurrentComboState(living);
                ComboState comboState = cs = ComboStateRegistry.COMBO_STATE.method_10223(loc) != null ? (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(loc) : ComboStateRegistry.NONE;
                if (ItemSlashBlade.isInMainhand(stack, isSelected, living)) {
                    cs.tickAction(living);
                } else if (!loc.equals((Object)state.getComboRoot())) {
                    state.setComboSeq(state.getComboRoot());
                }
            }
        });
    }

    public static boolean isInMainhand(class_1799 stack, boolean isSelected, class_1309 living) {
        return isSelected && stack.equals(living.method_6047());
    }

    @Override
    public int getDamage(class_1799 stack) {
        return CapabilitySlashBlade.getBladeState(stack).filter(s -> !s.isEmpty()).map(ISlashBladeState::getDamage).orElse(0);
    }

    @Override
    public int getMaxDamage(class_1799 stack) {
        return CapabilitySlashBlade.getBladeState(stack).filter(s -> !s.isEmpty()).map(ISlashBladeState::getMaxDamage).orElse(this.method_8022().method_8025());
    }

    public boolean method_31567(class_1799 stack) {
        return false;
    }

    public String method_7866(class_1799 stack) {
        return CapabilitySlashBlade.getBladeState(stack).filter(s -> !s.getTranslationKey().isBlank()).map(ISlashBladeState::getTranslationKey).orElseGet(() -> this.stackDefaultDescriptionId(stack));
    }

    private String stackDefaultDescriptionId(class_1799 stack) {
        Optional<ISlashBladeState> cap = CapabilitySlashBlade.getBladeState(stack);
        if (cap.isEmpty()) {
            return super.method_7866(stack);
        }
        String key = cap.get().getTranslationKey();
        return !key.isBlank() ? key : super.method_7866(stack);
    }

    public boolean isDestructable(class_1799 stack) {
        return false;
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        if (class_1856.method_8106((class_6862)class_3489.field_23802).method_8093(repair)) {
            return true;
        }
        if (repair.method_31573(SlashBladeItemTags.PROUD_SOULS)) {
            return true;
        }
        return super.method_7878(toRepair, repair);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        CapabilitySlashBlade.getBladeState(stack).ifPresent(s -> {
            this.appendSwordType(stack, context, tooltip, flagIn);
            this.appendProudSoulCount(tooltip, stack, (ISlashBladeState)s);
            this.appendKillCount(tooltip, stack, (ISlashBladeState)s);
            this.appendSlashArt(stack, tooltip, (ISlashBladeState)s);
            this.appendRefineCount(tooltip, stack, (ISlashBladeState)s);
            this.appendSpecialEffects(tooltip, (ISlashBladeState)s);
        });
        super.method_7851(stack, context, tooltip, flagIn);
    }

    @Environment(value=EnvType.CLIENT)
    public void appendSlashArt(class_1799 stack, List<class_2561> tooltip, @NotNull ISlashBladeState s) {
        EnumSet<SwordType> swordType = SwordType.from(stack);
        if (swordType.contains((Object)SwordType.BEWITCHED) && !swordType.contains((Object)SwordType.SEALED)) {
            tooltip.add((class_2561)class_2561.method_43469((String)"slashblade.tooltip.slash_art", (Object[])new Object[]{s.getSlashArts().getDescription()}).method_27692(class_124.field_1080));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void appendRefineCount(List<class_2561> tooltip, @NotNull class_1799 stack, @NotNull ISlashBladeState s) {
        int refine = s.getRefine();
        if (refine > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"slashblade.tooltip.refine", (Object[])new Object[]{refine}).method_27692((class_124)this.refineColor.get((Comparable)Integer.valueOf(refine))));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void appendProudSoulCount(List<class_2561> tooltip, @NotNull class_1799 stack, @NotNull ISlashBladeState s) {
        int proudsoul = s.getProudSoulCount();
        if (proudsoul > 0) {
            class_5250 countComponent = class_2561.method_43469((String)"slashblade.tooltip.proud_soul", (Object[])new Object[]{proudsoul}).method_27692(class_124.field_1080);
            if (proudsoul > 10000) {
                countComponent = countComponent.method_27692(class_124.field_1064);
            }
            tooltip.add((class_2561)countComponent);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void appendKillCount(List<class_2561> tooltip, @NotNull class_1799 stack, @NotNull ISlashBladeState s) {
        int killCount = s.getKillCount();
        if (killCount > 0) {
            class_5250 killCountComponent = class_2561.method_43469((String)"slashblade.tooltip.killcount", (Object[])new Object[]{killCount}).method_27692(class_124.field_1080);
            if (killCount > 1000) {
                killCountComponent = killCountComponent.method_27692(class_124.field_1064);
            }
            tooltip.add((class_2561)killCountComponent);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void appendSpecialEffects(List<class_2561> tooltip, @NotNull ISlashBladeState s) {
        if (s.getSpecialEffects().isEmpty()) {
            return;
        }
        class_310 mcinstance = class_310.method_1551();
        class_746 player = mcinstance.field_1724;
        s.getSpecialEffects().forEach(arg_0 -> ItemSlashBlade.lambda$appendSpecialEffects$22(tooltip, (class_1657)player, arg_0));
    }

    @Environment(value=EnvType.CLIENT)
    public void appendSwordType(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flagIn) {
        EnumSet<SwordType> swordType = SwordType.from(stack);
        boolean goldenFlag = swordType.containsAll(List.of(SwordType.SOULEATER, SwordType.FIERCEREDGE));
        if (swordType.contains((Object)SwordType.SEALED)) {
            return;
        }
        if (swordType.contains((Object)SwordType.BEWITCHED)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"slashblade.sword_type.bewitched").method_27692(goldenFlag ? class_124.field_1065 : class_124.field_1064));
        } else if (swordType.contains((Object)SwordType.ENCHANTED)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"slashblade.sword_type.enchanted").method_27692(class_124.field_1062));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"slashblade.sword_type.noname").method_27692(class_124.field_1063));
        }
    }

    @Override
    public boolean onEntitySwing(class_1799 stack, class_1309 entity) {
        return CapabilitySlashBlade.getBladeState(stack).filter(s -> s.getLastActionTime() == entity.method_37908().method_8510()).isEmpty();
    }

    public boolean hasCustomEntity(class_1799 stack) {
        return true;
    }

    @Override
    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        if (!(entity instanceof BladeItemEntity)) {
            class_1937 world = entity.method_37908();
            BladeItemEntity e = new BladeItemEntity(SBEntityTypes.BladeItem, world);
            e.method_5878((class_1297)entity);
            e.init();
            entity.method_31472();
            world.method_8649((class_1297)e);
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_756 getCustomRenderer() {
        return new SlashBladeTEISR(class_310.method_1551().method_31975(), class_310.method_1551().method_31974());
    }

    @Override
    public SlashBladeState initCapability(class_1799 stack) {
        return new SlashBladeState(stack);
    }

    private static /* synthetic */ void lambda$appendSpecialEffects$22(List tooltip, class_1657 player, class_2960 se) {
        boolean showingLevel = SpecialEffect.getRequestLevel(se) > 0;
        tooltip.add(class_2561.method_43469((String)"slashblade.tooltip.special_effect", (Object[])new Object[]{SpecialEffect.getDescription(se), class_2561.method_43470((String)(showingLevel ? String.valueOf(SpecialEffect.getRequestLevel(se)) : "")).method_27692(SpecialEffect.isEffective(se, player.field_7520) ? class_124.field_1061 : class_124.field_1063)}).method_27692(class_124.field_1080));
    }
}

