/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7887;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class RequestDefinition {
    public static final Codec<RequestDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("name", (Object)SlashBlade.prefix("none")).forGetter(RequestDefinition::getName), (App)Codec.INT.optionalFieldOf("proud_soul", (Object)0).forGetter(RequestDefinition::getProudSoulCount), (App)Codec.INT.optionalFieldOf("kill", (Object)0).forGetter(RequestDefinition::getKillCount), (App)Codec.INT.optionalFieldOf("refine", (Object)0).forGetter(RequestDefinition::getRefineCount), (App)EnchantmentDefinition.CODEC.listOf().optionalFieldOf("enchantments", (Object)Lists.newArrayList()).forGetter(RequestDefinition::getEnchantments), (App)SwordType.CODEC.listOf().optionalFieldOf("sword_type", (Object)Lists.newArrayList()).forGetter(RequestDefinition::getDefaultType)).apply((Applicative)instance, RequestDefinition::new));
    public static final class_9139<class_9129, RequestDefinition> STREAM_CODEC = class_9139.method_58025((class_9139)class_2960.field_48267, RequestDefinition::getName, (class_9139)class_9135.field_49675, RequestDefinition::getProudSoulCount, (class_9139)class_9135.field_49675, RequestDefinition::getKillCount, (class_9139)class_9135.field_49675, RequestDefinition::getRefineCount, (class_9139)EnchantmentDefinition.STREAM_CODEC.method_56433(class_9135.method_56363()), RequestDefinition::getEnchantments, (class_9139)SwordType.STREAM_CODEC.method_56433(class_9135.method_56363()), RequestDefinition::getDefaultType, RequestDefinition::new);
    private final class_2960 name;
    private final int proudSoulCount;
    private final int killCount;
    private final int refineCount;
    private final List<EnchantmentDefinition> enchantments;
    private final List<SwordType> defaultType;

    public RequestDefinition(class_2960 name, int proud, int kill, int refine, List<EnchantmentDefinition> enchantments, List<SwordType> defaultType) {
        this.name = name;
        this.proudSoulCount = proud;
        this.killCount = kill;
        this.refineCount = refine;
        this.enchantments = enchantments;
        this.defaultType = defaultType;
    }

    public class_2960 getName() {
        return this.name;
    }

    public int getProudSoulCount() {
        return this.proudSoulCount;
    }

    public int getKillCount() {
        return this.killCount;
    }

    public int getRefineCount() {
        return this.refineCount;
    }

    public List<EnchantmentDefinition> getEnchantments() {
        return this.enchantments;
    }

    public List<SwordType> getDefaultType() {
        return this.defaultType;
    }

    public static RequestDefinition fromJSON(JsonObject json) {
        return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(msg -> SlashBlade.LOGGER.error("Failed to parse : {}", msg)).orElseGet(Builder.newInstance()::build);
    }

    public JsonElement toJson() {
        return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).resultOrPartial(msg -> SlashBlade.LOGGER.error("Failed to encode : {}", msg)).orElseThrow();
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10812(this.getName());
        buffer.method_53002(this.getProudSoulCount());
        buffer.method_53002(this.getKillCount());
        buffer.method_53002(this.getRefineCount());
        buffer.method_34062(this.getEnchantments(), (buf, request) -> {
            buf.method_10812(request.getEnchantmentID());
            buf.method_52997(request.getEnchantmentLevel());
        });
        buffer.method_34062(this.getDefaultType(), (buf, request) -> buf.method_10814(request.name().toLowerCase()));
    }

    public static RequestDefinition fromNetwork(class_2540 buffer) {
        class_2960 name = buffer.method_10810();
        int proud = buffer.readInt();
        int kill = buffer.readInt();
        int refine = buffer.readInt();
        List enchantments = buffer.method_34066(buf -> new EnchantmentDefinition(buf.method_10810(), buf.readByte()));
        List types = buffer.method_34066(buf -> SwordType.valueOf(buf.method_19772().toUpperCase()));
        return new RequestDefinition(name, proud, kill, refine, enchantments, types);
    }

    public void initItemStack(class_1799 blade) {
        ISlashBladeState state = CapabilitySlashBlade.getBladeState(blade).orElse(null);
        if (state == null) {
            return;
        }
        state.setNonEmpty();
        if (!this.name.equals((Object)SlashBlade.prefix("none"))) {
            state.setTranslationKey(this.getTranslationKey());
        }
        state.setProudSoulCount(this.getProudSoulCount());
        state.setKillCount(this.getKillCount());
        state.setRefine(this.getRefineCount());
        this.getEnchantments().forEach(enchantment -> blade.method_7978((class_6880)class_7887.method_46817().method_46762(class_7924.field_41265).method_46747(class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)enchantment.getEnchantmentID())), enchantment.getEnchantmentLevel()));
        this.defaultType.forEach(type -> {
            switch (type) {
                case BEWITCHED: {
                    state.setDefaultBewitched(true);
                    break;
                }
                case BROKEN: {
                    blade.method_7974(blade.method_7936() - 1);
                    state.setBroken(true);
                    break;
                }
                case SEALED: {
                    state.setSealed(true);
                    break;
                }
            }
        });
    }

    public boolean test(class_1799 blade) {
        if (blade == null || blade.method_7960()) {
            return false;
        }
        if (CapabilitySlashBlade.getBladeState(blade).isEmpty()) {
            return false;
        }
        ISlashBladeState state = CapabilitySlashBlade.getBladeState(blade).orElseThrow(NullPointerException::new);
        boolean nameCheck = this.name.equals((Object)SlashBlade.prefix("none")) ? state.getTranslationKey().isBlank() : state.getTranslationKey().equals(this.getTranslationKey());
        boolean proudCheck = state.getProudSoulCount() >= this.getProudSoulCount();
        boolean killCheck = state.getKillCount() >= this.getKillCount();
        boolean refineCheck = state.getRefine() >= this.getRefineCount();
        for (EnchantmentDefinition enchantment : this.getEnchantments()) {
            if (class_1890.method_8225((class_6880)class_7887.method_46817().method_46762(class_7924.field_41265).method_46747(class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)enchantment.getEnchantmentID())), (class_1799)blade) >= enchantment.getEnchantmentLevel()) continue;
            return false;
        }
        boolean types = SwordType.from(blade).containsAll(this.getDefaultType());
        return nameCheck && proudCheck && killCheck && refineCheck && types;
    }

    public String getTranslationKey() {
        return class_156.method_646((String)"item", (class_2960)this.getName());
    }

    public static class Builder {
        private class_2960 name = SlashBlade.prefix("none");
        private int proudCount = 0;
        private int killCount = 0;
        private int refineCount = 0;
        private final List<EnchantmentDefinition> enchantments = new ArrayList<EnchantmentDefinition>();
        private final List<SwordType> defaultType = new ArrayList<SwordType>();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder name(class_2960 name) {
            this.name = name;
            return this;
        }

        public Builder proudSoul(int proudCount) {
            this.proudCount = proudCount;
            return this;
        }

        public Builder killCount(int killCount) {
            this.killCount = killCount;
            return this;
        }

        public Builder refineCount(int refineCount) {
            this.refineCount = refineCount;
            return this;
        }

        public Builder addEnchantment(EnchantmentDefinition ... enchantments) {
            this.enchantments.addAll(Arrays.asList(enchantments));
            return this;
        }

        public Builder addSwordType(SwordType ... types) {
            this.defaultType.addAll(Arrays.asList(types));
            return this;
        }

        public RequestDefinition build() {
            return new RequestDefinition(this.name, this.proudCount, this.killCount, this.refineCount, this.enchantments, this.defaultType);
        }
    }
}

