/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.registry.slashblade;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import net.minecraft.class_2960;

public class PropertiesDefinition {
    public static final Codec<PropertiesDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("root_combo", (Object)ComboStateRegistry.getId(ComboStateRegistry.STANDBY)).forGetter(PropertiesDefinition::getComboRoot), (App)class_2960.field_25139.optionalFieldOf("slash_art", (Object)SlashArtsRegistry.SLASH_ARTS.method_10221((Object)SlashArtsRegistry.JUDGEMENT_CUT)).forGetter(PropertiesDefinition::getSpecialAttackType), (App)Codec.FLOAT.optionalFieldOf("attack_base", (Object)Float.valueOf(4.0f)).forGetter(PropertiesDefinition::getBaseAttackModifier), (App)Codec.INT.optionalFieldOf("max_damage", (Object)40).forGetter(PropertiesDefinition::getMaxDamage), (App)SwordType.CODEC.listOf().optionalFieldOf("sword_type", (Object)Lists.newArrayList()).forGetter(PropertiesDefinition::getDefaultType), (App)class_2960.field_25139.listOf().optionalFieldOf("special_effects", (Object)Lists.newArrayList()).forGetter(PropertiesDefinition::getSpecialEffects), (App)Codec.BOOL.optionalFieldOf("unbreakable", (Object)false).forGetter(PropertiesDefinition::isUnbreakable)).apply((Applicative)instance, PropertiesDefinition::new));
    private final class_2960 comboRoot;
    private final class_2960 specialAttackType;
    private final float baseAttackModifier;
    private final int maxDamage;
    private final List<SwordType> defaultType;
    private final List<class_2960> specialEffects;
    private final boolean unbreakable;

    private PropertiesDefinition(class_2960 comboRoot, class_2960 specialAttackType, float baseAttackModifier, int damage, List<SwordType> defaultType, List<class_2960> specialEffects, boolean unbreakable) {
        this.comboRoot = comboRoot;
        this.specialAttackType = specialAttackType;
        this.baseAttackModifier = baseAttackModifier;
        this.maxDamage = damage;
        this.defaultType = defaultType;
        this.specialEffects = specialEffects;
        this.unbreakable = unbreakable;
    }

    public List<class_2960> getSpecialEffects() {
        return this.specialEffects;
    }

    public class_2960 getComboRoot() {
        return this.comboRoot;
    }

    public class_2960 getSpecialAttackType() {
        return this.specialAttackType;
    }

    public float getBaseAttackModifier() {
        return this.baseAttackModifier;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public List<SwordType> getDefaultType() {
        return this.defaultType;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public static class Builder {
        private class_2960 comboRoot = ComboStateRegistry.getId(ComboStateRegistry.STANDBY);
        private class_2960 specialAttackType = SlashArtsRegistry.SLASH_ARTS.method_10221((Object)SlashArtsRegistry.JUDGEMENT_CUT);
        private float baseAttackModifier = 4.0f;
        private int maxDamage = 40;
        private List<SwordType> defaultType = Lists.newArrayList();
        private List<class_2960> specialEffects = Lists.newArrayList();
        private boolean unbreakable = false;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder rootComboState(class_2960 comboRoot) {
            this.comboRoot = comboRoot;
            return this;
        }

        public Builder slashArtsType(class_2960 specialAttackType) {
            this.specialAttackType = specialAttackType;
            return this;
        }

        public Builder baseAttackModifier(float baseAttackModifier) {
            this.baseAttackModifier = baseAttackModifier;
            return this;
        }

        public Builder maxDamage(int maxDamage) {
            this.maxDamage = maxDamage;
            return this;
        }

        public Builder defaultSwordType(List<SwordType> defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        public Builder addSpecialEffect(class_2960 se) {
            this.specialEffects.add(se);
            return this;
        }

        public Builder setUnbreakable(boolean unbreakable) {
            this.unbreakable = unbreakable;
            return this;
        }

        public PropertiesDefinition build() {
            return new PropertiesDefinition(this.comboRoot, this.specialAttackType, this.baseAttackModifier, this.maxDamage, this.defaultType, this.specialEffects, this.unbreakable);
        }
    }
}

