package mods.flammpfeil.slashblade;

import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import java.util.Objects;

public class SlashBladeCreativeGroup {
    public static void init() {

    }

    private static final class_1761 SLASHBLADE = FabricItemGroup.builder()
            .method_47321(class_2561.method_43471("itemGroup.slashblade")).method_47320(() -> {
                class_1799 stack = new class_1799(SBItems.SLASHBLADE);
                CapabilitySlashBlade.getBladeState(stack).ifPresent(s -> {
                    s.setModel(class_2960.method_60655(SlashBlade.MODID, "model/named/yamato.obj"));
                    s.setTexture(class_2960.method_60655(SlashBlade.MODID, "model/named/yamato.png"));
                });
                return stack;
            }).method_47317((features, output) -> {

                output.method_45421(SBItems.PROUDSOUL);
                output.method_45421(SBItems.PROUDSOUL_TINY);
                output.method_45421(SBItems.PROUDSOUL_INGOT);
                output.method_45421(SBItems.PROUDSOUL_SPHERE);

                output.method_45421(SBItems.PROUDSOUL_CRYSTAL);
                output.method_45421(SBItems.PROUDSOUL_TRAPEZOHEDRON);
                fillEnchantmentsSouls(features, output);
                fillSASpheres(output);
                output.method_45421(SBItems.BLADESTAND_1);
                output.method_45421(SBItems.BLADESTAND_1_W);
                output.method_45421(SBItems.BLADESTAND_2);
                output.method_45421(SBItems.BLADESTAND_2_W);
                output.method_45421(SBItems.BLADESTAND_S);
                output.method_45421(SBItems.BLADESTAND_V);

                output.method_45421(SBItems.SLASHBLADE_WOOD);
                output.method_45421(SBItems.SLASHBLADE_BAMBOO);
                output.method_45421(SBItems.SLASHBLADE_SILVERBAMBOO);
                output.method_45421(SBItems.SLASHBLADE_WHITE);
                output.method_45421(SBItems.SLASHBLADE);

                // fillBlades(features, output);
            }).method_47324();

    public static final class_1761 SLASHBLADE_GROUP = class_2378.method_10230(
            class_7923.field_44687,
            SlashBlade.prefix("slashblade"),
            SLASHBLADE
    );

    public static void onCreativeTagBuilding(class_1761 group, FabricItemGroupEntries entries) {
        SlashBlade.getSlashBladeDefinitionRegistry(entries.getContext().comp_1253())
                .method_42017()
                .sorted(SlashBladeDefinition.COMPARATOR).forEach(entry -> {
                    if (!Objects.equals(class_7923.field_44687.method_10221(group), entry.comp_349().getCreativeGroup()))
                        return;

                    var blade = entry.comp_349().getBlade(entries.getContext().comp_1253());
                    if (!blade.method_7960())
                        entries.method_45420(blade);
                });
    }

    @Deprecated
    private static void fillBlades(class_1761.class_8128 features, class_1761.class_7704 output) {
        SlashBlade.getSlashBladeDefinitionRegistry(features.comp_1253()).method_42017()
                .sorted(SlashBladeDefinition.COMPARATOR).forEach(entry -> {
                    var blade = entry.comp_349().getBlade(features.comp_1253());
                    if (!blade.method_7960())
                        output.method_45420(blade);
                });
    }

    private static void fillEnchantmentsSouls(class_1761.class_8128 features, class_1761.class_7704 output) {
        features.comp_1253().method_46762(class_7924.field_41265).method_46754().forEach(enchantment -> {
            class_1799 blade = new class_1799(SBItems.SLASHBLADE);
            var holder = features.comp_1253().method_46762(class_7924.field_41265).method_46747(enchantment);
            if (blade.canBeEnchantedWith(holder, EnchantingContext.ACCEPTABLE)) {
                class_1799 soul = new class_1799(SBItems.PROUDSOUL_TINY);
                soul.method_7978(holder, 1);
                output.method_45420(soul);
            }

        });
    }

    private static void fillSASpheres(class_1761.class_7704 output) {
        SlashArtsRegistry.SLASH_ARTS.forEach(slashArts -> {
            class_2960 key = SlashArtsRegistry.SLASH_ARTS.method_10221(slashArts);
            if (slashArts.equals(SlashArtsRegistry.NONE) || key == null)
                return;
            class_1799 sphere = new class_1799(SBItems.PROUDSOUL_SPHERE);
            class_9279.method_57452(class_9334.field_49628, sphere,
                    tag -> tag.method_10582("SpecialAttackType", key.toString()));
            output.method_45420(sphere);
        });
    }
}
