package mods.flammpfeil.slashblade.event.bladestand;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.data.builtin.SlashBladeBuiltInRegistry;
import mods.flammpfeil.slashblade.data.tag.SlashBladeItemTags;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.recipe.RequestDefinition;
import mods.flammpfeil.slashblade.recipe.SlashBladeIngredient;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1268;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

import static cn.sh1rocu.slashblade.api.event.BaseEvent.LOW;

public class BlandStandEventHandler {
    public static void init() {
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventKoseki);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventChangeSE);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventChangeSA);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventCopySE);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventCopySA);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(LOW, BlandStandEventHandler::eventProudSoulEnchantment);
        PreCopySpecialAttackFromBladeEvent.CALLBACK.register(BlandStandEventHandler::copySAEnchantmentCheck);
        ProudSoulEnchantmentEvent.CALLBACK.register(BlandStandEventHandler::proudSoulEnchantmentProbabilityCheck);
    }

    public static void eventKoseki(SlashBladeEvent.BladeStandAttackEvent event) {
        var slashBladeDefinitionRegistry = SlashBlade.getSlashBladeDefinitionRegistry(event.getBladeStand().method_37908());
        if (!slashBladeDefinitionRegistry.method_10250(SlashBladeBuiltInRegistry.KOSEKI.method_29177())) {
            return;
        }
        if (!(event.getDamageSource().method_5529() instanceof class_1528)) {
            return;
        }
        if (!event.getDamageSource().method_48789(class_8103.field_42249)) {
            return;
        }
        var in = SlashBladeIngredient.of(RequestDefinition.Builder.newInstance().build());
        if (!in.test(event.getBlade())) {
            return;
        }
        event.getBladeStand().method_6935(Objects.requireNonNull(slashBladeDefinitionRegistry.method_29107(SlashBladeBuiltInRegistry.KOSEKI)).getBlade(event.getBladeStand().method_56673()));
        event.setCanceled(true);
    }

    public static void eventChangeSE(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().method_5529() instanceof class_3222 player)) {
            return;
        }
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_1799 blade = event.getBlade();
        if (blade.method_7960()) {
            return;
        }
        if (!stack.method_31573(SlashBladeItemTags.CAN_CHANGE_SE)) {
            return;
        }
        var world = player.method_37908();
        var state = event.getSlashBladeState();

        class_9279 data = stack.method_57824(class_9334.field_49628);

        if (data == null) {
            return;
        }

        class_2487 tag = data.method_57461();
        if (tag.method_10545("SpecialEffectType")) {
            var bladeStand = event.getBladeStand();
            class_2960 SEKey = class_2960.method_60654(tag.method_10558("SpecialEffectType"));
            if (!(SpecialEffectsRegistry.SPECIAL_EFFECT.method_10250(SEKey))) {
                return;
            }
            if (state.hasSpecialEffect(SEKey)) {
                return;
            }

            BladeChangeSpecialEffectEvent e = new BladeChangeSpecialEffectEvent(
                    blade, state, SEKey, event);

            if (!player.method_7337()) {
                e.setShrinkCount(1);
            }

            BladeChangeSpecialEffectEvent.CALLBACK.invoker().onChangeSpecialEffect(e);
            if (e.isCanceled()) {
                return;
            }

            if (stack.method_7947() < e.getShrinkCount()) {
                return;
            }

            state.addSpecialEffect(e.getSEKey());

            class_5819 random = player.method_59922();

            spawnSucceedEffects(world, bladeStand, random);

            stack.method_7934(e.getShrinkCount());

            event.setCanceled(true);
        }
    }

    public static void eventChangeSA(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().method_5529() instanceof class_3222 player)) {
            return;
        }
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_9279 data = stack.method_57824(class_9334.field_49628);

        if (!stack.method_31573(SlashBladeItemTags.CAN_CHANGE_SA) || data == null) {
            return;
        }

        class_2487 tag = data.method_57461();
        if (!tag.method_10545("SpecialAttackType"))
            return;

        class_2960 SAKey = class_2960.method_60654(tag.method_10558("SpecialAttackType"));
        if (!SlashArtsRegistry.SLASH_ARTS.method_10250(SAKey)) {
            return;
        }

        class_1799 blade = event.getBlade();

        CapabilitySlashBlade.getBladeState(blade).ifPresent(state -> {
            if (!SAKey.equals(state.getSlashArtsKey())) {

                BladeChangeSpecialAttackEvent e = new BladeChangeSpecialAttackEvent(
                        blade, state, SAKey, event);

                if (!player.method_7337()) {
                    e.setShrinkCount(1);
                }

                BladeChangeSpecialAttackEvent.CALLBACK.invoker().onChangeSpecialAttack(e);
                if (e.isCanceled()) {
                    return;
                }

                if (stack.method_7947() < e.getShrinkCount()) {
                    return;
                }

                state.setSlashArtsKey(e.getSAKey());

                class_5819 random = player.method_59922();
                BladeStandEntity bladeStand = event.getBladeStand();

                spawnSucceedEffects(player.method_37908(), bladeStand, random);

                stack.method_7934(e.getShrinkCount());
            }
        });
        event.setCanceled(true);
    }

    public static void eventCopySE(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().method_5529() instanceof class_3222 player)) {
            return;
        }
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_1799 blade = event.getBlade();
        if (blade.method_7960()) {
            return;
        }
        if (!stack.method_31573(SlashBladeItemTags.CAN_COPY_SE)) {
            return;
        }

        class_9279 data = stack.method_57824(class_9334.field_49628);
        if (data == null)
            return;

        class_2487 crystalTag = data.method_57461();
        if (crystalTag.method_10545("SpecialEffectType")) {
            return;
        }

        var world = player.method_37908();

        if (world.method_8608())
            return;

        var state = event.getSlashBladeState();
        var bladeStand = event.getBladeStand();
        var specialEffects = state.getSpecialEffects();

        for (var se : specialEffects) {
            if (!SpecialEffectsRegistry.SPECIAL_EFFECT.method_10250(se)) {
                continue;
            }

            PreCopySpecialEffectFromBladeEvent pe = new PreCopySpecialEffectFromBladeEvent(
                    blade, state, se, event, Objects.requireNonNull(SpecialEffectsRegistry.SPECIAL_EFFECT.method_10223(se)).isRemovable(),
                    Objects.requireNonNull(SpecialEffectsRegistry.SPECIAL_EFFECT.method_10223(se)).isCopiable());

            if (!player.method_7337()) {
                pe.setShrinkCount(1);
            }

            PreCopySpecialEffectFromBladeEvent.CALLBACK.invoker().onPreCopySpecialEffect(pe);
            if (pe.isCanceled()) {
                return;
            }

            if (stack.method_7947() < pe.getShrinkCount()) {
                continue;
            }

            if (!pe.isCopiable()) {
                continue;
            }

            class_1799 orb = new class_1799(SBItems.PROUDSOUL_CRYSTAL);
            class_9279.method_57452(class_9334.field_49628, orb, tag -> tag.method_10582("SpecialEffectType", se.toString()));
            stack.method_7934(pe.getShrinkCount());

            class_5819 random = player.method_59922();

            spawnSucceedEffects(world, bladeStand, random);

            class_1542 itemEntity = player.method_7328(orb, true);

            if (pe.isRemovable()) {
                state.removeSpecialEffect(se);
            }

            CopySpecialEffectFromBladeEvent e = new CopySpecialEffectFromBladeEvent(
                    pe, orb, itemEntity);

            CopySpecialEffectFromBladeEvent.CALLBACK.invoker().onCopySpecialEffect(e);

            event.setCanceled(true);
            return;
        }
    }

    public static void eventCopySA(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().method_5529() instanceof class_1657 player)) {
            return;
        }
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_1799 blade = event.getBlade();
        if (blade.method_7960()) {
            return;
        }
        if (!stack.method_31573(SlashBladeItemTags.CAN_COPY_SA) || !stack.method_7942()) {
            return;
        }
        var world = player.method_37908();

        if (world.method_8608())
            return;

        var state = event.getSlashBladeState();
        var bladeStand = event.getBladeStand();
        class_2960 SA = state.getSlashArtsKey();
        if (SA != null && !SA.equals(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.NONE))) {

            PreCopySpecialAttackFromBladeEvent pe = new PreCopySpecialAttackFromBladeEvent(
                    blade, state, SA, event);

            if (!player.method_7337()) {
                pe.setShrinkCount(1);
            }

            PreCopySpecialAttackFromBladeEvent.CALLBACK.invoker().onPreCopySpecialAttack(pe);
            if (pe.isCanceled()) {
                return;
            }

            if (stack.method_7947() < pe.getShrinkCount()) {
                return;
            }

            class_1799 orb = new class_1799(SBItems.PROUDSOUL_SPHERE);
            class_9279.method_57452(class_9334.field_49628, orb, tag -> tag.method_10582("SpecialAttackType", state.getSlashArtsKey().toString()));

            stack.method_7934(pe.getShrinkCount());

            class_5819 random = player.method_59922();

            spawnSucceedEffects(world, bladeStand, random);

            class_1542 itemEntity = player.method_7328(orb, true);

            CopySpecialAttackFromBladeEvent e = new CopySpecialAttackFromBladeEvent(
                    pe, orb, itemEntity);

            CopySpecialAttackFromBladeEvent.CALLBACK.invoker().onCopySpecialAttack(e);

            event.setCanceled(true);
        }
    }

    public static void eventProudSoulEnchantment(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().method_5529() instanceof class_1657 player)) {
            return;
        }

        if (player.method_37908().method_8608())
            return;

        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_1799 blade = event.getBlade();

        if (blade.method_7960()) {
            return;
        }

        if (!stack.method_31573(SlashBladeItemTags.PROUD_SOULS)) {
            return;
        }

        if (!stack.method_7942()) {
            return;
        }
        var world = player.method_37908();
        var random = world.method_8409();
        var bladeStand = event.getBladeStand();

        AtomicInteger totalShrinkCount = new AtomicInteger(0);
        if (!player.method_7337()) {
            totalShrinkCount.set(1);
        }

        AtomicBoolean success = new AtomicBoolean(false);

        class_1890.method_57532(stack).method_57534().forEach((enchantment) -> {
            if (event.isCanceled()) {
                return;
            }
            if (!blade.canBeEnchantedWith(enchantment, EnchantingContext.ACCEPTABLE)) {
                return;
            }

            var probability = 1.0F;
            if (stack.method_31574(SBItems.PROUDSOUL_TINY)) {
                probability = 0.25F;
            }
            if (stack.method_31574(SBItems.PROUDSOUL)) {
                probability = 0.5F;
            }
            if (stack.method_31574(SBItems.PROUDSOUL_INGOT)) {
                probability = 0.75F;
            }

            int enchantLevel = Math.min(enchantment.comp_349().method_8183(),
                    class_1890.method_8225(enchantment, blade) + 1);

            ProudSoulEnchantmentEvent e = new ProudSoulEnchantmentEvent(
                    blade, event.getSlashBladeState(), enchantment, enchantLevel, false, probability,
                    totalShrinkCount.get(), event);

            ProudSoulEnchantmentEvent.CALLBACK.invoker().onProudSoulEnchantment(e);
            if (e.isCanceled()) {
                return;
            }

            totalShrinkCount.set(e.getTotalShrinkCount());

            class_1890.method_57531(blade, mutable -> mutable.method_57547(e.getEnchantment(), e.getEnchantLevel()));
            success.set(true);

            if (!e.willTryNextEnchant()) {
                event.setCanceled(true);
            }
        });

        if (stack.method_7947() < totalShrinkCount.get()) {
            return;
        }
        stack.method_7934(totalShrinkCount.get());

        if (success.get()) {
            spawnSucceedEffects(world, bladeStand, random);
        }

        event.setCanceled(true);
    }


    public static void copySAEnchantmentCheck(PreCopySpecialAttackFromBladeEvent event) {
        SlashBladeEvent.BladeStandAttackEvent oriEvent = event.getOriginalEvent();
        if (oriEvent == null) {
            return;
        }
        class_1657 player = (class_1657) oriEvent.getDamageSource().method_5529();
        if (player != null) {
            class_1799 stack = player.method_5998(class_1268.field_5808);

            class_1799 blade = event.getBlade();
            Set<class_6880<class_1887>> enchantments = class_1890.method_57532(stack).method_57534();
            boolean flag = false;
            for (class_6880<class_1887> e : enchantments) {
                if (class_1890.method_8225(e, blade) >= e.comp_349().method_8183()) {
                    flag = true;
                }
            }
            if (!flag) {
                event.setCanceled(true);
            }
        }
    }

    public static void proudSoulEnchantmentProbabilityCheck(ProudSoulEnchantmentEvent event) {
        SlashBladeEvent.BladeStandAttackEvent oriEvent = event.getOriginalEvent();
        if (oriEvent == null) {
            return;
        }
        class_1657 player = (class_1657) oriEvent.getDamageSource().method_5529();
        if (player != null) {
            class_1937 world = player.method_37908();
            class_5819 random = world.method_8409();

            if (random.method_43057() > event.getProbability()) {
                event.setCanceled(true);
            }
        }
    }

    private static void spawnSucceedEffects(class_1937 world, BladeStandEntity bladeStand, class_5819 random) {
        if (!(world instanceof class_3218 serverLevel)) {
            return;
        }
        // 音效
        serverLevel.method_45445(
                bladeStand,
                bladeStand.method_59940(),
                class_3417.field_14792,
                class_3419.field_15245,
                0.5f,
                0.8f
        );

        // 粒子效果
        for (int i = 0; i < 32; ++i) {
            double xDist = (random.method_43057() * 2.0F - 1.0F);
            double yDist = (random.method_43057() * 2.0F - 1.0F);
            double zDist = (random.method_43057() * 2.0F - 1.0F);
            if (xDist * xDist + yDist * yDist + zDist * zDist <= 1.0D) {
                double x = bladeStand.method_23316(xDist / 4.0D);
                double y = bladeStand.method_23323(0.5D + yDist / 4.0D);
                double z = bladeStand.method_23324(zDist / 4.0D);
                serverLevel.method_14199(
                        class_2398.field_11214,
                        x, y, z,
                        0,
                        xDist, yDist + 0.2D, zDist,
                        1);
            }
        }
    }
}
