package mods.flammpfeil.slashblade.network;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.EnumSet;

public record MoveCommandPacket(int command) implements class_8710 {
    private static final class_2960 ID = SlashBlade.prefix("c2s_move_command");
    public static final class_9154<MoveCommandPacket> TYPE = new class_9154<>(ID);

    public static final class_9139<class_9129, MoveCommandPacket> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48550,
            MoveCommandPacket::command,
            MoveCommandPacket::new
    );

    public static void handle(MoveCommandPacket payload, ServerPlayNetworking.Context context) {
        var sender = context.player();
        context.server().execute(() -> {
            // do stuff
            class_1799 stack = sender.method_5998(class_1268.field_5808);
            if (stack.method_7960())
                return;
            if (CapabilitySlashBlade.getBladeState(stack).isEmpty())
                return;

            CapabilityInputState.INPUT_STATE.maybeGet(sender).ifPresent((state) -> {
                EnumSet<InputCommand> old = state.getCommands().clone();

                state.getCommands().clear();
                state.getCommands().addAll(EnumSetConverter.convertToEnumSet(InputCommand.class, payload.command));

                EnumSet<InputCommand> current = state.getCommands().clone();

                long currentTime = sender.method_37908().method_8510();
                current.forEach(c -> {
                    if (!old.contains(c))
                        state.getLastPressTimes().put(c, currentTime);
                });

                InputCommandEvent.onInputChange(sender, state, old, current);

            });
        });
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}