/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntityBlisteringSwords;
import mods.flammpfeil.slashblade.entity.EntityHeavyRainSwords;
import mods.flammpfeil.slashblade.entity.EntitySpiralSwords;
import mods.flammpfeil.slashblade.entity.EntityStormSwords;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.init.SBStatTypes;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.RayTraceHelper;
import mods.flammpfeil.slashblade.util.StatHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_234;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class SummonedSwordArts {
    public static final class_2960 ADVANCEMENT_SUMMONEDSWORDS = class_2960.method_60655((String)"slashblade", (String)"arts/shooting/summonedswords");
    public static final class_2960 ADVANCEMENT_SPIRAL_SWORDS = class_2960.method_60655((String)"slashblade", (String)"arts/shooting/spiral_swords");
    public static final class_2960 ADVANCEMENT_STORM_SWORDS = class_2960.method_60655((String)"slashblade", (String)"arts/shooting/storm_swords");
    public static final class_2960 ADVANCEMENT_BLISTERING_SWORDS = class_2960.method_60655((String)"slashblade", (String)"arts/shooting/blistering_swords");
    public static final class_2960 ADVANCEMENT_HEAVY_RAIN_SWORDS = class_2960.method_60655((String)"slashblade", (String)"arts/shooting/heavy_rain_swords");

    public static SummonedSwordArts getInstance() {
        return SingletonHolder.instance;
    }

    private SummonedSwordArts() {
    }

    public void register() {
        InputCommandEvent.CALLBACK.register(this::onInputChange);
    }

    public void onInputChange(InputCommandEvent event) {
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        class_3222 sender = event.getEntity();
        class_1799 blade = sender.method_6047();
        ISlashBladeState bladeState = CapabilitySlashBlade.getBladeState(blade).orElse(new SlashBladeState(blade));
        if (bladeState.isBroken() || bladeState.isSealed() || !SwordType.from(blade).contains((Object)SwordType.BEWITCHED)) {
            return;
        }
        class_6880.class_6883 holder = sender.method_56673().method_46762(class_7924.field_41265).method_46747(class_1893.field_9103);
        int powerLevel = class_1890.method_8225((class_6880)holder, (class_1799)blade);
        if (powerLevel <= 0) {
            return;
        }
        InputCommand targetCommnad = InputCommand.M_DOWN;
        boolean onDown = !old.contains((Object)targetCommnad) && current.contains((Object)targetCommnad);
        Long pressTime = event.getState().getLastPressTime(targetCommnad);
        if (onDown) {
            CapabilityInputState.INPUT_STATE.maybeGet((Object)sender).ifPresent(input -> {
                input.getScheduler().schedule("SpiralSwords", pressTime + 10L, (class_234<class_1309>)((class_234)(rawEntity, queue, now) -> this.performSpiralSwords(powerLevel, pressTime, (class_1309)rawEntity)));
                input.getScheduler().schedule("StormSwords", pressTime + 10L, (class_234<class_1309>)((class_234)(rawEntity, queue, now) -> this.performStormSwords(powerLevel, pressTime, (class_1309)rawEntity)));
                input.getScheduler().schedule("BlisteringSwords", pressTime + 10L, (class_234<class_1309>)((class_234)(rawEntity, queue, now) -> this.performBlisteringSwords(powerLevel, pressTime, (class_1309)rawEntity, now)));
                input.getScheduler().schedule("HeavyRainSwords", pressTime + 10L, (class_234<class_1309>)((class_234)(rawEntity, queue, now) -> this.performHeavyRains(powerLevel, pressTime, (class_1309)rawEntity, now)));
            });
            CapabilitySlashBlade.getBladeState(blade).ifPresent(state -> {
                if (state.getProudSoulCount() < (Integer)SlashBladeConfig.SUMMON_SWORD_COST.get()) {
                    return;
                }
                state.setProudSoulCount(state.getProudSoulCount() - (Integer)SlashBladeConfig.SUMMON_SWORD_COST.get());
                AdvancementHelper.grantCriterion(sender, ADVANCEMENT_SUMMONEDSWORDS);
                Optional<class_1297> foundTarget = this.findTarget(sender, state.getTargetEntity(sender.method_37908()));
                class_1937 worldIn = sender.method_37908();
                class_243 targetPos = foundTarget.map(e -> new class_243(e.method_23317(), e.method_23318() + (double)e.method_5751() * 0.5, e.method_23321())).orElseGet(() -> {
                    class_243 start = sender.method_5836(1.0f);
                    class_243 end = start.method_1019(sender.method_5720().method_1021(40.0));
                    class_3965 result = worldIn.method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)sender));
                    return result.method_17784();
                });
                int counter = StatHelper.increase(sender, SBStatTypes.SWORD_SUMMONED, 1);
                boolean sided = counter % 2 == 0;
                EntityAbstractSummonedSword ss = new EntityAbstractSummonedSword((class_1299<? extends Projectile>)SBEntityTypes.SUMMONED_SWORD, worldIn);
                class_243 pos = sender.method_5836(1.0f).method_1019(VectorHelper.getVectorForRotation(0.0f, sender.method_5705(0.0f) + 90.0f).method_1021(sided ? 1.0 : -1.0));
                ss.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
                ss.setDamage(powerLevel);
                class_243 dir = targetPos.method_1020(pos).method_1029();
                ss.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 3.0f, 0.0f);
                ss.method_7432((class_1297)sender);
                ss.setColor(state.getColorCode());
                ss.setRoll(sender.method_59922().method_43057() * 360.0f);
                worldIn.method_8649((class_1297)ss);
                sender.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2f, 1.45f);
            });
        }
    }

    public Optional<class_1297> findTarget(class_3222 sender, class_1297 lockedT) {
        Optional<class_1297> foundTarget = Stream.of(Optional.ofNullable(lockedT), RayTraceHelper.rayTrace(sender.method_37908(), (class_1297)sender, sender.method_5836(1.0f), sender.method_5720(), 12.0, 12.0, e -> true).filter(r -> r.method_17783() == class_239.class_240.field_1331).filter(r -> {
            class_3966 er = (class_3966)r;
            class_1297 target = er.method_17782();
            boolean isMatch = true;
            if (target instanceof class_1309) {
                isMatch = TargetSelector.lockon.method_18419((class_1309)sender, (class_1309)target);
            }
            if (target instanceof IShootable) {
                isMatch = ((IShootable)target).getShooter() != sender;
            }
            return isMatch;
        }).map(r -> ((class_3966)r).method_17782())).filter(Optional::isPresent).map(Optional::get).findFirst();
        return foundTarget;
    }

    class_243 calculateViewVector(float x, float y) {
        float f = x * ((float)Math.PI / 180);
        float f1 = -y * ((float)Math.PI / 180);
        float f2 = class_3532.method_15362((float)f1);
        float f3 = class_3532.method_15374((float)f1);
        float f4 = class_3532.method_15362((float)f);
        float f5 = class_3532.method_15374((float)f);
        return new class_243((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    private void performSpiralSwords(int powerLevel, Long pressTime, class_1309 rawEntity) {
        if (!(rawEntity instanceof class_3222)) {
            return;
        }
        class_3222 entity = (class_3222)rawEntity;
        InputCommand targetCommnad = InputCommand.M_DOWN;
        boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet((Object)entity).filter(input -> input.getCommands().contains((Object)targetCommnad) && (!InputCommand.anyMatch(input.getCommands(), InputCommand.move) || !input.getCommands().contains((Object)InputCommand.SNEAK)) && input.getLastPressTime(targetCommnad) == pressTime).isPresent();
        if (!inputSucceed) {
            return;
        }
        boolean alreadySummoned = entity.method_5685().stream().anyMatch(e -> e instanceof EntitySpiralSwords);
        if (alreadySummoned) {
            List<class_1297> list = entity.method_5685().stream().filter(e -> e instanceof EntitySpiralSwords).toList();
            list.stream().forEach(e -> ((EntitySpiralSwords)e).doFire());
        } else {
            CapabilitySlashBlade.getBladeState(entity.method_6047()).ifPresent(state -> {
                if (state.getProudSoulCount() < (Integer)SlashBladeConfig.SUMMON_SWORD_ART_COST.get()) {
                    return;
                }
                state.setProudSoulCount(state.getProudSoulCount() - (Integer)SlashBladeConfig.SUMMON_SWORD_ART_COST.get());
                AdvancementHelper.grantCriterion(entity, ADVANCEMENT_SPIRAL_SWORDS);
                class_1937 worldIn = entity.method_37908();
                int rank = CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)entity).map(r -> r.getRank((long)worldIn.method_8510()).level).orElse(0);
                int count = 6;
                if (IConcentrationRank.ConcentrationRanks.S.level <= rank) {
                    count = 8;
                }
                for (int i = 0; i < count; ++i) {
                    EntitySpiralSwords ss = new EntitySpiralSwords((class_1299<? extends Projectile>)SBEntityTypes.SPIRAL_SWORDS, worldIn);
                    ss.method_33574(entity.method_19538());
                    ss.method_7432((class_1297)entity);
                    ss.setColor(state.getColorCode());
                    ss.setRoll(0.0f);
                    ss.setDamage(powerLevel);
                    ss.method_5873((class_1297)entity, true);
                    ss.setDelay(360 / count * i);
                    worldIn.method_8649((class_1297)ss);
                    entity.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2f, 1.45f);
                }
            });
        }
    }

    private void performStormSwords(int powerLevel, Long pressTime, class_1309 rawEntity) {
        if (!(rawEntity instanceof class_3222)) {
            return;
        }
        class_3222 entity = (class_3222)rawEntity;
        InputCommand targetCommnad = InputCommand.M_DOWN;
        boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet((Object)entity).filter(input -> input.getCommands().contains((Object)targetCommnad) && input.getCommands().contains((Object)InputCommand.SNEAK) && input.getCommands().contains((Object)InputCommand.BACK) && !input.getCommands().contains((Object)InputCommand.FORWARD) && input.getLastPressTime(targetCommnad) == pressTime).isPresent();
        if (!inputSucceed) {
            return;
        }
        CapabilitySlashBlade.getBladeState(entity.method_6047()).ifPresent(state -> {
            class_1937 worldIn = entity.method_37908();
            class_1297 target = state.getTargetEntity(worldIn);
            if (target == null || !target.method_5805() || target.method_31481()) {
                return;
            }
            if (state.getProudSoulCount() < (Integer)SlashBladeConfig.SUMMON_SWORD_ART_COST.get()) {
                return;
            }
            state.setProudSoulCount(state.getProudSoulCount() - (Integer)SlashBladeConfig.SUMMON_SWORD_ART_COST.get());
            AdvancementHelper.grantCriterion(entity, ADVANCEMENT_STORM_SWORDS);
            int rank = CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)entity).map(r -> r.getRank((long)worldIn.method_8510()).level).orElse(0);
            int count = 6;
            if (IConcentrationRank.ConcentrationRanks.S.level <= rank) {
                count = 8;
            }
            for (int i = 0; i < count; ++i) {
                EntityStormSwords ss = new EntityStormSwords((class_1299<? extends Projectile>)SBEntityTypes.STORM_SWORDS, worldIn);
                ss.method_33574(entity.method_19538());
                ss.method_7432((class_1297)entity);
                ss.setColor(state.getColorCode());
                ss.setRoll(0.0f);
                ss.setDamage(powerLevel);
                ss.method_5873(target, true);
                ss.setDelay(360 / count * i);
                worldIn.method_8649((class_1297)ss);
                entity.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2f, 1.45f);
            }
        });
    }

    private void performBlisteringSwords(int powerLevel, Long pressTime, class_1309 rawEntity, long now) {
        if (!(rawEntity instanceof class_3222)) {
            return;
        }
        class_3222 entity = (class_3222)rawEntity;
        InputCommand targetCommnad = InputCommand.M_DOWN;
        boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet((Object)entity).filter(input -> input.getCommands().contains((Object)targetCommnad) && input.getCommands().contains((Object)InputCommand.SNEAK) && input.getCommands().contains((Object)InputCommand.FORWARD) && input.getLastPressTime(InputCommand.BACK) + 20L < now && input.getLastPressTime(targetCommnad) == pressTime).isPresent();
        if (!inputSucceed) {
            return;
        }
        CapabilitySlashBlade.getBladeState(entity.method_6047()).ifPresent(state -> {
            class_1937 worldIn = entity.method_37908();
            if (state.getProudSoulCount() < (Integer)SlashBladeConfig.SUMMON_SWORD_ART_COST.get()) {
                return;
            }
            state.setProudSoulCount(state.getProudSoulCount() - (Integer)SlashBladeConfig.SUMMON_SWORD_ART_COST.get());
            AdvancementHelper.grantCriterion(entity, ADVANCEMENT_BLISTERING_SWORDS);
            int rank = CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)entity).map(r -> r.getRank((long)worldIn.method_8510()).level).orElse(0);
            int count = 6;
            if (IConcentrationRank.ConcentrationRanks.S.level <= rank) {
                count = 8;
            }
            for (int i = 0; i < count; ++i) {
                EntityBlisteringSwords ss = new EntityBlisteringSwords((class_1299<? extends Projectile>)SBEntityTypes.BLISTERING_SWORDS, worldIn);
                ss.method_33574(entity.method_19538());
                ss.method_7432((class_1297)entity);
                ss.setColor(state.getColorCode());
                ss.setRoll(0.0f);
                ss.setDamage(powerLevel);
                ss.method_5873((class_1297)entity, true);
                ss.setDelay(i);
                worldIn.method_8649((class_1297)ss);
                entity.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2f, 1.45f);
            }
        });
    }

    private void performHeavyRains(int powerLevel, Long pressTime, class_1309 rawEntity, long now) {
        if (!(rawEntity instanceof class_3222)) {
            return;
        }
        class_3222 entity = (class_3222)rawEntity;
        InputCommand targetCommnad = InputCommand.M_DOWN;
        boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet((Object)entity).filter(input -> input.getCommands().contains((Object)targetCommnad) && input.getCommands().contains((Object)InputCommand.SNEAK) && input.getCommands().contains((Object)InputCommand.FORWARD) && input.getLastPressTime(InputCommand.BACK) + 30L > now && input.getLastPressTime(targetCommnad) == pressTime).isPresent();
        if (!inputSucceed) {
            return;
        }
        CapabilitySlashBlade.getBladeState(entity.method_6047()).ifPresent(state -> {
            class_243 basePos;
            class_1937 worldIn = entity.method_37908();
            class_1297 target = state.getTargetEntity(worldIn);
            if (state.getProudSoulCount() < (Integer)SlashBladeConfig.SUMMON_SWORD_ART_COST.get()) {
                return;
            }
            state.setProudSoulCount(state.getProudSoulCount() - (Integer)SlashBladeConfig.SUMMON_SWORD_ART_COST.get());
            AdvancementHelper.grantCriterion(entity, ADVANCEMENT_HEAVY_RAIN_SWORDS);
            int rank = CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)entity).map(r -> r.getRank((long)worldIn.method_8510()).level).orElse(0);
            if (target != null) {
                basePos = target.method_19538();
            } else {
                class_243 forwardDir = this.calculateViewVector(0.0f, entity.method_36454());
                basePos = entity.method_30950(0.0f).method_1019(forwardDir.method_1021(5.0));
            }
            float yOffset = 7.0f;
            basePos = basePos.method_1031(0.0, (double)yOffset, 0.0);
            EntityHeavyRainSwords ss = new EntityHeavyRainSwords((class_1299<? extends Projectile>)SBEntityTypes.HEAVY_RAIN_SWORDS, worldIn);
            ss.method_7432((class_1297)entity);
            ss.setColor(state.getColorCode());
            ss.setRoll(0.0f);
            ss.setDamage(powerLevel);
            ss.method_5873((class_1297)entity, true);
            ss.setDelay(0);
            ss.method_33574(basePos);
            ss.method_36457(-90.0f);
            worldIn.method_8649((class_1297)ss);
            int count = 9 + Math.min(rank - 1, 0);
            int multiplier = 2;
            for (int i = 0; i < count; ++i) {
                for (int l = 0; l < multiplier; ++l) {
                    EntityHeavyRainSwords ss2 = new EntityHeavyRainSwords((class_1299<? extends Projectile>)SBEntityTypes.HEAVY_RAIN_SWORDS, worldIn);
                    ss2.method_7432((class_1297)entity);
                    ss2.setColor(state.getColorCode());
                    ss2.setRoll(0.0f);
                    ss2.setDamage(powerLevel);
                    ss2.method_5873((class_1297)entity, true);
                    ss2.setDelay(i);
                    ss2.setSpread(basePos);
                    ss2.method_36457(-90.0f);
                    worldIn.method_8649((class_1297)ss2);
                    entity.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2f, 1.45f);
                }
            }
        });
    }

    private static final class SingletonHolder {
        private static final SummonedSwordArts instance = new SummonedSwordArts();

        private SingletonHolder() {
        }
    }
}

