/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import mods.flammpfeil.slashblade.init.DefaultResources;
import net.minecraft.class_1059;
import net.minecraft.class_2960;

public class BladeMotionManager {
    MmdVmdMotionMc defaultMotion;
    LoadingCache<class_2960, MmdVmdMotionMc> cache;

    public static BladeMotionManager getInstance() {
        return SingletonHolder.instance;
    }

    private BladeMotionManager() {
        try {
            this.defaultMotion = new MmdVmdMotionMc(DefaultResources.ExMotionLocation);
        }
        catch (IOException | MmdException e) {
            e.printStackTrace();
        }
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<class_2960, MmdVmdMotionMc>(){

            public MmdVmdMotionMc load(class_2960 key) throws Exception {
                try {
                    return new MmdVmdMotionMc(key);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return BladeMotionManager.this.defaultMotion;
                }
            }
        }, (Executor)Executors.newCachedThreadPool()));
    }

    public void reload(class_1059 atlas) {
        this.cache.invalidateAll();
        try {
            this.defaultMotion = new MmdVmdMotionMc(DefaultResources.ExMotionLocation);
        }
        catch (IOException | MmdException e) {
            e.printStackTrace();
        }
    }

    public MmdVmdMotionMc getMotion(class_2960 loc) {
        if (loc != null) {
            try {
                return (MmdVmdMotionMc)this.cache.get((Object)loc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.defaultMotion;
    }

    private static final class SingletonHolder {
        private static final BladeMotionManager instance = new BladeMotionManager();

        private SingletonHolder() {
        }
    }
}

