/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.model.obj;

import java.util.function.BiFunction;
import mods.flammpfeil.slashblade.client.renderer.model.obj.TextureCoordinate;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Vertex;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Face {
    public static final BiFunction<Vector4f, Integer, Integer> alphaNoOverride = (v, a) -> a;
    public static final BiFunction<Vector4f, Integer, Integer> alphaOverrideYZZ = (v, a) -> v.y() == 0.0f ? 0 : a;
    public static BiFunction<Vector4f, Integer, Integer> alphaOverride = alphaNoOverride;
    public static final Vector4f uvDefaultOperator;
    public static Vector4f uvOperator;
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    public static void setAlphaOverride(BiFunction<Vector4f, Integer, Integer> alphaOverride) {
        Face.alphaOverride = alphaOverride;
    }

    public static void resetAlphaOverride() {
        alphaOverride = alphaNoOverride;
    }

    public static void setUvOperator(float uScale, float vScale, float uOffset, float vOffset) {
        uvOperator = new Vector4f(uScale, vScale, uOffset, vOffset);
    }

    public static void resetUvOperator() {
        uvOperator = uvDefaultOperator;
    }

    @Environment(value=EnvType.CLIENT)
    public void addFaceForRender(class_4588 tessellator, class_4587 matrixStack, int light, int color) {
        this.addFaceForRender(tessellator, 5.0E-4f, matrixStack.method_23760().method_23761(), light, color);
    }

    @Environment(value=EnvType.CLIENT)
    public void addFaceForRender(class_4588 tessellator, float textureOffset, Matrix4f transform, int light, int color) {
        int i;
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u * uvOperator.x() + uvOperator.z();
                averageV += this.textureCoordinates[i].v * uvOperator.y() + uvOperator.w();
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        for (i = 0; i < this.vertices.length; ++i) {
            this.putVertex(tessellator, i, transform, textureOffset, averageU, averageV, light, color);
        }
    }

    void putVertex(class_4588 wr, int i, Matrix4f transform, float textureOffset, float averageU, float averageV, int light, int color) {
        Vector3f vector3f;
        wr.method_22918(transform, this.vertices[i].x, this.vertices[i].y, this.vertices[i].z);
        wr.method_1336(class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), alphaOverride.apply(new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f), class_5253.class_5254.method_27762((int)color)).intValue());
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            float offsetU = textureOffset;
            float offsetV = textureOffset;
            float textureU = this.textureCoordinates[i].u * uvOperator.x() + uvOperator.z();
            float textureV = this.textureCoordinates[i].v * uvOperator.y() + uvOperator.w();
            if (textureU > averageU) {
                offsetU = -offsetU;
            }
            if (textureV > averageV) {
                offsetV = -offsetV;
            }
            wr.method_22913(textureU + offsetU, textureV + offsetV);
        } else {
            wr.method_22913(0.0f, 0.0f);
        }
        wr.method_22922(class_4608.field_21444);
        wr.method_60803(light);
        if (this.vertexNormals != null) {
            Vertex normal = this.vertexNormals[i];
            vector3f = new Vector3f(normal.x, normal.y, normal.z);
        } else {
            vector3f = new Vector3f(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
        }
        vector3f.mul((Matrix3fc)new Matrix3f((Matrix4fc)transform));
        vector3f.normalize();
        wr.method_22914(vector3f.x(), vector3f.y(), vector3f.z());
    }

    public Vertex calculateFaceNormal() {
        class_243 v1 = new class_243((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
        class_243 v2 = new class_243((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
        class_243 normalVector = v1.method_1036(v2).method_1029();
        return new Vertex((float)normalVector.field_1352, (float)normalVector.field_1351, (float)normalVector.field_1350);
    }

    static {
        uvOperator = uvDefaultOperator = new Vector4f(1.0f, 1.0f, 0.0f, 0.0f);
    }
}

