package cn.sh1rocu.slashblade.mixin.common;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

@Mixin(class_1297.class)
public abstract class EntityMixin implements EntityExtension {
    @Shadow
    @Nullable
    protected abstract String getEncodeId();

    @Shadow
    public abstract class_2487 saveWithoutId(class_2487 compoundTag);

    @Shadow
    public abstract void load(class_2487 nbt);

    @Unique
    private Collection<class_1542> sb$captureDrops = null;

    @WrapWithCondition(
            method = "spawnAtLocation(Lnet/minecraft/world/item/ItemStack;F)Lnet/minecraft/world/entity/item/ItemEntity;",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"
            )
    )
    public boolean sb$captureDrops(class_1937 level, class_1297 entity) {
        if (sb$captureDrops != null && entity instanceof class_1542 item) {
            sb$captureDrops.add(item);
            return false;
        }
        return true;
    }

    @Unique
    @Override
    public Collection<class_1542> sb$captureDrops() {
        return sb$captureDrops;
    }

    @Unique
    @Override
    public Collection<class_1542> sb$captureDrops(Collection<class_1542> value) {
        Collection<class_1542> ret = sb$captureDrops;
        sb$captureDrops = value;
        return ret;
    }

    @Unique
    @Override
    public class_2487 sb$serializeNBT() {
        class_2487 ret = new class_2487();
        String id = getEncodeId();
        if (id != null) {
            ret.method_10582("id", id);
        }
        return saveWithoutId(ret);
    }

    @Unique
    @Override
    public void sb$deserializeNBT(class_2487 nbt) {
        load(nbt);
    }

    @Unique
    private class_2487 sb$persistentData;

    @Unique
    @Override
    public class_2487 sb$getPersistentData() {
        if (this.sb$persistentData == null) {
            this.sb$persistentData = new class_2487();
        }
        return sb$persistentData;
    }

    @Inject(method = "saveWithoutId", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"))
    private void sb$savePersistentData(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        if (this.sb$persistentData != null) {
            nbt.method_10566("NeoForgeData", this.sb$persistentData.method_10553());
        }
    }

    @Inject(method = "save", at = @At("HEAD"))
    private void save(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        if (sb$persistentData != null) {
            nbt.method_10566("NeoForgeData", sb$persistentData);
        }
    }

    @Inject(method = "load", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"))
    private void sb$loadPersistentData(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("NeoForgeData", 10)) {
            sb$persistentData = nbt.method_10562("NeoForgeData");
        }
    }
}