package mods.flammpfeil.slashblade.client.renderer.entity;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntityJudgementCut;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import javax.annotation.Nullable;
import java.awt.*;

@Environment(EnvType.CLIENT)
public class JudgementCutRenderer<T extends EntityJudgementCut> extends class_897<T> {

    static private final class_2960 modelLocation = class_2960.method_60655(SlashBlade.MODID,
            "model/util/slashdim.obj");
    static private final class_2960 textureLocation = class_2960.method_60655(SlashBlade.MODID,
            "model/util/slashdim.png");

    @Nullable
    @Override
    public class_2960 getTextureLocation(T entity) {
        return textureLocation;
    }

    public JudgementCutRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, class_4587 matrixStackIn,
                       class_4597 bufferIn, int packedLightIn) {

        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn)) {

            matrixStackIn
                    .method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439(partialTicks, entity.field_5982, entity.method_36454()) - 90.0F));
            matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439(partialTicks, entity.field_6004, entity.method_36455())));

            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);

            int lifetime = entity.getLifetime();

            double deathTime = lifetime;
            // double baseAlpha = Math.sin(Math.PI * 0.5 * (Math.min(deathTime, Math.max(0,
            // (lifetime - (entity.ticksExisted) - partialTicks))) / deathTime));
            double baseAlpha = (Math.min(deathTime, Math.max(0, (lifetime - (entity.field_6012) - partialTicks)))
                    / deathTime);
            baseAlpha = -Math.pow(baseAlpha - 1, 4.0) + 1.0;

            int seed = entity.getSeed();

            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(seed));

            float scale = 0.01f;
            matrixStackIn.method_22905(scale, scale, scale);

            int color = entity.getColor() & 0xFFFFFF;
            Color col = new Color(color);
            float[] hsb = Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), null);
            int baseColor = Color.HSBtoRGB(0.5f + hsb[0], hsb[1], 0.2f/* hsb[2] */) & 0xFFFFFF;

            try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn)) {
                for (int l = 0; l < 5; l++) {
                    matrixStackIn.method_22905(0.95f, 0.95f, 0.95f);

                    BladeRenderState.setCol(baseColor | ((0xFF & (int) (0x66 * baseAlpha)) << 24));
                    BladeRenderState.renderOverridedReverseLuminous(class_1799.field_8037, model, "base",
                            this.getTextureLocation(entity), matrixStackIn, bufferIn, packedLightIn);
                }
            }

            int loop = 3;
            for (int l = 0; l < loop; l++) {
                try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn)) {
                    float cycleTicks = 15;
                    float wave = (entity.field_6012 + (cycleTicks / (float) loop * l) + partialTicks) % cycleTicks;
                    float waveScale = 1.0f + 0.03f * wave;
                    matrixStackIn.method_22905(waveScale, waveScale, waveScale);

                    BladeRenderState
                            .setCol(baseColor | ((int) (0x88 * ((cycleTicks - wave) / cycleTicks) * baseAlpha) << 24));
                    BladeRenderState.renderOverridedReverseLuminous(class_1799.field_8037, model, "base",
                            this.getTextureLocation(entity), matrixStackIn, bufferIn, packedLightIn);
                }
            }

            int windCount = 5;
            for (int l = 0; l < windCount; l++) {
                try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn)) {

                    matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees((360.0f / windCount) * l));
                    matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(30.0f));

                    double rotWind = 360.0 / 20.0;

                    double offsetBase = 7;

                    double offset = l * offsetBase;

                    double motionLen = offsetBase * (windCount - 1);

                    double ticks = entity.field_6012 + partialTicks + seed;
                    double offsetTicks = ticks + offset;
                    double progress = (offsetTicks % motionLen) / motionLen;

                    double rad = (Math.PI) * 2.0;
                    rad *= progress;

                    float windScale = (float) (0.4 + progress);
                    matrixStackIn.method_22905(windScale, windScale, windScale);

                    matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees((float) (rotWind * offsetTicks)));

                    Color cc = new Color(col.getRed(), col.getGreen(), col.getBlue(),
                            0xff & (int) (Math.min(0, 0xFF * Math.sin(rad) * baseAlpha)));
                    BladeRenderState.setCol(cc);
                    BladeRenderState.renderOverridedColorWrite(class_1799.field_8037, model, "wind",
                            this.getTextureLocation(entity), matrixStackIn, bufferIn, BladeRenderState.MAX_LIGHT);
                }
            }
        }
    }
}