package mods.flammpfeil.slashblade.data.builtin;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.PropertiesDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.RenderDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.class_1893;
import net.minecraft.class_5321;
import net.minecraft.class_7891;
import org.apache.commons.compress.utils.Lists;

import java.util.List;

public class SlashBladeBuiltInRegistry {
    public static final class_5321<SlashBladeDefinition> YAMATO = register("yamato");
    public static final class_5321<SlashBladeDefinition> YAMATO_BROKEN = register("yamato_broken");

    public static final class_5321<SlashBladeDefinition> TUKUMO = register("yuzukitukumo");
    public static final class_5321<SlashBladeDefinition> MURAMASA = register("muramasa");
    public static final class_5321<SlashBladeDefinition> RUBY = register("ruby");
    public static final class_5321<SlashBladeDefinition> SANGE = register("sange");
    public static final class_5321<SlashBladeDefinition> FOX_BLACK = register("fox_black");
    public static final class_5321<SlashBladeDefinition> FOX_WHITE = register("fox_white");

    public static final class_5321<SlashBladeDefinition> RODAI_WOODEN = register("rodai_wooden");
    public static final class_5321<SlashBladeDefinition> RODAI_STONE = register("rodai_stone");
    public static final class_5321<SlashBladeDefinition> RODAI_IRON = register("rodai_iron");
    public static final class_5321<SlashBladeDefinition> RODAI_GOLDEN = register("rodai_golden");
    public static final class_5321<SlashBladeDefinition> RODAI_DIAMOND = register("rodai_diamond");
    public static final class_5321<SlashBladeDefinition> RODAI_NETHERITE = register("rodai_netherite");

    public static final class_5321<SlashBladeDefinition> TAGAYASAN = register("tagayasan");
    public static final class_5321<SlashBladeDefinition> AGITO = register("agito");
    public static final class_5321<SlashBladeDefinition> AGITO_RUST = register("agito_rust");
    public static final class_5321<SlashBladeDefinition> OROTIAGITO = register("orotiagito");
    public static final class_5321<SlashBladeDefinition> OROTIAGITO_SEALED = register("orotiagito_sealed");
    public static final class_5321<SlashBladeDefinition> OROTIAGITO_RUST = register("orotiagito_rust");

    public static final class_5321<SlashBladeDefinition> YASHA = register("yasha");
    public static final class_5321<SlashBladeDefinition> YASHA_TRUE = register("yasha_true");

    public static final class_5321<SlashBladeDefinition> SABIGATANA = register("sabigatana");
    public static final class_5321<SlashBladeDefinition> SABIGATANA_BROKEN = register("sabigatana_broken");
    public static final class_5321<SlashBladeDefinition> DOUTANUKI = register("doutanuki");
    public static final class_5321<SlashBladeDefinition> KOSEKI = register("koseki");

    public static void registerAll(class_7891<SlashBladeDefinition> bootstrap) {
        bootstrap.method_46838(KOSEKI,
                new SlashBladeDefinition(SlashBlade.prefix("koseki"),
                        RenderDefinition.Builder
                                .newInstance()
                                .effectColor(0x303030)
                                .textureName(SlashBlade.prefix("model/named/dios/koseki.png"))
                                .modelName(SlashBlade.prefix("model/named/dios/dios.obj"))
                                .standbyRenderType(CarryType.NINJA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance()
                                .baseAttackModifier(5.0F).maxDamage(70)
                                .defaultSwordType(List.of(SwordType.BEWITCHED))
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.DRIVE_VERTICAL))
                                .addSpecialEffect(SpecialEffectsRegistry.SPECIAL_EFFECT.method_10221(SpecialEffectsRegistry.WITHER_EDGE))
                                .build(),
                        List.of(new EnchantmentDefinition(class_1893.field_9103.method_29177(), 2))));

        bootstrap.method_46838(SABIGATANA,
                new SlashBladeDefinition(SlashBlade.prefix("sabigatana"),
                        RenderDefinition.Builder
                                .newInstance().textureName(SlashBlade.prefix("model/named/muramasa/sabigatana.png"))
                                .modelName(SlashBlade.prefix("model/named/muramasa/muramasa.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(3.0F).maxDamage(40).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(SABIGATANA_BROKEN, new SlashBladeDefinition(SlashBlade.prefix("sabigatana"),
                RenderDefinition.Builder
                        .newInstance().textureName(SlashBlade.prefix("model/named/muramasa/sabigatana.png"))
                        .modelName(SlashBlade.prefix("model/named/muramasa/muramasa.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(3.0F).maxDamage(40)
                        .defaultSwordType(List.of(SwordType.BROKEN, SwordType.SEALED)).build(),
                Lists.newArrayList()));

        bootstrap.method_46838(DOUTANUKI,
                new SlashBladeDefinition(SlashBlade.prefix("doutanuki"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBlade.prefix("model/named/muramasa/doutanuki.png"))
                                .modelName(SlashBlade.prefix("model/named/muramasa/muramasa.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(5.0F).maxDamage(60)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.CIRCLE_SLASH))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(TAGAYASAN,
                new SlashBladeDefinition(SlashBlade.prefix("tagayasan"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBlade.prefix("model/named/tagayasan.png"))
                                .standbyRenderType(CarryType.KATANA)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(5.0F).maxDamage(70)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.DRIVE_VERTICAL))
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(class_1893.field_9123.method_29177(), 3),
                                new EnchantmentDefinition(class_1893.field_9119.method_29177(), 3))));

        bootstrap.method_46838(YASHA, new SlashBladeDefinition(SlashBlade.prefix("yasha"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/yasha/yasha.png"))
                        .modelName(SlashBlade.prefix("model/named/yasha/yasha.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(6.0F)
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.SAKURA_END)).maxDamage(70).build(),
                Lists.newArrayList()));

        bootstrap.method_46838(YASHA_TRUE, new SlashBladeDefinition(SlashBlade.prefix("yasha_true"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/yasha/yasha.png"))
                        .modelName(SlashBlade.prefix("model/named/yasha/yasha_true.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(6.0F)
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.CIRCLE_SLASH))
                        .defaultSwordType(List.of(SwordType.BEWITCHED)).maxDamage(70).build(),
                Lists.newArrayList()));

        bootstrap.method_46838(AGITO_RUST, new SlashBladeDefinition(SlashBlade.prefix("agito_rust"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/agito_rust.png"))
                        .modelName(SlashBlade.prefix("model/named/agito.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(3.0F).maxDamage(60)
                        .defaultSwordType(List.of(SwordType.SEALED)).build(),
                Lists.newArrayList()));

        bootstrap.method_46838(AGITO, new SlashBladeDefinition(SlashBlade.prefix("agito"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/agito_false.png"))
                        .modelName(SlashBlade.prefix("model/named/agito.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(5.0F)
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.WAVE_EDGE)).maxDamage(60).build(),
                Lists.newArrayList()));

        bootstrap.method_46838(OROTIAGITO_RUST, new SlashBladeDefinition(SlashBlade.prefix("orotiagito_rust"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/agito_rust_true.png"))
                        .modelName(SlashBlade.prefix("model/named/agito.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(3.0F).maxDamage(60)
                        .defaultSwordType(List.of(SwordType.SEALED)).build(),
                Lists.newArrayList()));

        bootstrap.method_46838(OROTIAGITO_SEALED, new SlashBladeDefinition(SlashBlade.prefix("orotiagito_sealed"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/agito_true.png"))
                        .modelName(SlashBlade.prefix("model/named/agito.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(5.0F)
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.WAVE_EDGE)).maxDamage(60).build(),
                Lists.newArrayList()));

        bootstrap.method_46838(OROTIAGITO, new SlashBladeDefinition(SlashBlade.prefix("orotiagito"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/orotiagito.png"))
                        .modelName(SlashBlade.prefix("model/named/agito.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(7.0F)
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.WAVE_EDGE))
                        .defaultSwordType(List.of(SwordType.BEWITCHED)).maxDamage(60).build(),
                Lists.newArrayList()));

        bootstrap.method_46838(RODAI_WOODEN,
                new SlashBladeDefinition(SlashBlade.prefix("rodai_wooden"),
                        RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/rodai_wooden.png"))
                                .standbyRenderType(CarryType.DEFAULT)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(2.0F).maxDamage(60).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(RODAI_STONE,
                new SlashBladeDefinition(SlashBlade.prefix("rodai_stone"),
                        RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/rodai_stone.png"))
                                .standbyRenderType(CarryType.DEFAULT)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(3.0F).maxDamage(132).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(RODAI_IRON,
                new SlashBladeDefinition(SlashBlade.prefix("rodai_iron"),
                        RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/rodai_iron.png"))
                                .standbyRenderType(CarryType.DEFAULT)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(4.0F).maxDamage(250).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(RODAI_GOLDEN,
                new SlashBladeDefinition(SlashBlade.prefix("rodai_golden"),
                        RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/rodai_golden.png"))
                                .standbyRenderType(CarryType.DEFAULT)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(2.0F).maxDamage(33).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(RODAI_DIAMOND,
                new SlashBladeDefinition(SlashBlade.prefix("rodai_diamond"),
                        RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/rodai_diamond.png"))
                                .standbyRenderType(CarryType.DEFAULT)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(7.0F).maxDamage(1561).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(RODAI_NETHERITE,
                new SlashBladeDefinition(SlashBlade.prefix("rodai_netherite"),
                        RenderDefinition.Builder.newInstance()
                                .textureName(SlashBlade.prefix("model/rodai_netherite.png"))
                                .standbyRenderType(CarryType.DEFAULT).build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(8.0F).maxDamage(2031).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(RUBY,
                new SlashBladeDefinition(SlashBlade.prefix("ruby"),
                        RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/ruby.png"))
                                .standbyRenderType(CarryType.DEFAULT).build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(5.0F).maxDamage(45).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(FOX_BLACK, new SlashBladeDefinition(SlashBlade.prefix("fox_black"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/sange/black.png"))
                        .modelName(SlashBlade.prefix("model/named/sange/sange.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(5.0F).maxDamage(70)
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.PIERCING))
                        .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                List.of(new EnchantmentDefinition(class_1893.field_9123.method_29177(), 4),
                        new EnchantmentDefinition(class_1893.field_9121.method_29177(), 2),
                        new EnchantmentDefinition(class_1893.field_9124.method_29177(), 2))));

        bootstrap.method_46838(FOX_WHITE, new SlashBladeDefinition(SlashBlade.prefix("fox_white"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/sange/white.png"))
                        .modelName(SlashBlade.prefix("model/named/sange/sange.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(5.0F).maxDamage(70)
                        .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                List.of(new EnchantmentDefinition(class_1893.field_9121.method_29177(), 2),
                        new EnchantmentDefinition(class_1893.field_9112.method_29177(), 2),
                        new EnchantmentDefinition(class_1893.field_9119.method_29177(), 3),
                        new EnchantmentDefinition(class_1893.field_9124.method_29177(), 2),
                        new EnchantmentDefinition(class_1893.field_9110.method_29177(), 3))));

        bootstrap.method_46838(YAMATO,
                new SlashBladeDefinition(SlashBlade.prefix("yamato"),
                        RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/yamato.png"))
                                .modelName(SlashBlade.prefix("model/named/yamato.obj"))
                                .standbyRenderType(CarryType.DEFAULT)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(7.0F)
                                .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                        List.of(new EnchantmentDefinition(class_1893.field_23071.method_29177(), 2),
                                new EnchantmentDefinition(class_1893.field_9103.method_29177(), 5),
                                new EnchantmentDefinition(class_1893.field_9129.method_29177(), 4))));

        bootstrap.method_46838(YAMATO_BROKEN,
                new SlashBladeDefinition(SlashBlade.prefix("yamato"),
                        RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/yamato.png"))
                                .modelName(SlashBlade.prefix("model/named/yamato.obj"))
                                .standbyRenderType(CarryType.DEFAULT)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(7.0F)
                                .defaultSwordType(List.of(SwordType.BROKEN, SwordType.SEALED)).build(),
                        List.of()));

        bootstrap.method_46838(TUKUMO, new SlashBladeDefinition(SlashBlade.prefix("yuzukitukumo"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/a_tukumo.png"))
                        .modelName(SlashBlade.prefix("model/named/agito.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(6.0F)
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.DRIVE_HORIZONTAL))
                        .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                List.of(new EnchantmentDefinition(class_1893.field_9124.method_29177(), 1),
                        new EnchantmentDefinition(class_1893.field_9118.method_29177(), 4),
                        new EnchantmentDefinition(class_1893.field_9119.method_29177(), 3))));

        bootstrap.method_46838(MURAMASA,
                new SlashBladeDefinition(SlashBlade.prefix("muramasa"),
                        RenderDefinition.Builder
                                .newInstance().textureName(SlashBlade.prefix("model/named/muramasa/muramasa.png"))
                                .modelName(SlashBlade.prefix("model/named/muramasa/muramasa.obj"))
                                .standbyRenderType(CarryType.PSO2)
                                .build(),
                        PropertiesDefinition.Builder.newInstance().baseAttackModifier(7.0F).maxDamage(50)
                                .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.DRIVE_VERTICAL)).build(),
                        Lists.newArrayList()));

        bootstrap.method_46838(SANGE, new SlashBladeDefinition(SlashBlade.prefix("sange"),
                RenderDefinition.Builder.newInstance().textureName(SlashBlade.prefix("model/named/sange/sange.png"))
                        .modelName(SlashBlade.prefix("model/named/sange/sange.obj"))
                        .standbyRenderType(CarryType.PSO2)
                        .build(),
                PropertiesDefinition.Builder.newInstance().baseAttackModifier(6.0F).maxDamage(70)
                        .slashArtsType(SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.VOID_SLASH))
                        .defaultSwordType(List.of(SwordType.BEWITCHED)).build(),
                Lists.newArrayList()));

    }

    private static class_5321<SlashBladeDefinition> register(String id) {
        class_5321<SlashBladeDefinition> loc = class_5321.method_29179(SlashBladeDefinition.REGISTRY_KEY,
                SlashBlade.prefix(id));
        return loc;
    }
}
