package mods.flammpfeil.slashblade.entity.ai;

import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.capability.mobeffect.IMobEffectState;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import java.util.EnumSet;

public class StunGoal extends class_1352 {
    private final class_1314 entity;

    public StunGoal(class_1314 creature) {
        this.entity = creature;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18407, class_4134.field_18406, class_4134.field_18408));
    }

    /**
     * Returns whether the EntityAIBase should begin execution.
     */
    public boolean method_6264() {
        boolean onStun = CapabilityMobEffect.MOB_EFFECT.maybeGet(this.entity)
                .filter((state) -> state.isStun(this.entity.method_37908().method_8510())).isPresent();

        return onStun;
    }

    /**
     * Reset the task's internal state. Called when this task is interrupted by
     * another one
     */
    public void method_6270() {
        CapabilityMobEffect.MOB_EFFECT.maybeGet(this.entity).ifPresent(IMobEffectState::clearStunTimeOut);
    }
}
