package mods.flammpfeil.slashblade.event.bladestand;

import cn.sh1rocu.slashblade.api.event.ICancellableEvent;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import javax.annotation.Nullable;

public class BladeChangeSpecialEffectEvent extends SlashBladeEvent implements ICancellableEvent {
    private class_2960 SEKey;
    private int shrinkCount = 0;
    private final BladeStandAttackEvent originalEvent;
    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.onChangeSpecialEffect(event);
        }
    });

    public BladeChangeSpecialEffectEvent(class_1799 blade, ISlashBladeState state, class_2960 SEKey,
                                         BladeStandAttackEvent originalEvent) {
        super(blade, state);
        this.SEKey = SEKey;
        this.originalEvent = originalEvent;
    }

    public class_2960 getSEKey() {
        return SEKey;
    }

    public class_2960 setSEKey(class_2960 SEKey) {
        this.SEKey = SEKey;
        return SEKey;
    }

    public int getShrinkCount() {
        return shrinkCount;
    }

    public int setShrinkCount(int shrinkCount) {
        this.shrinkCount = shrinkCount;
        return this.shrinkCount;
    }

    public @Nullable BladeStandAttackEvent getOriginalEvent() {
        return originalEvent;
    }

    public interface Callback {
        void onChangeSpecialEffect(BladeChangeSpecialEffectEvent event);
    }
}
