package mods.flammpfeil.slashblade.event.client;

import cn.sh1rocu.slashblade.api.event.LivingEntityRenderEvents;
import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_922;

public class UserPoseOverrider {

    public static boolean UsePoseOverrider = false;

    private static final class SingletonHolder {
        private static final UserPoseOverrider instance = new UserPoseOverrider();
    }

    public static UserPoseOverrider getInstance() {
        return SingletonHolder.instance;
    }

    private UserPoseOverrider() {
    }

    public void register() {
        LivingEntityRenderEvents.PRE.register((class_1309 entity, class_922<?, ?> renderer, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light) -> {
            this.onRenderPlayerEventPre(entity, renderer, partialRenderTick, matrixStack, buffers, light);
            return false;
        });
        UsePoseOverrider = true;
    }

    private static final String TAG_ROT = "sb_yrot";
    private static final String TAG_ROT_PREV = "sb_yrot_prev";

    public void onRenderPlayerEventPre(class_1309 entity, class_922<?, ?> renderer, float partialTicks, class_4587 matrixStackIn, class_4597 buffers, int light) {
        class_1799 stack = entity.method_6047();

        if (stack.method_7960())
            return;
        if (!(stack.method_7909() instanceof ItemSlashBlade))
            return;

        float rot = ((EntityExtension) entity).sb$getPersistentData().method_10583(TAG_ROT);
        float rotPrev = ((EntityExtension) entity).sb$getPersistentData().method_10583(TAG_ROT_PREV);

        float f = class_3532.method_17821(partialTicks, entity.field_6220, entity.field_6283);
        matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(180.0F - f));
        anotherPoseRotP(matrixStackIn, entity, partialTicks);

        matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_17821(partialTicks, rot, rotPrev)));

        anotherPoseRotN(matrixStackIn, entity, partialTicks);
        matrixStackIn.method_22907(class_7833.field_40715.rotationDegrees(180.0F - f));
    }

    public static void anotherPoseRotP(class_4587 matrixStackIn, class_1309 entityLiving, float partialTicks) {
        final boolean isPositive = true;
        final float np = isPositive ? 1 : -1;

        float f = entityLiving.method_6024(partialTicks);
        if (entityLiving.method_6128()) {
            float f1 = (float) entityLiving.method_6003() + partialTicks;
            float f2 = class_3532.method_15363(f1 * f1 / 100.0F, 0.0F, 1.0F);
            if (!entityLiving.method_6123()) {
                matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(np * f2 * (-90.0F - entityLiving.method_36455())));
            }

            class_243 vector3d = entityLiving.method_5828(partialTicks);
            class_243 vector3d1 = entityLiving.method_18798();
            double d0 = vector3d1.method_37268();
            double d1 = vector3d.method_37268();
            if (d0 > 0.0D && d1 > 0.0D) {
                double d2 = (vector3d1.field_1352 * vector3d.field_1352 + vector3d1.field_1350 * vector3d.field_1350) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.field_1352 * vector3d.field_1350 - vector3d1.field_1350 * vector3d.field_1352;
                matrixStackIn.method_22907(class_7833.field_40716.rotation((float) (np * Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0F) {
            float f3 = entityLiving.method_5799() ? -90.0F - entityLiving.method_36455() : -90.0F;
            float f4 = class_3532.method_16439(f, 0.0F, f3);
            matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(np * f4));
            if (entityLiving.method_20232()) {
                matrixStackIn.method_22904(0.0D, np * -1.0D, (double) np * 0.3F);
            }
        }
    }

    public static void anotherPoseRotN(class_4587 matrixStackIn, class_1309 entityLiving, float partialTicks) {
        final boolean isPositive = false;
        final float np = isPositive ? 1 : -1;

        float f = entityLiving.method_6024(partialTicks);
        if (entityLiving.method_6128()) {
            class_243 vector3d = entityLiving.method_5828(partialTicks);
            class_243 vector3d1 = entityLiving.method_18798();
            double d0 = vector3d1.method_37268();
            double d1 = vector3d.method_37268();
            if (d0 > 0.0D && d1 > 0.0D) {
                double d2 = (vector3d1.field_1352 * vector3d.field_1352 + vector3d1.field_1350 * vector3d.field_1350) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.field_1352 * vector3d.field_1350 - vector3d1.field_1350 * vector3d.field_1352;
                matrixStackIn.method_22907(class_7833.field_40716.rotation((float) (np * Math.signum(d3) * Math.acos(d2))));
            }

            float f1 = (float) entityLiving.method_6003() + partialTicks;
            float f2 = class_3532.method_15363(f1 * f1 / 100.0F, 0.0F, 1.0F);
            if (!entityLiving.method_6123()) {
                matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(np * f2 * (-90.0F - entityLiving.method_36455())));
            }
        } else if (f > 0.0F) {
            if (entityLiving.method_20232()) {
                matrixStackIn.method_22904(0.0D, np * -1.0D, (double) np * 0.3F);
            }

            float f3 = entityLiving.method_5799() ? -90.0F - entityLiving.method_36455() : -90.0F;
            float f4 = class_3532.method_16439(f, 0.0F, f3);
            matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(np * f4));
        }
    }

    public static void setRot(class_1297 target, float rotYaw, boolean isOffset) {
        class_2487 tag = ((EntityExtension) target).sb$getPersistentData();

        float prevRot = tag.method_10583(TAG_ROT);
        tag.method_10548(TAG_ROT_PREV, prevRot);

        if (isOffset)
            rotYaw += prevRot;

        tag.method_10548(TAG_ROT, rotYaw);
    }

    public static void resetRot(class_1297 target) {
        class_2487 tag = ((EntityExtension) target).sb$getPersistentData();
        tag.method_10548(TAG_ROT_PREV, 0);
        tag.method_10548(TAG_ROT, 0);
    }

    public static void invertRot(class_4587 matrixStack, class_1297 entity, float partialTicks) {
        float rot = ((EntityExtension) entity).sb$getPersistentData().method_10583(TAG_ROT);
        float rotPrev = ((EntityExtension) entity).sb$getPersistentData().method_10583(TAG_ROT_PREV);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_17821(partialTicks, rot, rotPrev)));
    }
}
