package mods.flammpfeil.slashblade.event.handler;

import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingExperienceDropEvent;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.item.SwordType;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class KillCounter {
    private static final class SingletonHolder {
        private static final KillCounter instance = new KillCounter();
    }

    public static KillCounter getInstance() {
        return SingletonHolder.instance;
    }

    private KillCounter() {
    }

    public void register() {
        ServerLivingEntityEvents.AFTER_DEATH.register(this::onLivingDeathEvent);
        LivingExperienceDropEvent.EVENT.register(this::onXPDropping);
    }

    public void onLivingDeathEvent(class_1309 attacker, class_1282 source) {
        class_1297 trueSource = source.method_5529();

        if (!(trueSource instanceof class_1309))
            return;

        class_1799 stack = ((class_1309) trueSource).method_6047();
        if (stack.method_7960())
            return;
        if (CapabilitySlashBlade.getBladeState(stack).isEmpty())
            return;

        CapabilitySlashBlade.getBladeState(stack).ifPresent(state -> {
            var killCountEvent = new SlashBladeEvent.AddKillCountEvent(stack, state, 1);
            SlashBladeEvent.ADD_KILL_COUNT.invoker().onAddAddKillCount(killCountEvent);
            state.setKillCount(state.getKillCount() + killCountEvent.getNewCount());
        });
    }

    public void onXPDropping(LivingExperienceDropEvent event) {
        class_1657 player = event.getAttackingPlayer();
        if (player == null)
            return;
        class_1799 stack = player.method_6047();
        if (stack.method_7960())
            return;
        if (CapabilitySlashBlade.getBladeState(stack).isEmpty())
            return;

        IConcentrationRank.ConcentrationRanks rankBonus = CapabilityConcentrationRank.RANK_POINT.maybeGet(player)
                .map(rp -> rp.getRank(player.method_5770().method_8510()))
                .orElse(IConcentrationRank.ConcentrationRanks.NONE);
        int souls = (int) Math.floor(event.getDroppedExperience() * (1.0F + (rankBonus.level * 0.1F)));

        CapabilitySlashBlade.getBladeState(stack).ifPresent(state -> {
            var soulEvent = new SlashBladeEvent.AddProudSoulEvent(stack, state, Math.min(SlashBladeConfig.MAX_PROUD_SOUL_GOT.get(), souls));
            SlashBladeEvent.ADD_PROUD_SOUL.invoker().onAddProudSoul(soulEvent);
            int newCount = soulEvent.getNewCount();
            state.setProudSoulCount(
                    state.getProudSoulCount() + newCount);
            if (SwordType.from(stack).contains(SwordType.SOULEATER)) {
                int damage = Math.max(1, newCount / 4);
                stack.method_7974(Math.max(stack.method_7919() - damage, 0));
            }
        });
    }
}
