package mods.flammpfeil.slashblade.network;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record RankSyncPacket(long rawPoint) implements class_8710 {
    private static final class_2960 ID = SlashBlade.prefix("s2c_rank_sync");
    public static final class_9154<RankSyncPacket> TYPE = new class_9154<>(ID);

    public static final class_9139<class_9129, RankSyncPacket> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48551,
            RankSyncPacket::rawPoint,
            RankSyncPacket::new
    );

    @Environment(EnvType.CLIENT)
    public static void handle(RankSyncPacket payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> setPoint(payload.rawPoint));
    }

    @Environment(EnvType.CLIENT)
    public static void setPoint(long point) {
        class_1657 pl = class_310.method_1551().field_1724;
        CapabilityConcentrationRank.RANK_POINT.maybeGet(pl).ifPresent(cr -> {

            long time = pl.method_37908().method_8510();

            IConcentrationRank.ConcentrationRanks oldRank = cr.getRank(time);

            cr.setRawRankPoint(point);
            cr.setLastUpdate(time);

            if (oldRank.level < cr.getRank(time).level)
                cr.setLastRankRise(time);
        });
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}