package mods.flammpfeil.slashblade.slasharts;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import java.util.function.Function;

public class SlashArts {
    public static final class_5321<class_2378<SlashArts>> REGISTRY_KEY = class_5321
            .method_29180(SlashBlade.prefix("slash_arts"));

    public static class_2960 getRegistryKey(SlashArts state) {
        return SlashArtsRegistry.SLASH_ARTS.method_10221(state);
    }

    public static final int ChargeTicks = 9;
    public static final int ChargeJustTicks = 3;
    public static final int ChargeJustTicksMax = 5;

    public static int getJustReceptionSpan(class_1309 user) {
        var holder = user.method_56673().method_46762(class_7924.field_41265).method_46747(class_1893.field_23071);
        return Math.min(ChargeJustTicksMax,
                ChargeJustTicks + class_1890.method_8203(holder, user));
    }

    public enum ArtsType {
        Fail, Success, Jackpot, Super
    }

    private Function<class_1309, class_2960> comboState;
    private Function<class_1309, class_2960> comboStateJust;
    private Function<class_1309, class_2960> comboStateSuper;

    public class_2960 doArts(ArtsType type, class_1309 user) {
        switch (type) {
            case Jackpot:
                return getComboStateJust(user);
            case Success:
                return getComboState(user);
            case Super:
                return getComboStateSuper().apply(user);
            default:
                break;
        }
        return ComboStateRegistry.getId(ComboStateRegistry.NONE);
    }

    private int costSoul = 20;

    public SlashArts(Function<class_1309, class_2960> state) {
        this.comboState = state;
        this.comboStateJust = state;
        this.setComboStateSuper((entity) -> ComboStateRegistry.getId(ComboStateRegistry.JUDGEMENT_CUT_END));
    }

    public class_2960 getComboState(class_1309 user) {
        return this.comboState.apply(user);
    }

    public class_2960 getComboStateJust(class_1309 user) {
        return this.comboStateJust.apply(user);
    }

    public SlashArts setComboStateJust(Function<class_1309, class_2960> state) {
        this.comboStateJust = state;
        return this;
    }

    public Function<class_1309, class_2960> getComboStateSuper() {
        return comboStateSuper;
    }

    public SlashArts setComboStateSuper(Function<class_1309, class_2960> comboStateSuper) {
        this.comboStateSuper = comboStateSuper;
        return this;
    }

    public int getProudSoulCost() {
        return costSoul;
    }

    public SlashArts setProudSoulCost(int costSoul) {
        this.costSoul = costSoul;
        return this;
    }

    public class_2561 getDescription() {
        return class_2561.method_43471(this.getDescriptionId());
    }

    public String toString() {
        return SlashArtsRegistry.SLASH_ARTS.method_10221(this).toString();
    }

    private String descriptionId;

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = class_156.method_646("slash_art", SlashArtsRegistry.SLASH_ARTS.method_10221(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }


}
