package mods.flammpfeil.slashblade.event.drop;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import mods.flammpfeil.slashblade.SlashBlade;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class EntityDropEntry {
    public static final Codec<EntityDropEntry> CODEC = RecordCodecBuilder.create(instance -> instance
            .group(class_2960.field_25139.fieldOf("entity_type").forGetter(EntityDropEntry::getEntityType),
                    class_2960.field_25139.fieldOf("blade").forGetter(EntityDropEntry::getBladeName),
                    Codec.FLOAT.optionalFieldOf("drop_rate", 1.0F).forGetter(EntityDropEntry::getDropRate),
                    Codec.BOOL.optionalFieldOf("request_slashblade", false)
                            .forGetter(EntityDropEntry::isRequestSlashBladeKill),
                    Codec.BOOL.optionalFieldOf("drop_fixed", false).forGetter(EntityDropEntry::isDropFixedPoint),
                    class_243.field_38277.optionalFieldOf("drop_point", new class_243(0, 0, 0)).forGetter(EntityDropEntry::getDropPoint)

            ).apply(instance, EntityDropEntry::new));

    public static final class_5321<class_2378<EntityDropEntry>> REGISTRY_KEY = class_5321
            .method_29180(SlashBlade.prefix("entity_drop"));

    private final class_2960 entityType;
    private final class_2960 bladeName;
    private final float dropRate;
    private final boolean requestSlashBladeKill;
    private final boolean dropFixedPoint;
    private final class_243 dropPoint;

    public EntityDropEntry(class_2960 entityType, class_2960 bladeName, float dropRate) {
        this(entityType, bladeName, dropRate, true, false, new class_243(0, 0, 0));
    }

    public EntityDropEntry(class_2960 entityType, class_2960 bladeName, float dropRate, boolean request) {
        this(entityType, bladeName, dropRate, request, false, new class_243(0, 0, 0));
    }

    public EntityDropEntry(class_2960 entityType, class_2960 bladeName, float dropRate, boolean request,
            boolean pointFixed, class_243 point) {
        this.entityType = entityType;
        this.bladeName = bladeName;
        this.dropRate = dropRate;
        this.requestSlashBladeKill = request;
        this.dropFixedPoint = pointFixed;
        this.dropPoint = point;
    }

    public class_2960 getBladeName() {
        return bladeName;
    }

    public class_2960 getEntityType() {
        return entityType;
    }

    public float getDropRate() {
        return dropRate;
    }

    public boolean isRequestSlashBladeKill() {
        return requestSlashBladeKill;
    }

    public boolean isDropFixedPoint() {
        return dropFixedPoint;
    }

    public class_243 getDropPoint() {
        return dropPoint;
    }
}
