package mods.flammpfeil.slashblade.recipe;

import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiFunction;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public record SlashBladeShapedRecipeSerializer<T extends class_1860<?>, U extends T>(
        class_1865<T> compose,
        BiFunction<T, @Nullable class_2960, U> converter) implements class_1865<U> {
    @Override
    @NotNull
    public U method_8121(@NotNull class_2960 id, @NotNull JsonObject json) {
        if (!json.has("result")) {
            JsonObject object = new JsonObject();
            object.addProperty("item", "slashblade:slashblade");
            json.add("result", object);
        }
        T recipe = compose().method_8121(id, json);
        if (json.has("blade")) {
            class_2960 output = new class_2960(class_3518.method_15265(json, "blade"));
            return converter().apply(recipe, output);
        }
        return converter().apply(recipe,
                new class_2960(class_3518.method_15265(json.getAsJsonObject("result"), "item")));
    }

    @Override
    @NotNull
    public U method_8122(@NotNull class_2960 id, @NotNull class_2540 buf) {
        T recipe = compose().method_8122(id, buf);
        if (buf.readBoolean())
            return converter().apply(recipe, buf.method_10810());
        return converter().apply(recipe, null);
    }

    @Override
    public void method_8124(@NotNull class_2540 buf, @NotNull U recipe) {
        compose().method_8124(buf, recipe);
        if (recipe instanceof SlashBladeShapedRecipe bladeRecipe) {
            boolean hasName = bladeRecipe.getOutputBlade() != null;
            buf.writeBoolean(hasName);
            if (hasName)
                buf.method_10812(bladeRecipe.getOutputBlade());
        } else
            buf.writeBoolean(false);
    }
}