package mods.flammpfeil.slashblade.entity;

import cn.sh1rocu.slashblade.util.PotionUtils;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import javax.annotation.Nullable;
import java.util.List;

import static mods.flammpfeil.slashblade.SlashBladeConfig.REFINE_DAMAGE_MULTIPLIER;
import static mods.flammpfeil.slashblade.SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER;

public class EntityDrive extends EntityAbstractSummonedSword {
    private static final class_2940<Integer> COLOR = class_2945.<Integer>method_12791(EntityDrive.class,
            class_2943.field_13327);
    private static final class_2940<Integer> FLAGS = class_2945.<Integer>method_12791(EntityDrive.class,
            class_2943.field_13327);
    private static final class_2940<Float> RANK = class_2945.<Float>method_12791(EntityDrive.class,
            class_2943.field_13320);
    private static final class_2940<Float> ROTATION_OFFSET = class_2945
            .<Float>method_12791(EntityDrive.class, class_2943.field_13320);
    private static final class_2940<Float> ROTATION_ROLL = class_2945.<Float>method_12791(EntityDrive.class,
            class_2943.field_13320);
    private static final class_2940<Float> BASESIZE = class_2945.<Float>method_12791(EntityDrive.class,
            class_2943.field_13320);
    private static final class_2940<Float> SPEED = class_2945.<Float>method_12791(EntityDrive.class,
            class_2943.field_13320);
    private static final class_2940<Float> LIFETIME = class_2945.<Float>method_12791(EntityDrive.class, class_2943.field_13320);

    private KnockBacks action = KnockBacks.cancel;

    private double damage = 7.0D;

    public KnockBacks getKnockBack() {
        return action;
    }

    public void setKnockBack(KnockBacks action) {
        this.action = action;
    }

    public void setKnockBackOrdinal(int ordinal) {
        if (0 <= ordinal && ordinal < KnockBacks.values().length)
            this.action = KnockBacks.values()[ordinal];
        else
            this.action = KnockBacks.cancel;
    }

    public EntityDrive(class_1299<? extends Projectile> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.method_5875(true);
        // this.setGlowing(true);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, 0x3333FF);
        builder.method_56912(FLAGS, 0);
        builder.method_56912(RANK, 0.0f);
        builder.method_56912(LIFETIME, 10.0f);

        builder.method_56912(ROTATION_OFFSET, 0.0f);
        builder.method_56912(ROTATION_ROLL, 0.0f);
        builder.method_56912(BASESIZE, 1.0f);
        builder.method_56912(SPEED, 0.5f);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);

        NBTHelper.getNBTCoupler(compound).put("RotationOffset", this.getRotationOffset())
                .put("RotationRoll", this.getRotationRoll()).put("BaseSize", this.getBaseSize())
                .put("Speed", this.getSpeed()).put("Color", this.getColor()).put("Rank", this.getRank())
                .put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip())
                .put("Lifetime", this.getLifetime()).put("Knockback", this.getKnockBack().ordinal());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);

        NBTHelper.getNBTCoupler(compound).get("RotationOffset", this::setRotationOffset)
                .get("RotationRoll", this::setRotationRoll).get("BaseSize", this::setBaseSize)
                .get("Speed", this::setSpeed).get("Color", this::setColor).get("Rank", this::setRank)
                .get("damage", ((Double v) -> this.damage = v), this.damage).get("crit", this::setIsCritical)
                .get("clip", this::setNoClip).get("Lifetime", this::setLifetime)
                .get("Knockback", this::setKnockBackOrdinal);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 10.0D;
        if (Double.isNaN(d0)) {
            d0 = 1.0D;
        }

        d0 = d0 * 64.0D * method_5824();
        return distance < d0 * d0;
    }

    protected void removeFlags(FlagsState value) {
        this.flags.remove(value);
        refreshFlags();
    }

    private void refreshFlags() {
        if (this.method_37908().method_8608()) {
            int newValue = this.field_6011.method_12789(FLAGS).intValue();
            if (intFlags != newValue) {
                intFlags = newValue;
                flags = EnumSetConverter.convertToEnumSet(FlagsState.class, intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_6011.method_12778(FLAGS, newValue);
                this.intFlags = newValue;
            }
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        tryDespawn();
    }

    protected void tryDespawn() {
        if (!this.method_37908().method_8608()) {
            if (getLifetime() < this.field_6012)
                this.method_5650(class_5529.field_26999);
        }
    }

    public int getColor() {
        return this.method_5841().method_12789(COLOR);
    }

    public void setColor(int value) {
        this.method_5841().method_12778(COLOR, value);
    }

    public float getRank() {
        return this.method_5841().method_12789(RANK);
    }

    public void setRank(float value) {
        this.method_5841().method_12778(RANK, value);
    }

    public IConcentrationRank.ConcentrationRanks getRankCode() {
        return IConcentrationRank.ConcentrationRanks.getRankFromLevel(getRank());
    }

    public float getRotationOffset() {
        return this.method_5841().method_12789(ROTATION_OFFSET);
    }

    public void setRotationOffset(float value) {
        this.method_5841().method_12778(ROTATION_OFFSET, value);
    }

    public float getRotationRoll() {
        return this.method_5841().method_12789(ROTATION_ROLL);
    }

    public void setRotationRoll(float value) {
        this.method_5841().method_12778(ROTATION_ROLL, value);
    }

    public float getBaseSize() {
        return this.method_5841().method_12789(BASESIZE);
    }

    public void setBaseSize(float value) {
        this.method_5841().method_12778(BASESIZE, value);
    }

    public float getSpeed() {
        return this.method_5841().method_12789(SPEED);
    }

    public void setSpeed(float value) {
        this.method_5841().method_12778(SPEED, value);
    }

    public float getLifetime() {
        return this.method_5841().method_12789(LIFETIME);
    }

    public void setLifetime(float value) {
        this.method_5841().method_12778(LIFETIME, value);
    }

    @Nullable
    @Override
    public class_1297 getShooter() {
        return this.method_24921();
    }

    @Override
    public void setShooter(class_1297 shooter) {
        method_7432(shooter);
    }

    public List<class_1293> getPotionEffects() {
        List<class_1293> effects = PotionUtils.getAllEffects(this.sb$getPersistentData());

        if (effects.isEmpty())
            effects.add(new class_1293(class_1294.field_5899, 1, 1));

        return effects;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 targetEntity = entityHitResult.method_17782();
        float damageValue = (float) this.getDamage();

        class_1297 shooter = this.getShooter();
        class_1282 damagesource;
        if (shooter == null) {
            damagesource = this.method_48923().method_48815(this, this);
        } else {
            damagesource = this.method_48923().method_48815(this, shooter);
            if (shooter instanceof class_1309) {
                class_1297 hits = targetEntity;
                if (targetEntity instanceof PartEntity) {
                    hits = ((PartEntity<?>) targetEntity).getParent();
                }
                ((class_1309) shooter).method_6114(hits);
            }
        }

        int fireTime = targetEntity.method_20802();
        if (this.method_5809() && !(targetEntity instanceof class_1560)) {
            targetEntity.method_5639(5);
        }

        // todo: attack manager
        targetEntity.field_6008 = 0;
        if (this.method_24921() instanceof class_1309 living) {
            damageValue *= living.method_45325(class_5134.field_23721);
            //评分等级加成
            if (living instanceof class_1657 player) {
                IConcentrationRank.ConcentrationRanks rankBonus = CapabilityConcentrationRank.RANK_POINT.maybeGet(player)
                        .map(rp -> rp.getRank(player.method_5770().method_8510()))
                        .orElse(IConcentrationRank.ConcentrationRanks.NONE);
                float rankDamageBonus = rankBonus.level / 2.0f;
                if (IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
                    int refine = CapabilitySlashBlade.getBladeState(player.method_6047()).map(ISlashBladeState::getRefine).orElse(0);
                    int level = player.field_7520;
                    rankDamageBonus = (float) Math.max(rankDamageBonus, Math.min(level, refine) * REFINE_DAMAGE_MULTIPLIER.get());
                }
                damageValue += rankDamageBonus;
            }
            damageValue *= AttackManager.getSlashBladeDamageScale(living) * SLASHBLADE_DAMAGE_MULTIPLIER.get();
            if (this.getIsCritical()) {
                damageValue += this.field_5974.method_43048((class_3532.method_15386(damageValue) / 2 + 2));
            }
        }

        if (targetEntity.method_5643(damagesource, damageValue)) {
            class_1297 hits = targetEntity;
            if (targetEntity instanceof PartEntity) {
                hits = ((PartEntity<?>) targetEntity).getParent();
            }

            if (hits instanceof class_1309) {
                class_1309 targetLivingEntity = (class_1309) hits;

                StunManager.setStun(targetLivingEntity);
                if (!this.method_37908().method_8608() && shooter instanceof class_1309) {
                    class_1890.method_60107((class_3218) targetLivingEntity.method_37908(), targetLivingEntity, damagesource);
                }

                affectEntity(targetLivingEntity, getPotionEffects(), 1.0f);

                if (shooter != null && targetLivingEntity != shooter && targetLivingEntity instanceof class_1657
                        && shooter instanceof class_3222) {
                    ((class_3222) shooter).method_17356(this.getHitEntityPlayerSound(), class_3419.field_15248, 0.18F,
                            0.45F);
                }
            }

            this.method_5783(this.getHitEntitySound(), 1.0F, 1.2F / (this.field_5974.method_43057() * 0.2F + 0.9F));
        } else {
            targetEntity.method_20803(fireTime);
        }
    }

    @Override
    protected void method_24920(class_3965 blockraytraceresult) {
        this.method_31745(class_5529.field_26999);
    }

    @Nullable
    public class_3966 getRayTrace(class_243 p_213866_1_, class_243 p_213866_2_) {
        return class_1675.method_18077(this.method_37908(), this, p_213866_1_, p_213866_2_,
                this.method_5829().method_18804(this.method_18798()).method_1014(1.0D), (entity) -> {
                    return !entity.method_7325() && entity.method_5805() && entity.method_5863()
                            && (entity != this.getShooter());
                });
    }
}
