package mods.flammpfeil.slashblade.recipe;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9304;
import net.minecraft.class_9694;
import net.minecraft.world.item.crafting.*;
import java.util.Map;

public class ProudsoulShapelessRecipe extends class_1867 {
    final String group;
    final class_7710 category;
    final class_1799 result;
    final class_2371<class_1856> ingredients;

    public ProudsoulShapelessRecipe(String string, class_7710 craftingBookCategory, class_1799 itemStack, class_2371<class_1856> nonNullList) {
        super(string, craftingBookCategory, itemStack, nonNullList);
        this.group = string;
        this.category = craftingBookCategory;
        this.result = itemStack;
        this.ingredients = nonNullList;
    }

    public static final class_1865<ProudsoulShapelessRecipe> SERIALIZER = new Serializer();

    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    @Override
    public class_1799 method_17729(class_9694 container, class_7225.class_7874 access) {
        class_1799 result = super.method_17729(container, access);

        for (class_1799 stack : container.method_59989()) {
            if (stack.method_7960())
                continue;
            if (!stack.method_7942())
                continue;

            class_9304 emap = class_1890.method_57532(stack);
            class_1890.method_57531(result, mutable -> {
                emap.method_57539().forEach(entry -> {
                    int destLevel = mutable.method_57546(entry.getKey());
                    int srcLevel = entry.getIntValue();

                    srcLevel = Math.max(srcLevel, destLevel);
                    srcLevel = Math.min(srcLevel, entry.getKey().comp_349().method_8183());

                    mutable.method_57550(entry.getKey(), srcLevel);
                });
            });
        }

        return result;
    }

    @Override
    public boolean method_17730(class_9694 container, class_1937 level) {
        boolean result = super.method_17730(container, level);

        if (result) {
            Map<class_6880<class_1887>, Integer> all = Maps.newHashMap();

            int soulCount = 0;

            for (class_1799 stack : container.method_59989()) {
                if (stack.method_7960())
                    continue;
                if (!stack.method_7942())
                    continue;

                soulCount++;

                class_9304 emap = class_1890.method_57532(stack);

                for (Object2IntMap.Entry<class_6880<class_1887>> entry : emap.method_57539()) {
                    if (all.containsKey(entry.getKey())) {

                        int value = all.get(entry.getKey()) + entry.getIntValue();

                        all.put(entry.getKey(), value);
                    } else {
                        all.put(entry.getKey(), entry.getIntValue());
                    }
                }
            }

            result = all.size() == 1 || all.isEmpty();
            if (result) {
                for (Map.Entry<class_6880<class_1887>, Integer> entry : all.entrySet()) {
                    result = entry.getValue() == soulCount;
                }
            }
        }

        return result;
    }

    public static class Serializer implements class_1865<ProudsoulShapelessRecipe> {
        private static final MapCodec<ProudsoulShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
                Codec.STRING.optionalFieldOf("group", "").forGetter((shapelessRecipe) -> shapelessRecipe.group),
                class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter((shapelessRecipe) -> shapelessRecipe.category),
                class_1799.field_51397.fieldOf("result").forGetter((shapelessRecipe) -> shapelessRecipe.result),
                class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap((list) -> {
            class_1856[] ingredients = list.stream().filter((ingredient) -> !ingredient.method_8103()).toArray(class_1856[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            } else {
                return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success(class_2371.method_10212(class_1856.field_9017, ingredients));
            }
        }, DataResult::success).forGetter((shapelessRecipe) -> shapelessRecipe.ingredients)).apply(instance, ProudsoulShapelessRecipe::new));
        public static final class_9139<class_9129, ProudsoulShapelessRecipe> STREAM_CODEC = class_9139.method_56437(ProudsoulShapelessRecipe.Serializer::toNetwork, ProudsoulShapelessRecipe.Serializer::fromNetwork);

        private static ProudsoulShapelessRecipe fromNetwork(class_9129 registryFriendlyByteBuf) {
            String string = registryFriendlyByteBuf.method_19772();
            class_7710 craftingBookCategory = registryFriendlyByteBuf.method_10818(class_7710.class);
            int i = registryFriendlyByteBuf.method_10816();
            class_2371<class_1856> nonNullList = class_2371.method_10213(i, class_1856.field_9017);
            nonNullList.replaceAll((ingredient) -> class_1856.field_48355.decode(registryFriendlyByteBuf));
            class_1799 itemStack = class_1799.field_48349.decode(registryFriendlyByteBuf);
            return new ProudsoulShapelessRecipe(string, craftingBookCategory, itemStack, nonNullList);
        }

        private static void toNetwork(class_9129 registryFriendlyByteBuf, ProudsoulShapelessRecipe recipe) {
            registryFriendlyByteBuf.method_10814(recipe.group);
            registryFriendlyByteBuf.method_10817(recipe.category);
            registryFriendlyByteBuf.method_10804(recipe.ingredients.size());

            for (class_1856 ingredient : recipe.ingredients) {
                class_1856.field_48355.encode(registryFriendlyByteBuf, ingredient);
            }

            class_1799.field_48349.encode(registryFriendlyByteBuf, recipe.result);
        }

        @Override
        public MapCodec<ProudsoulShapelessRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, ProudsoulShapelessRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }

}
