package mods.flammpfeil.slashblade.recipe;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8059;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9697;
import org.jetbrains.annotations.NotNull;

import java.util.stream.Stream;

public record SlashBladeSmithingRecipe(class_2960 outputBlade, class_1856 template, class_1856 base,
                                       class_1856 addition) implements class_8059 {
    public static final MapCodec<SlashBladeSmithingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_2960.field_25139.fieldOf("blade").forGetter(SlashBladeSmithingRecipe::outputBlade),
            class_1856.field_46095.fieldOf("template").forGetter(SlashBladeSmithingRecipe::template),
            class_1856.field_46095.fieldOf("base").forGetter(SlashBladeSmithingRecipe::base),
            class_1856.field_46095.fieldOf("addition").forGetter(SlashBladeSmithingRecipe::addition)
    ).apply(instance, SlashBladeSmithingRecipe::new));

    public static final class_9139<class_9129, SlashBladeSmithingRecipe> field_48356 = class_9139.method_56905(
            class_2960.field_48267,
            SlashBladeSmithingRecipe::outputBlade,
            class_1856.field_48355,
            SlashBladeSmithingRecipe::template,
            class_1856.field_48355,
            SlashBladeSmithingRecipe::base,
            class_1856.field_48355,
            SlashBladeSmithingRecipe::addition,
            SlashBladeSmithingRecipe::new
    );

    public static final class_1865<SlashBladeSmithingRecipe> SERIALIZER = new SlashBladeSmithingRecipe.Serializer();


    private static class_1799 getResultBlade(class_2960 outputBlade) {
        class_1792 bladeItem = class_7923.field_41178.method_10250(outputBlade) ? class_7923.field_41178.method_10223(outputBlade)
                : SBItems.slashblade;

        return bladeItem.method_7854();
    }

    @Override
    public @NotNull class_1799 method_8110(class_7225.@NotNull class_7874 provider) {
        class_1799 result = SlashBladeSmithingRecipe.getResultBlade(outputBlade);

        if (!class_7923.field_41178.method_10221(result.method_7909()).equals(outputBlade)) {
            result = provider.method_46762(SlashBladeDefinition.REGISTRY_KEY).method_46747(class_5321.method_29179(SlashBladeDefinition.REGISTRY_KEY, outputBlade))
                    .comp_349().getBlade();
        }

        return result;
    }

    @Override
    public boolean matches(class_9697 container, @NotNull class_1937 level) {
        return this.template.method_8093(container.method_59984(0)) && this.base.method_8093(container.method_59984(1)) && this.addition.method_8093(container.method_59984(2));
    }

    @Override
    public @NotNull class_1799 assemble(@NotNull class_9697 container, class_7225.@NotNull class_7874 provider) {
        var result = this.method_8110(provider);
        if (!(result.method_7909() instanceof ItemSlashBlade)) {
            result = new class_1799(SBItems.slashblade);
        }

        var resultState = CapabilitySlashBlade.getBladeState(result).orElseThrow(NullPointerException::new);
        var stack = container.method_59984(1);
        if (CapabilitySlashBlade.getBladeState(stack).isEmpty())
            return class_1799.field_8037;
        var ingredientState = CapabilitySlashBlade.getBladeState(stack).orElseThrow(NullPointerException::new);

        resultState.setProudSoulCount(resultState.getProudSoulCount() + ingredientState.getProudSoulCount());
        resultState.setKillCount(resultState.getKillCount() + ingredientState.getKillCount());
        resultState.setRefine(resultState.getRefine() + ingredientState.getRefine());
        updateEnchantment(result, stack);

        return result;
    }

    @Override
    public @NotNull class_1865<?> method_8119() {
        return SlashBladeSmithingRecipe.SERIALIZER;
    }

    @Override
    public boolean method_31584() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(SlashBladeSmithingRecipe::hasNoElements);
    }

    @Override
    public boolean method_48453(@NotNull class_1799 stack) {
        return this.template.method_8093(stack);
    }

    @Override
    public boolean method_48454(@NotNull class_1799 stack) {
        return this.base.method_8093(stack);
    }

    @Override
    public boolean method_30029(@NotNull class_1799 stack) {
        return this.addition.method_8093(stack);
    }

    private void updateEnchantment(class_1799 result, class_1799 ingredient) {
        var newItemEnchants = class_1890.method_57532(result);
        var oldItemEnchants = class_1890.method_57532(ingredient);
        for (class_6880<class_1887> enchantIndex : oldItemEnchants.method_57534()) {
            class_1887 enchantment = enchantIndex.comp_349();

            int destLevel = Math.max(newItemEnchants.method_57536(enchantIndex), 0);
            int srcLevel = oldItemEnchants.method_57536(enchantIndex);

            srcLevel = Math.max(srcLevel, destLevel);
            srcLevel = Math.min(srcLevel, enchantment.method_8183());

            boolean canApplyFlag = result.canBeEnchantedWith(enchantIndex, EnchantingContext.ACCEPTABLE);
            if (canApplyFlag) {
                for (class_6880<class_1887> curEnchantIndex : newItemEnchants.method_57534()) {
                    if (curEnchantIndex.comp_349() != enchantment
                            && !class_1887.method_60033(enchantIndex, curEnchantIndex)) {
                        canApplyFlag = false;
                        break;
                    }
                }
                if (canApplyFlag) {
                    int finalSrcLevel = srcLevel;
                    class_1890.method_57531(result, mutable -> mutable.method_57547(enchantIndex, finalSrcLevel));
                }
            }
        }
    }

    public static class Serializer implements class_1865<SlashBladeSmithingRecipe> {
        @Override
        public @NotNull MapCodec<SlashBladeSmithingRecipe> method_53736() {
            return SlashBladeSmithingRecipe.CODEC;
        }

        @Override
        public @NotNull class_9139<class_9129, SlashBladeSmithingRecipe> method_56104() {
            return SlashBladeSmithingRecipe.field_48356;
        }
    }

    private static boolean hasNoElements(class_1856 ingredient) {
        class_1799[] items = ingredient.method_8105();
        if (items.length == 0) return true;
        if (items.length == 1) {
            //If we potentially added a barrier due to the ingredient being an empty tag, try and check if it is the stack we added
            class_1799 item = items[0];
            return item.method_7909() == class_1802.field_8077 && item.method_7964() instanceof class_5250 hoverName && hoverName.getString().startsWith("Empty Tag: ");
        }
        return false;
    }
}