package mods.flammpfeil.slashblade.capability.slashblade;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import dev.onyxstudios.cca.api.v3.component.Component;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.event.BladeMotionEvent;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.awt.*;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface ISlashBladeState extends Component {
    // action state
    String LAST_ACTION_TIME = "lastActionTime";
    String TARGET_ENTITY = "TargetEntity";
    String ON_CLICK = "_onClick";
    String FALL_DECREASE_RATE = "fallDecreaseRate";
    String ATTACK_AMPLIFIER = "AttackAmplifier";
    String CURRENT_COMBO = "currentCombo";
    String DAMAGE = "Damage";
    String MAX_DAMAGE = "maxDamage";
    String PROUD_SOUL = "proudSoul";
    String IS_BROKEN = "isBroken";

    // passive state
    String IS_SEALED = "isSealed";
    String BASE_ATTACK_MODIFIER = "baseAttackModifier";
    String KILL_COUNT = "killCount";
    String REPAIR_COUNTER = "RepairCounter";

    // performance setting
    String SPECIAL_ATTACK_TYPE = "SpecialAttackType";
    String IS_DEFAULT_BEWITCHED = "isDefaultBewitched";
    String TRANSLATION_KEY = "translationKey";

    // render info
    String STANDBY_RENDER_TYPE = "StandbyRenderType";
    String SUMMONED_SWORD_COLOR = "SummonedSwordColor";
    String SUMMONED_SWORD_COLOR_INVERSE = "SummonedSwordColorInverse";
    String ADJUST_XYZ = "adjustXYZ";
    String TEXTURE_NAME = "TextureName";
    String MODEL_NAME = "ModelName";

    String COMBO_ROOT = "ComboRoot";
    String SPECIAL_EFFECTS = "SpecialEffects";

    class_2487 getBladeState();

    long getLastActionTime();

    void setLastActionTime(long lastActionTime);

    default long getElapsedTime(class_1309 user) {
        long ticks = (Math.max(0, user.method_37908().method_8510() - this.getLastActionTime()));

        if (user.method_37908().method_8608())
            ticks = Math.max(0, ticks + 1);

        return ticks;
    }

    boolean onClick();

    void setOnClick(boolean onClick);

    float getFallDecreaseRate();

    void setFallDecreaseRate(float fallDecreaseRate);

    float getAttackAmplifier();

    void setAttackAmplifier(float attackAmplifier);

    @Nonnull
    class_2960 getComboSeq();

    void setComboSeq(class_2960 comboSeq);

    boolean isBroken();

    void setBroken(boolean broken);

    boolean isSealed();

    void setSealed(boolean sealed);

    float getBaseAttackModifier();

    void setBaseAttackModifier(float baseAttackModifier);

    int getProudSoulCount();

    void setProudSoulCount(int psCount);

    int getKillCount();

    void setKillCount(int killCount);

    int getRefine();

    void setRefine(int refine);

    @Nonnull
    default SlashArts getSlashArts() {
        class_2960 key = getSlashArtsKey();
        SlashArts result = null;
        if (key != null)
            result = SlashArtsRegistry.SLASH_ARTS.method_10250(key) ? SlashArtsRegistry.SLASH_ARTS.method_10223(key)
                    : SlashArtsRegistry.JUDGEMENT_CUT;

        if (key == SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.NONE))
            result = null;

        return result != null ? result : SlashArtsRegistry.JUDGEMENT_CUT;
    }

    void setSlashArtsKey(class_2960 slashArts);

    class_2960 getSlashArtsKey();

    boolean isDefaultBewitched();

    void setDefaultBewitched(boolean defaultBewitched);

    @NotNull
    String getTranslationKey();

    void setTranslationKey(String translationKey);

    @NotNull
    CarryType getCarryType();

    void setCarryType(CarryType carryType);

    @NotNull
    Color getEffectColor();

    void setEffectColor(Color effectColor);

    boolean isEffectColorInverse();

    void setEffectColorInverse(boolean effectColorInverse);

    default void setColorCode(int colorCode) {
        setEffectColor(new Color(colorCode));
    }

    default int getColorCode() {
        return getEffectColor().getRGB();
    }

    @NotNull
    class_243 getAdjust();

    void setAdjust(class_243 adjust);

    @NotNull
    Optional<class_2960> getTexture();

    void setTexture(class_2960 texture);

    @NotNull
    Optional<class_2960> getModel();

    void setModel(class_2960 model);

    int getTargetEntityId();

    void setTargetEntityId(int id);

    @Nullable
    default class_1297 getTargetEntity(class_1937 world) {
        int id = getTargetEntityId();
        if (id < 0)
            return null;
        else
            return world.method_8469(id);
    }

    default void setTargetEntityId(class_1297 target) {
        if (target != null)
            this.setTargetEntityId(target.method_5628());
        else
            this.setTargetEntityId(-1);
    }

    default int getFullChargeTicks(class_1309 user) {
        return SlashArts.ChargeTicks;
    }

    default boolean isCharged(class_1309 user) {
        if (!(SwordType.from(user.method_6047()).contains(SwordType.ENCHANTED)))
            return false;
        if (this.isBroken() || this.isSealed())
            return false;
        int elapsed = user.method_6048();
        return getFullChargeTicks(user) < elapsed;
    }

    default class_2960 progressCombo(class_1309 user, boolean isVirtual) {
        class_2960 currentloc = resolvCurrentComboState(user);
        ComboState current = ComboStateRegistry.COMBO_STATE.method_10223(currentloc);

        if (current == null)
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);

        class_2960 next = current.getNext(user);
        if (!next.equals(ComboStateRegistry.getId(ComboStateRegistry.NONE)) && next.equals(currentloc))
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);

        class_2960 rootNext = ComboStateRegistry.COMBO_STATE.method_10223(getComboRoot()).getNext(user);
        ComboState nextCS = ComboStateRegistry.COMBO_STATE.method_10223(next);
        ComboState rootNextCS = ComboStateRegistry.COMBO_STATE.method_10223(rootNext);
        class_2960 resolved = nextCS.getPriority() <= rootNextCS.getPriority() ? next : rootNext;

        if (!isVirtual) {
            this.updateComboSeq(user, resolved);
        }

        return resolved;
    }

    default class_2960 progressCombo(class_1309 user) {
        return progressCombo(user, false);
    }

    default class_2960 doChargeAction(class_1309 user, int elapsed) {
        if (elapsed <= 2)
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);

        if (this.isBroken() || this.isSealed())
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);

        Map.Entry<Integer, class_2960> currentloc = resolvCurrentComboStateTicks(user);

        ComboState current = ComboStateRegistry.COMBO_STATE.method_10223(currentloc.getValue());
        if (current == null)
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);

        // Uninterrupted
        if (currentloc.getValue() != ComboStateRegistry.getId(ComboStateRegistry.NONE) && current.getNext(user) == currentloc.getValue())
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);

        int fullChargeTicks = getFullChargeTicks(user);
        int justReceptionSpan = SlashArts.getJustReceptionSpan(user);
        int justChargePeriod = fullChargeTicks + justReceptionSpan;

        @SuppressWarnings("UnstableApiUsage")
        RangeMap<Integer, SlashArts.ArtsType> charge_accept = ImmutableRangeMap.<Integer, SlashArts.ArtsType>builder()
                .put(Range.lessThan(fullChargeTicks), SlashArts.ArtsType.Fail)
                .put(Range.closedOpen(fullChargeTicks, justChargePeriod), SlashArts.ArtsType.Jackpot)
                .put(Range.atLeast(justChargePeriod), SlashArts.ArtsType.Success).build();

        SlashArts.ArtsType type = charge_accept.get(elapsed);

        if (type != SlashArts.ArtsType.Jackpot) {
            // quick charge
            SlashArts.ArtsType result = current.releaseAction(user, currentloc.getKey());

            if (result != SlashArts.ArtsType.Fail)
                type = result;
        }

        class_2960 csloc = this.getSlashArts().doArts(type, user);

        SlashBladeEvent.ChargeActionEvent event = new SlashBladeEvent.ChargeActionEvent(user, elapsed, this, csloc,
                type);
        SlashBladeEvent.CHARGE_ACTION.invoker().onChargeAction(event);
        if (event.isCanceled()) {
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        }

        csloc = event.getComboState();
        ComboState cs = ComboStateRegistry.COMBO_STATE.method_10223(csloc);

        if (csloc != ComboStateRegistry.getId(ComboStateRegistry.NONE) && !currentloc.getValue().equals(csloc)) {

            if (current.getPriority() > cs.getPriority()) {
                if (type == SlashArts.ArtsType.Jackpot)
                    AdvancementHelper.grantedIf(class_1893.field_23071, user);
                this.updateComboSeq(user, csloc);
            }
        }
        return csloc;
    }

    default void updateComboSeq(class_1309 entity, class_2960 loc) {
        BladeMotionEvent.CALLBACK.invoker().onBladeMotion(new BladeMotionEvent(entity, loc));
        this.setComboSeq(loc);
        this.setLastActionTime(entity.method_37908().method_8510());
        ComboState cs = ComboStateRegistry.COMBO_STATE.method_10223(loc);
        cs.clickAction(entity);
    }

    default class_2960 resolvCurrentComboState(class_1309 user) {
        if (!(user.method_6047().method_7909() instanceof ItemSlashBlade))
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        return resolvCurrentComboStateTicks(user).getValue();
    }

    default Map.Entry<Integer, class_2960> resolvCurrentComboStateTicks(class_1309 user) {
        class_2960 current = ComboStateRegistry.COMBO_STATE.method_10250(getComboSeq()) ? getComboSeq()
                : ComboStateRegistry.getId(ComboStateRegistry.NONE);
        ComboState currentCS = ComboStateRegistry.COMBO_STATE.method_10223(current) != null
                ? ComboStateRegistry.COMBO_STATE.method_10223(current)
                : ComboStateRegistry.NONE;
        int time = (int) TimeValueHelper.getMSecFromTicks(getElapsedTime(user));

        while (!current.equals(ComboStateRegistry.getId(ComboStateRegistry.NONE)) && currentCS.getTimeoutMS() < time) {
            time -= currentCS.getTimeoutMS();

            current = currentCS.getNextOfTimeout(user);
            this.updateComboSeq(user, current);
        }

        int ticks = (int) TimeValueHelper.getTicksFromMSec(time);
        return new AbstractMap.SimpleImmutableEntry<>(ticks, current);
    }

    class_2960 getComboRoot();

    void setComboRoot(class_2960 resourceLocation);

    int getDamage();

    void setDamage(int damage);

    int getMaxDamage();

    void setMaxDamage(int damage);

    List<class_2960> getSpecialEffects();

    void setSpecialEffects(class_2499 list);

    boolean addSpecialEffect(class_2960 se);

    boolean removeSpecialEffect(class_2960 se);

    boolean hasSpecialEffect(class_2960 se);

    boolean isEmpty();

    void setNonEmpty();
}