package mods.flammpfeil.slashblade.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiStack;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.recipe.SlashBladeSmithingRecipe;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import java.util.HashSet;
import java.util.List;

@EmiEntrypoint
public class EMICompat implements EmiPlugin {

    public static final EmiRecipeCategory SLASHBLADE_SMITHING_CATEGORY = new EmiRecipeCategory(
            SlashBlade.prefix("slashblade_smithing"),
            EmiStack.of(class_2246.field_16329)
    );
    public static final EmiRecipeCategory SLASHBLADE_SHAPED_CATEGORY = new EmiRecipeCategory(
            SlashBlade.prefix("shaped_blade"),
            EmiStack.of(class_2246.field_9980)
    );

    @Override
    public void register(EmiRegistry registry) {
        registry.addCategory(SLASHBLADE_SMITHING_CATEGORY);
        registry.addCategory(SLASHBLADE_SHAPED_CATEGORY);

        // 注册SlashBlade锻造配方
        HashSet<class_2960> vanillaSmithing = new HashSet<>();
        List<SlashBladeSmithingRecipe> smithingRecipes = findRecipesByType(class_3956.field_25388).stream()
                .filter(r -> r instanceof SlashBladeSmithingRecipe).map(r -> (SlashBladeSmithingRecipe) r).toList();
        for (SlashBladeSmithingRecipe recipe : smithingRecipes) {
            registry.addRecipe(new SlashBladeSmithingEmiRecipe(recipe));
            vanillaSmithing.add(recipe.method_8114());
        }
        registry.removeRecipes(emiRecipe -> vanillaSmithing.contains(emiRecipe.getId()) && !(emiRecipe instanceof SlashBladeSmithingEmiRecipe));

        // 添加工作站
        registry.addWorkstation(SLASHBLADE_SMITHING_CATEGORY, EmiStack.of(class_2246.field_16329));
        registry.removeRecipes(class_2960.method_12829("emi:/crafting/repairing/slashblade/slashblade"));

    }

    private static <C extends class_1263, T extends class_1860<C>> List<T> findRecipesByType(class_3956<T> type) {
        class_310 instance = class_310.method_1551();
		return instance.field_1687.method_8433().method_30027(type);
    }
}