package mods.flammpfeil.slashblade.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import mods.flammpfeil.slashblade.recipe.SlashBladeSmithingRecipe;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import java.util.ArrayList;
import java.util.List;

public class SlashBladeSmithingEmiRecipe extends EMISimpleRecipe {

    private final SlashBladeSmithingRecipe recipe;

    public SlashBladeSmithingEmiRecipe(SlashBladeSmithingRecipe recipe) {
        super(
                createInputs(recipe),
                createOutputs(recipe),
                recipe.method_8114()
        );
        this.recipe = recipe;
    }

    private static List<EmiIngredient> createInputs(SlashBladeSmithingRecipe recipe) {
        List<EmiIngredient> inputs = new ArrayList<>();
        inputs.add(EmiIngredient.of(recipe.getTemplate()));
        inputs.add(EmiIngredient.of(recipe.getBase()));
        inputs.add(EmiIngredient.of(recipe.getAddition()));
        return inputs;
    }

    private static List<EmiStack> createOutputs(SlashBladeSmithingRecipe recipe) {
        List<EmiStack> outputs = new ArrayList<>();

        class_1799[] additions = recipe.getAddition().method_8105();
        if (additions.length == 0) {
            return outputs;
        }

        class_1799 addition = additions[0];
        for (class_1799 template : recipe.getTemplate().method_8105()) {
            for (class_1799 base : recipe.getBase().method_8105()) {
                class_1263 input = createInput(template, base, addition);
                class_1799 output = assembleResultItem(input, recipe);
                if (!output.method_7960()) {
                    outputs.add(EmiStack.of(output));
                }
            }
        }

        return outputs;
    }

    private static class_1263 createInput(class_1799 template, class_1799 base, class_1799 addition) {
        class_1263 container = new class_1277(3);
        container.method_5447(0, template);
        container.method_5447(1, base);
        container.method_5447(2, addition);
        return container;
    }

    private static class_1799 assembleResultItem(class_1263 input, SlashBladeSmithingRecipe recipe) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        class_5455 registryAccess = level.method_30349();
        return recipe.method_8116(input, registryAccess);
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return EMICompat.SLASHBLADE_SMITHING_CATEGORY;
    }

    @Override
    public int getDisplayWidth() {
        return 112;
    }

    @Override
    public int getDisplayHeight() {
        return 18;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
        // 模板槽位
        widgets.addSlot(inputs.get(0), 0, 0);
        // 基础物品槽位
        widgets.addSlot(inputs.get(1), 18, 0);
        // 添加物品槽位
        widgets.addSlot(inputs.get(2), 36, 0);
        // 输出槽位
        widgets.addSlot(outputs.get(0), 94, 0).recipeContext(this);
    }

	public SlashBladeSmithingRecipe getRecipe() {
		return recipe;
	}
}