package mods.flammpfeil.slashblade.data;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.advancement.SlashBladeItemPredicate;
import mods.flammpfeil.slashblade.data.builtin.SlashBladeBuiltInRegistry;
import mods.flammpfeil.slashblade.data.tag.SlashBladeItemTags;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.recipe.RequestDefinition;
import mods.flammpfeil.slashblade.recipe.SlashBladeIngredient;
import mods.flammpfeil.slashblade.recipe.SlashBladeShapedRecipeBuilder;
import mods.flammpfeil.slashblade.recipe.SlashBladeSmithingRecipeBuilder;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.fabricmc.fabric.impl.tag.convention.TagRegistration;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import java.util.function.Consumer;

public class SlashBladeRecipeProvider extends FabricRecipeProvider {
    public SlashBladeRecipeProvider(FabricDataOutput output) {
        super(output);
    }

    private static class_6862<class_1792> register(String tagID) {
        return TagRegistration.ITEM_TAG_REGISTRATION.registerCommon(tagID);
    }

    public static final class_6862<class_1792> STRING = register("string");
    public static final class_6862<class_1792> RODS_BLAZE = register("blaze_rods");
    public static final class_6862<class_1792> STORAGE_BLOCKS_COAL = register("coal_blocks");
    public static final class_6862<class_1792> CROPS_WHEAT = register("crops/wheat");
    public static final class_6862<class_1792> STORAGE_BLOCKS_QUARTZ = register("quartz_blocks");
    public static final class_6862<class_1792> OBSIDIAN = register("obsidian");
    public static final class_6862<class_1792> FEATHERS = register("feathers");
    public static final class_6862<class_1792> STORAGE_BLOCKS_DIAMOND = register("diamond_blocks");
    public static final class_6862<class_1792> STORAGE_BLOCKS_IRON = register("iron_blocks");
    public static final class_6862<class_1792> STORAGE_BLOCKS_GOlD = register("gold_blocks");
    public static final class_6862<class_1792> STORAGE_BLOCKS_LAPIS = register("lapis_blocks");
    public static final class_6862<class_1792> STORAGE_BLOCKS_REDSTONE = register("redstone_blocks");
    public static final class_6862<class_1792> STORAGE_BLOCKS_EMERALD = register("emerald_blocks");

    @Override
    public void method_10419(Consumer<class_2444> consumer) {
        SlashBladeSmithingRecipeBuilder.smithing(
                        class_1856.method_8091(class_1802.field_41946),
                        SlashBladeIngredient.of(
                                RequestDefinition.Builder.newInstance()
                                        .name(SlashBladeBuiltInRegistry.RODAI_DIAMOND.method_29177())
                                        .build()).toVanilla(),
                        class_1856.method_8106(ConventionalItemTags.NETHERITE_INGOTS),
                        class_7800.field_40639,
                        SlashBladeBuiltInRegistry.RODAI_NETHERITE.method_29177())
                .unlocks(method_32807(class_1802.field_22020), method_10420(ConventionalItemTags.NETHERITE_INGOTS))
                .save(consumer, SlashBlade.prefix("rodai_netherite_smithing"));

        class_2447.method_10437(class_7800.field_40639, SBItems.slashblade_wood).method_10439("  L").method_10439(" L ")
                .method_10439("B  ").method_10434('B', class_1802.field_8091).method_10433('L', class_3489.field_15539)
                .method_10429(method_32807(class_1802.field_8091), method_10426(class_1802.field_8091)).method_10431(consumer);
        SlashBladeShapedRecipeBuilder.shaped(SBItems.slashblade_bamboo).pattern("  L").pattern(" L ").pattern("B  ")
                .define('B', SBItems.slashblade_wood).define('L', SlashBladeItemTags.BAMBOO)
                .method_33530(method_32807(SBItems.slashblade_wood), method_10426(SBItems.slashblade_wood)).method_10431(consumer);
        SlashBladeShapedRecipeBuilder.shaped(SBItems.slashblade_silverbamboo).pattern(" EI").pattern("SBD")
                .pattern("PS ").define('B', SBItems.slashblade_bamboo).define('I', ConventionalItemTags.IRON_INGOTS)
                .define('S', STRING).define('P', class_1802.field_8407).define('E', class_1802.field_8803)
                .define('D', ConventionalItemTags.BLACK_DYES)
                .method_33530(method_32807(SBItems.slashblade_bamboo), method_10426(SBItems.slashblade_bamboo)).method_10431(consumer);
        SlashBladeShapedRecipeBuilder.shaped(SBItems.slashblade_white).pattern("  L").pattern(" L ").pattern("BG ")
                .define('B', SBItems.slashblade_wood).define('L', SBItems.proudsoul_ingot)
                .define('G', ConventionalItemTags.GOLD_INGOTS)
                .method_33530(method_32807(SBItems.slashblade_wood), method_10426(SBItems.slashblade_wood)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.YAMATO.method_29177())
                .pattern("PPP")
                .pattern("PBP")
                .pattern("PPP")
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.YAMATO.method_29177()).addSwordType(SwordType.BROKEN)
                                .addSwordType(SwordType.SEALED).build()).toVanilla())
                .define('P', SBItems.proudsoul_sphere)
                .method_33530(method_32807(SBItems.proudsoul_sphere), method_10423(
                        new SlashBladeItemPredicate(
                                RequestDefinition.Builder.newInstance()
                                        .name(SlashBladeBuiltInRegistry.YAMATO.method_29177()).addSwordType(SwordType.BROKEN)
                                        .addSwordType(SwordType.SEALED).build()
                        )

                ))
                .method_17972(consumer, SlashBlade.prefix("yamato_fix"));

        SlashBladeShapedRecipeBuilder.shaped(SBItems.slashblade).pattern(" EI").pattern("PBD").pattern("SI ")
                .define('B',
                        SlashBladeIngredient.of(SBItems.slashblade_white,
                                RequestDefinition.Builder.newInstance().addSwordType(SwordType.BROKEN).build()).toVanilla())
                .define('I', ConventionalItemTags.GOLD_INGOTS).define('S', STRING).define('P', ConventionalItemTags.BLUE_DYES)
                .define('E', RODS_BLAZE).define('D', STORAGE_BLOCKS_COAL)
                .method_33530(method_32807(SBItems.slashblade_white), method_10426(SBItems.slashblade_white)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.RUBY.method_29177()).pattern("DPI").pattern("PB ")
                .pattern("S  ")
                .define('B',
                        SlashBladeIngredient.of(SBItems.slashblade_silverbamboo,
                                RequestDefinition.Builder.newInstance().addSwordType(SwordType.BROKEN).build()).toVanilla())
                .define('I', SBItems.proudsoul).define('S', STRING).define('P', SBItems.proudsoul_ingot)
                .define('D', ConventionalItemTags.RED_DYES)
                .method_33530(method_32807(SBItems.slashblade_silverbamboo), method_10426(SBItems.slashblade_silverbamboo))
                .method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.FOX_BLACK.method_29177()).pattern(" EF")
                .pattern("BCS").pattern("WQ ").define('W', CROPS_WHEAT)
                .define('Q', STORAGE_BLOCKS_QUARTZ).define('B', class_1802.field_8183)
                .define('S', SBItems.proudsoul_crystal).define('E', OBSIDIAN)
                .define('F', FEATHERS)
                .define('C', SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                        .name(SlashBladeBuiltInRegistry.RUBY.method_29177())
                        .addEnchantment(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9123), 1)).build()).toVanilla())

                .method_33530(method_32807(SBItems.slashblade_silverbamboo), method_10426(SBItems.slashblade_silverbamboo))
                .method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.FOX_WHITE.method_29177()).pattern(" EF")
                .pattern("BCS").pattern("WQ ").define('W', CROPS_WHEAT)
                .define('Q', STORAGE_BLOCKS_QUARTZ).define('B', class_1802.field_8183)
                .define('S', SBItems.proudsoul_crystal).define('E', OBSIDIAN)
                .define('F', FEATHERS)
                .define('C',
                        SlashBladeIngredient.of(
                                RequestDefinition.Builder.newInstance().name(SlashBladeBuiltInRegistry.RUBY.method_29177())

                                        .addEnchantment(new EnchantmentDefinition(
                                                getEnchantmentID(class_1893.field_9110), 1))
                                        .build()).toVanilla())

                .method_33530(method_32807(SBItems.slashblade_silverbamboo), method_10426(SBItems.slashblade_silverbamboo))
                .method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.MURAMASA.method_29177()).pattern("SSS")
                .pattern("SBS").pattern("SSS")
                .define('B',
                        SlashBladeIngredient
                                .of(RequestDefinition.Builder.newInstance().proudSoul(10000).refineCount(20).build()).toVanilla())
                .define('S', class_1856.method_8091(SBItems.proudsoul_sphere))
                .method_33530(method_32807(SBItems.slashblade), method_10423(
                        new SlashBladeItemPredicate(
                                RequestDefinition.Builder.newInstance().build()
                        )

                )).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.TAGAYASAN.method_29177()).pattern("SES")
                .pattern("DBD").pattern("SES")
                .define('B',
                        SlashBladeIngredient.of(SBItems.slashblade_wood, RequestDefinition.Builder.newInstance()
                                .addEnchantment(new EnchantmentDefinition(getEnchantmentID(class_1893.field_9119), 1))
                                .proudSoul(1000).refineCount(10).build()).toVanilla())
                .define('S', class_1856.method_8091(SBItems.proudsoul_sphere)).define('E', class_1856.method_8091(class_1802.field_8449))
                .define('D', class_1856.method_8091(class_1802.field_8634))
                .method_33530(method_32807(SBItems.slashblade_wood), method_10426(SBItems.slashblade_wood)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.AGITO.method_29177()).pattern(" S ").pattern("SBS")
                .pattern(" S ")
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.AGITO_RUST.method_29177()).killCount(100).build()).toVanilla())
                .define('S', class_1856.method_8091(SBItems.proudsoul))
                .method_33530(method_32807(SBItems.proudsoul), method_10426(SBItems.proudsoul)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.OROTIAGITO_SEALED.method_29177()).pattern(" S ")
                .pattern("SBS").pattern(" S ")
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.OROTIAGITO_RUST.method_29177()).killCount(100).build()).toVanilla())
                .define('S', class_1856.method_8091(SBItems.proudsoul))
                .method_33530(method_32807(SBItems.proudsoul), method_10426(SBItems.proudsoul)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.OROTIAGITO.method_29177()).pattern("PSP")
                .pattern("SBS").pattern("PSP")
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.OROTIAGITO_SEALED.method_29177()).killCount(1000)
                                .proudSoul(1000).refineCount(10).build()).toVanilla())
                .define('P', class_1856.method_8091(SBItems.proudsoul)).define('S', class_1856.method_8091(SBItems.proudsoul_sphere))
                .method_33530(method_32807(SBItems.proudsoul_sphere), method_10426(SBItems.proudsoul_sphere)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.DOUTANUKI.method_29177()).pattern("  P")
                .pattern(" B ").pattern("P  ")
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.SABIGATANA.method_29177()).killCount(100).proudSoul(1000)
                                .refineCount(10).build()).toVanilla())
                .define('P', class_1856.method_8091(SBItems.proudsoul_sphere))
                .method_33530(method_32807(SBItems.proudsoul_sphere), method_10426(SBItems.proudsoul_sphere)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.SABIGATANA.method_29177()).pattern("  P")
                .pattern(" P ").pattern("B  ")
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .name(SlashBladeBuiltInRegistry.SABIGATANA.method_29177()).addSwordType(SwordType.BROKEN)
                                .addSwordType(SwordType.SEALED).build()).toVanilla())
                .define('P', class_1856.method_8091(SBItems.proudsoul_ingot))
                .method_33530(method_32807(SBItems.proudsoul_ingot), method_10426(SBItems.proudsoul_ingot)).method_10431(consumer);

        SlashBladeShapedRecipeBuilder.shaped(SlashBladeBuiltInRegistry.TUKUMO.method_29177()).pattern("ESD").pattern("RBL")
                .pattern("ISG").define('D', STORAGE_BLOCKS_DIAMOND)
                .define('L', STORAGE_BLOCKS_LAPIS).define('G', STORAGE_BLOCKS_GOlD)
                .define('I', STORAGE_BLOCKS_IRON).define('R', STORAGE_BLOCKS_REDSTONE)
                .define('E', STORAGE_BLOCKS_EMERALD)
                .define('B',
                        SlashBladeIngredient.of(RequestDefinition.Builder.newInstance()
                                .addEnchantment(
                                        new EnchantmentDefinition(getEnchantmentID(class_1893.field_9124), 1))
                                .build()).toVanilla())
                .define('S', class_1856.method_8091(SBItems.proudsoul_sphere))
                .method_33530(method_32807(SBItems.slashblade), method_10423(
                        new SlashBladeItemPredicate(
                                RequestDefinition.Builder.newInstance().build()
                        )

                )).method_10431(consumer);

        rodaiRecipe(SlashBladeBuiltInRegistry.RODAI_WOODEN.method_29177(), class_1802.field_8091, consumer);
        rodaiRecipe(SlashBladeBuiltInRegistry.RODAI_STONE.method_29177(), class_1802.field_8528, consumer);
        rodaiRecipe(SlashBladeBuiltInRegistry.RODAI_IRON.method_29177(), class_1802.field_8371, consumer);
        rodaiRecipe(SlashBladeBuiltInRegistry.RODAI_GOLDEN.method_29177(), class_1802.field_8845, consumer);
        rodaiAdvRecipe(SlashBladeBuiltInRegistry.RODAI_DIAMOND.method_29177(), class_1802.field_8802, consumer);
        rodaiAdvRecipe(SlashBladeBuiltInRegistry.RODAI_NETHERITE.method_29177(), class_1802.field_22022, consumer);
    }

    private void rodaiRecipe(class_2960 rodai, class_1935 sword, Consumer<class_2444> consumer) {
        SlashBladeShapedRecipeBuilder.shaped(rodai).pattern("  P").pattern(" B ").pattern("WS ").define('B',
                        SlashBladeIngredient.of(SBItems.slashblade_silverbamboo,
                                RequestDefinition.Builder.newInstance().killCount(100).addSwordType(SwordType.BROKEN).build()).toVanilla())
                .define('W', class_1856.method_8091(sword)).define('S', STRING)
                .define('P', class_1856.method_8091(SBItems.proudsoul_crystal))
                .method_33530(method_32807(SBItems.slashblade_silverbamboo), method_10426(SBItems.slashblade_silverbamboo))
                .method_10431(consumer);
    }

    private void rodaiAdvRecipe(class_2960 rodai, class_1935 sword, Consumer<class_2444> consumer) {
        SlashBladeShapedRecipeBuilder.shaped(rodai).pattern("  P").pattern(" B ").pattern("WS ").define('B',
                        SlashBladeIngredient.of(SBItems.slashblade_silverbamboo,
                                RequestDefinition.Builder.newInstance().killCount(100).addSwordType(SwordType.BROKEN).build()).toVanilla())
                .define('W', class_1856.method_8091(sword)).define('S', class_1856.method_8106(STRING))
                .define('P', class_1856.method_8091(SBItems.proudsoul_trapezohedron))
                .method_33530(method_32807(SBItems.slashblade_silverbamboo), method_10426(SBItems.slashblade_silverbamboo))
                .method_10431(consumer);
    }

    private static class_2960 getEnchantmentID(class_1887 enchantment) {
        return class_7923.field_41176.method_10221(enchantment);
    }
}
