package mods.flammpfeil.slashblade.event.handler;

import cn.sh1rocu.slashblade.api.event.AnvilRepairEvent;
import cn.sh1rocu.slashblade.api.event.AnvilUpdateEvent;
import cn.sh1rocu.slashblade.api.extension.BaseItemExtension;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.event.RefineProgressEvent;
import mods.flammpfeil.slashblade.event.RefineSettlementEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.util.concurrent.atomic.AtomicInteger;

public class RefineHandler {
    private static final class SingletonHolder {
        private static final RefineHandler instance = new RefineHandler();
    }

    public static RefineHandler getInstance() {
        return SingletonHolder.instance;
    }

    private RefineHandler() {
    }

    public void register() {
        AnvilUpdateEvent.CALLBACK.register(this::onAnvilUpdateEvent);
        AnvilRepairEvent.CALLBACK.register(this::onAnvilRepairEvent);
        RefineProgressEvent.CALLBACK.register(this::refineLimitCheck);
    }

    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        if (!event.getOutput().method_7960())
            return;

        class_1799 base = event.getLeft();
        class_1799 material = event.getRight();

        if (base.method_7960()) {
            return;
        }
        if (CapabilitySlashBlade.BLADESTATE.maybeGet(base).isEmpty()) {
            return;
        }

        if (material.method_7960()) {
            return;
        }

        boolean isRepairable = base.method_7909().method_7878(base, material);
        if (!isRepairable) {
            return;
        }

        int level = 0;
        if (material.method_7909() instanceof BaseItemExtension extension)
            level = extension.getEnchantmentValue(material);
        else if (material.method_7909() instanceof class_1831 tier)
            level = tier.method_7837();

        if (level < 0) {
            return;
        }

        class_1799 result = base.method_7972();

        int refineLimit = Math.max(10, level);

        int materialCost = 0;
        int levelCostBase = SlashBladeConfig.REFINE_LEVEL_COST.get();
        int costResult = 0;
        AtomicInteger refineResult = new AtomicInteger(0);
        CapabilitySlashBlade.BLADESTATE.maybeGet(result).ifPresent(s -> refineResult.set(s.getRefine()));

        while (materialCost < material.method_7947()) {

            RefineProgressEvent e = new RefineProgressEvent(result,
                    CapabilitySlashBlade.BLADESTATE.maybeGet(result).orElse(new SlashBladeState(result)), materialCost + 1, levelCostBase,
                    costResult, refineResult.get(), event);

            RefineProgressEvent.CALLBACK.invoker().onRefineProgress(e);
            if (e.isCanceled()) {
                break;
            }

            refineResult.set(e.getRefineResult());

            materialCost = e.getMaterialCost();
            costResult = e.getCostResult() + e.getLevelCost();

            if (!event.getPlayer().method_31549().field_7477 && event.getPlayer().field_7520 < costResult) {
                break;
            }
        }

        if (CapabilitySlashBlade.BLADESTATE.maybeGet(result).isPresent()) {
            ISlashBladeState state = CapabilitySlashBlade.BLADESTATE.maybeGet(result).orElse(new SlashBladeState(result));
            RefineSettlementEvent e2 = new RefineSettlementEvent(result,
                    state, materialCost, costResult, refineResult.get(), event);

            RefineSettlementEvent.CALLBACK.invoker().onRefineSettlement(e2);
            if (e2.isCanceled()) {
                return;
            }
            materialCost = e2.getMaterialCost();
            costResult = e2.getCostResult();

            if (state.getRefine() <= refineLimit) {
                if (state.getRefine() + e2.getRefineResult() < 200) {
                    state.setMaxDamage(state.getMaxDamage() + e2.getRefineResult());
                } else if (state.getRefine() < 200) {
                    state.setMaxDamage(state.getMaxDamage() + Math.min(state.getRefine() + e2.getRefineResult(), 200)
                            - state.getRefine());
                }

                state.setProudSoulCount(state.getProudSoulCount() + getRefineProudsoulCount(level, state, e2));

                state.setRefine(e2.getRefineResult());
            }

            result.method_7974(result.method_7919() - Math.max(result.method_7919(), materialCost * Math.max(1, level / 2)));
        }

        event.setMaterialCost(materialCost);
        event.setCost(costResult);
        event.setOutput(result);
    }

    public int getRefineProudsoulCount(int level, ISlashBladeState state, RefineSettlementEvent e2) {
        return (e2.getRefineResult() - state.getRefine())
                * Math.min(5000, level * 10);
    }

    private static final class_2960 REFINE = new class_2960(SlashBlade.MODID, "tips/refine");

    public void onAnvilRepairEvent(AnvilRepairEvent event) {

        if (!(event.getEntity() instanceof class_3222))
            return;

        class_1799 material = event.getRight();// .getIngredientInput();
        class_1799 base = event.getLeft();// .getItemInput();
        class_1799 output = event.getOutput();

        if (base.method_7960())
            return;
        if (!(base.method_7909() instanceof ItemSlashBlade))
            return;
        if (material.method_7960())
            return;

        boolean isRepairable = base.method_7909().method_7878(base, material);

        if (!isRepairable)
            return;

        int before = CapabilitySlashBlade.BLADESTATE.maybeGet(base).map(ISlashBladeState::getRefine).orElse(0);
        int after = CapabilitySlashBlade.BLADESTATE.maybeGet(output).map(ISlashBladeState::getRefine).orElse(0);

        if (before < after)
            AdvancementHelper.grantCriterion((class_3222) event.getEntity(), REFINE);

    }

    public void refineLimitCheck(RefineProgressEvent event) {
        AnvilUpdateEvent oriEvent = event.getOriginalEvent();
        if (oriEvent == null) {
            return;
        }
        int level = 0;
        class_1799 material = oriEvent.getRight();
        if (material.method_7909() instanceof BaseItemExtension extension)
            level = extension.getEnchantmentValue(material);
        else if (material.method_7909() instanceof class_1831 tier)
            level = tier.method_7837();
        int refineLimit = Math.max(10, level);
        if (event.getRefineResult() < refineLimit) {
            event.setRefineResult(event.getRefineResult() + 1);
        }
    }
}
