package mods.flammpfeil.slashblade.recipe;

import com.google.gson.JsonObject;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_8059;
import org.jetbrains.annotations.NotNull;

import java.util.stream.Stream;

public class SlashBladeSmithingRecipe implements class_8059 {
    public static final class_1865<SlashBladeSmithingRecipe> SERIALIZER = new SlashBladeSmithingRecipe.Serializer();
    private final class_2960 outputBlade;
    private final class_2960 id;

    private final class_1856 template;
    private final class_1856 base;
    private final class_1856 addition;

    public SlashBladeSmithingRecipe(class_2960 id, class_2960 outputBlade, class_1856 template, class_1856 base, class_1856 addition) {
        super();
        this.id = id;
        this.outputBlade = outputBlade;
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public SlashBladeSmithingRecipe(class_2960 outputBlade, class_1856 template, class_1856 base, class_1856 addition) {
        this(outputBlade, outputBlade, template, base, addition);
    }

    public class_1856 getTemplate() {
        return template;
    }

    public class_1856 getBase() {
        return base;
    }

    public class_1856 getAddition() {
        return addition;
    }

    private static class_1799 getResultBlade(class_2960 outputBlade) {
        class_1792 bladeItem = class_7923.field_41178.method_10250(outputBlade) ? class_7923.field_41178.method_10223(outputBlade)
                : SBItems.slashblade;

        return bladeItem.method_7854();
    }

    @Override
    public @NotNull class_1799 method_8110(@NotNull class_5455 access) {
        class_1799 result = SlashBladeSmithingRecipe.getResultBlade(this.getOutputBlade());

        if (!class_7923.field_41178.method_10221(result.method_7909()).equals(getOutputBlade())) {
            result = access.method_30530(SlashBladeDefinition.REGISTRY_KEY).method_10223(getOutputBlade())
                    .getBlade();
        }

        return result;
    }

    @Override
    public boolean method_8115(class_1263 container, @NotNull class_1937 level) {
        return this.template.method_8093(container.method_5438(0)) && this.base.method_8093(container.method_5438(1)) && this.addition.method_8093(container.method_5438(2));
    }

    @Override
    public @NotNull class_1799 method_8116(@NotNull class_1263 container, @NotNull class_5455 access) {
        var result = this.method_8110(access);
        if (!(result.method_7909() instanceof ItemSlashBlade)) {
            result = new class_1799(SBItems.slashblade);
        }

        var resultState = CapabilitySlashBlade.BLADESTATE.maybeGet(result).orElseThrow(NullPointerException::new);
        var stack = container.method_5438(1);
        if (CapabilitySlashBlade.BLADESTATE.maybeGet(stack).isEmpty())
            return class_1799.field_8037;
        var ingredientState = CapabilitySlashBlade.BLADESTATE.maybeGet(stack).orElseThrow(NullPointerException::new);

        resultState.setProudSoulCount(resultState.getProudSoulCount() + ingredientState.getProudSoulCount());
        resultState.setKillCount(resultState.getKillCount() + ingredientState.getKillCount());
        resultState.setRefine(resultState.getRefine() + ingredientState.getRefine());
        updateEnchantment(result, stack);

        return result;
    }


    @Override
    public @NotNull class_2960 method_8114() {
        return this.id;
    }

    @Override
    public @NotNull class_1865<?> method_8119() {
        return SlashBladeSmithingRecipe.SERIALIZER;
    }

    @Override
    public boolean method_31584() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(SlashBladeSmithingRecipe::hasNoElements);
    }

    @Override
    public boolean method_48453(@NotNull class_1799 stack) {
        return this.template.method_8093(stack);
    }

    @Override
    public boolean method_48454(@NotNull class_1799 stack) {
        return this.base.method_8093(stack);
    }

    @Override
    public boolean method_30029(@NotNull class_1799 stack) {
        return this.addition.method_8093(stack);
    }

    public class_2960 getOutputBlade() {
        return outputBlade;
    }

    private void updateEnchantment(class_1799 result, class_1799 ingredient) {
        var newItemEnchants = class_1890.method_22445(result.method_7921());
        var oldItemEnchants = class_1890.method_22445(ingredient.method_7921());
        for (class_1887 enchantIndex : oldItemEnchants.keySet()) {
            class_1887 enchantment = enchantIndex;

            int destLevel = newItemEnchants.containsKey(enchantIndex) ? newItemEnchants.get(enchantIndex) : 0;
            int srcLevel = oldItemEnchants.get(enchantIndex);

            srcLevel = Math.max(srcLevel, destLevel);
            srcLevel = Math.min(srcLevel, enchantment.method_8183());

            // boolean canApplyFlag = enchantment.canApplyAtEnchantingTable(result);
            boolean canApplyFlag = enchantment.method_8192(result);
            if (canApplyFlag) {
                for (class_1887 curEnchantIndex : newItemEnchants.keySet()) {
                    if (curEnchantIndex != enchantIndex
                            && !enchantment.method_8188(curEnchantIndex) /* canApplyTogether */) {
                        canApplyFlag = false;
                        break;
                    }
                }
                if (canApplyFlag)
                    newItemEnchants.put(enchantIndex, Integer.valueOf(srcLevel));
            }
        }
        class_1890.method_8214(newItemEnchants, result);
    }

    public static class Serializer implements class_1865<SlashBladeSmithingRecipe> {
        public @NotNull SlashBladeSmithingRecipe method_8121(@NotNull class_2960 id, @NotNull JsonObject json) {
            class_1856 ingredient = class_1856.method_52177(class_3518.method_52226(json, "template"));
            class_1856 ingredient1 = class_1856.method_52177(class_3518.method_52226(json, "base"));
            class_1856 ingredient2 = class_1856.method_52177(class_3518.method_52226(json, "addition"));
            class_2960 output = new class_2960(class_3518.method_15265(json, "blade"));
            return new SlashBladeSmithingRecipe(id, output, ingredient, ingredient1, ingredient2);
        }

        public @NotNull SlashBladeSmithingRecipe method_8122(@NotNull class_2960 id, @NotNull class_2540 buffer) {
            class_1856 ingredient = class_1856.method_8086(buffer);
            class_1856 ingredient1 = class_1856.method_8086(buffer);
            class_1856 ingredient2 = class_1856.method_8086(buffer);
            class_2960 blade = buffer.method_10810();
            return new SlashBladeSmithingRecipe(id, blade, ingredient, ingredient1, ingredient2);
        }

        public void toNetwork(@NotNull class_2540 buffer, SlashBladeSmithingRecipe recipe) {
            recipe.template.method_8088(buffer);
            recipe.base.method_8088(buffer);
            recipe.addition.method_8088(buffer);
            buffer.method_10812(recipe.outputBlade);
        }
    }

    private static boolean hasNoElements(class_1856 ingredient) {
        class_1799[] items = ingredient.method_8105();
        if (items.length == 0) return true;
        if (items.length == 1) {
            //If we potentially added a barrier due to the ingredient being an empty tag, try and check if it is the stack we added
            class_1799 item = items[0];
            return item.method_7909() == class_1802.field_8077 && item.method_7964() instanceof class_5250 hoverName && hoverName.getString().startsWith("Empty Tag: ");
        }
        return false;
    }
}