package mods.flammpfeil.slashblade.registry.slashblade;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import net.minecraft.class_2960;
import java.util.List;

public class PropertiesDefinition {
    public static final Codec<PropertiesDefinition> CODEC = RecordCodecBuilder
            .create(instance -> instance
                    .group(class_2960.field_25139.optionalFieldOf("root_combo", ComboStateRegistry.getId(ComboStateRegistry.STANDBY))
                                    .forGetter(PropertiesDefinition::getComboRoot),
                            class_2960.field_25139.optionalFieldOf("slash_art", SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.JUDGEMENT_CUT))
                                    .forGetter(PropertiesDefinition::getSpecialAttackType),
                            Codec.FLOAT.optionalFieldOf("attack_base", 4.0F)
                                    .forGetter(PropertiesDefinition::getBaseAttackModifier),
                            Codec.INT.optionalFieldOf("max_damage", 40).forGetter(PropertiesDefinition::getMaxDamage),
                            SwordType.CODEC.listOf().optionalFieldOf("sword_type", Lists.newArrayList())
                                    .forGetter(PropertiesDefinition::getDefaultType),
                            class_2960.field_25139.listOf().optionalFieldOf("special_effects", Lists.newArrayList())
                                    .forGetter(PropertiesDefinition::getSpecialEffects),
                            Codec.BOOL.optionalFieldOf("unbreakable", false)
                                    .forGetter(PropertiesDefinition::isUnbreakable)
                    )
                    .apply(instance, PropertiesDefinition::new));

    private final class_2960 comboRoot;
    private final class_2960 specialAttackType;
    private final float baseAttackModifier;
    private final int maxDamage;
    private final List<SwordType> defaultType;
    private final List<class_2960> specialEffects;
    private final boolean unbreakable;

    private PropertiesDefinition(class_2960 comboRoot, class_2960 specialAttackType,
                                 float baseAttackModifier, int damage, List<SwordType> defaultType, List<class_2960> specialEffects, boolean unbreakable) {
        this.comboRoot = comboRoot;
        this.specialAttackType = specialAttackType;
        this.baseAttackModifier = baseAttackModifier;
        this.maxDamage = damage;
        this.defaultType = defaultType;
        this.specialEffects = specialEffects;
        this.unbreakable = unbreakable;
    }


    public List<class_2960> getSpecialEffects() {
        return specialEffects;
    }

    public class_2960 getComboRoot() {
        return comboRoot;
    }

    public class_2960 getSpecialAttackType() {
        return specialAttackType;
    }

    public float getBaseAttackModifier() {
        return baseAttackModifier;
    }

    public int getMaxDamage() {
        return maxDamage;
    }

    public List<SwordType> getDefaultType() {
        return defaultType;
    }

    public boolean isUnbreakable() {
        return unbreakable;
    }

    public static class Builder {
        private class_2960 comboRoot;
        private class_2960 specialAttackType;
        private float baseAttackModifier;
        private int maxDamage;
        private List<SwordType> defaultType;
        private List<class_2960> specialEffects;
        private boolean unbreakable;

        private Builder() {
            this.comboRoot = ComboStateRegistry.getId(ComboStateRegistry.STANDBY);
            this.specialAttackType = SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.JUDGEMENT_CUT);
            this.baseAttackModifier = 4.0F;
            this.maxDamage = 40;
            this.defaultType = Lists.newArrayList();
            this.specialEffects = Lists.newArrayList();
            this.unbreakable = false;
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder rootComboState(class_2960 comboRoot) {
            this.comboRoot = comboRoot;
            return this;
        }

        public Builder slashArtsType(class_2960 specialAttackType) {
            this.specialAttackType = specialAttackType;
            return this;
        }

        public Builder baseAttackModifier(float baseAttackModifier) {
            this.baseAttackModifier = baseAttackModifier;
            return this;
        }

        public Builder maxDamage(int maxDamage) {
            this.maxDamage = maxDamage;
            return this;
        }

        public Builder defaultSwordType(List<SwordType> defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        public Builder addSpecialEffect(class_2960 se) {
            this.specialEffects.add(se);
            return this;
        }

        public Builder setUnbreakable(boolean unbreakable) {
            this.unbreakable = unbreakable;
            return this;
        }

        public PropertiesDefinition build() {
            return new PropertiesDefinition(comboRoot, specialAttackType, baseAttackModifier, maxDamage, defaultType, specialEffects, unbreakable);
        }
    }

}
