package mods.flammpfeil.slashblade.slasharts;

import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class CircleSlash {
    public static void doCircleSlashAttack(class_1309 living, float yRot) {
        if (living.method_37908().method_8608())
            return;

        class_1799 blade = living.method_6047();
        if (CapabilitySlashBlade.BLADESTATE.maybeGet(blade).isEmpty())
            return;
        SlashBladeEvent.DoSlashEvent event = new SlashBladeEvent.DoSlashEvent(blade,
                CapabilitySlashBlade.BLADESTATE.maybeGet(blade).orElseThrow(NullPointerException::new),
                living, 0, true, 0.325D, KnockBacks.cancel);
        event.setYRot(yRot);
        SlashBladeEvent.DoSlashEvent.DO_SLASH.invoker().onDoSlash(event);
        if (event.isCanceled())
            return;

        class_243 pos = living.method_19538().method_1031(0.0D, (double) living.method_5751() * 0.75D, 0.0D)
                .method_1019(living.method_5720().method_1021(0.3f));

        pos = pos.method_1019(VectorHelper.getVectorForRotation(-90.0F, living.method_5705(0)).method_1021(class_243.field_1353.field_1351))
                .method_1019(VectorHelper.getVectorForRotation(0, living.method_5705(0) + 90).method_1021(class_243.field_1353.field_1350))
                .method_1019(living.method_5720().method_1021(class_243.field_1353.field_1350));

        EntitySlashEffect jc = new EntitySlashEffect(SBEntityTypes.SlashEffect, living.method_37908()) {

            @Override
            public class_3414 getSlashSound() {
                return class_3417.field_42593;
            }
        };
        jc.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        jc.method_7432(event.getUser());

        jc.setRotationRoll(0);
        jc.method_36456(living.method_36454() - 22.5F + yRot);
        jc.method_36457(0);

        int colorCode = CapabilitySlashBlade.BLADESTATE.maybeGet(living.method_6047())
                .map(ISlashBladeState::getColorCode).orElse(0xFFFFFF);
        jc.setColor(colorCode);

        jc.setMute(false);
        jc.setIsCritical(event.isCritical());

        jc.setDamage(event.getDamage());

        jc.setKnockBack(event.getKnockback());

        if (living != null)
            CapabilityConcentrationRank.RANK_POINT.maybeGet(living)
                    .ifPresent(rank -> jc.setRank(rank.getRankLevel(living.method_37908().method_8510())));

        living.method_37908().method_8649(jc);
    }

}
