package mods.flammpfeil.slashblade.util;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.attributes.PortingLibAttributes;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.data.tag.SlashBladeEntityTypeTagProvider.EntityTypeTags;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1510;
import net.minecraft.class_1531;
import net.minecraft.class_1541;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4051;
import javax.annotation.Nullable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TargetSelector {
    public static final class_4051 lockon = new SlashBladeTargetingConditions().method_18418(40.0D)
            .method_18420(new AttackablePredicate());

    public static final class_4051 test = new SlashBladeTargetingConditions()
            .method_18420(new AttackablePredicate());

    static final String AttackableTag = "RevengeAttacker";

    static boolean isAttackable(class_1297 revengeTarget, class_1297 attacker) {
        return revengeTarget != null && attacker != null
                && (revengeTarget == attacker || revengeTarget.method_5722(attacker));
    }

    public static final class_4051 areaAttack = new SlashBladeTargetingConditions().method_18418(12.0D)
            .method_18424().method_18420(new AttackablePredicate());

    public static class_4051 getAreaAttackPredicate(double reach) {
        return areaAttack.method_18418(reach);
    }

    public static class AttackablePredicate implements Predicate<class_1309> {

        public boolean test(class_1309 livingentity) {

            if (!SlashBladeConfig.PVP_ENABLE.get() && livingentity instanceof class_1657)
                return false;

            if (livingentity instanceof class_1531)
                if (((class_1531) livingentity).method_6912())
                    return true;
                else
                    return false;

            if (livingentity.method_5752().contains(AttackableTag)) {
                livingentity.method_5738(AttackableTag);
                return true;
            }

            if (!SlashBladeConfig.FRIENDLY_ENABLE.get() && !(livingentity instanceof class_1569)) {
                return false;
            }

            if (livingentity.method_5703(entity -> entity instanceof class_1657))
                return false;

            if (livingentity.method_5851())
                return true;

            if (livingentity.method_5781() != null)
                return true;

            return !livingentity.method_5864().method_20210(EntityTypeTags.ATTACKABLE_BLACKLIST);
        }
    }

    public static List<class_1297> getReflectableEntitiesWithinAABB(class_1309 attacker) {
        double reach = TargetSelector.getResolvedReach(attacker);

        class_238 aabb = getResolvedAxisAligned(attacker.method_5829(), attacker.method_5720(), reach);
        class_1937 world = attacker.method_37908();
        return Stream.of(world.method_18467(class_1676.class, aabb).stream()
                        .filter(e -> ((e.method_24921()/* getThrower() */ == null || e.method_24921()/* getThrower() */ != attacker)
                                && (e instanceof IShootable ? ((IShootable) e).getShooter() != attacker : true))))
                /*
                 * world.getEntitiesWithinAABB(DamagingProjectileEntity.class, aabb).stream()
                 * .filter(e-> (e.shootingEntity == null || e.shootingEntity != attacker)),
                 * world.getEntitiesWithinAABB(AbstractArrowEntity.class, aabb).stream()
                 * .filter(e->e.getShooter() == null || e.getShooter() != attacker))
                 */
                .flatMap(s -> s).filter(e -> (e.method_5858(attacker) < (reach * reach)))
                .collect(Collectors.toList());
    }

    public static List<class_1297> getExtinguishableEntitiesWithinAABB(class_1309 attacker) {
        double reach = TargetSelector.getResolvedReach(attacker);

        class_238 aabb = getResolvedAxisAligned(attacker.method_5829(), attacker.method_5720(), reach);
        class_1937 world = attacker.method_37908();
        return world.method_18467(class_1541.class, aabb).stream()
                .filter(e -> (e.method_5858(attacker) < (reach * reach))).collect(Collectors.toList());
    }

    public static List<class_1297> getTargettableEntitiesWithinAABB(class_1937 world, class_1309 attacker) {
        return getTargettableEntitiesWithinAABB(world, attacker,
                getResolvedAxisAligned(attacker.method_5829(), attacker.method_5720(), getResolvedReach(attacker)));
    }

    public static List<class_1297> getTargettableEntitiesWithinAABB(class_1937 world, class_1309 attacker, class_238 aabb) {
        double reach = TargetSelector.getResolvedReach(attacker);

        return getTargettableEntitiesWithinAABB(world, attacker, aabb, reach);
    }

    public static List<class_1297> getTargettableEntitiesWithinAABB(class_1937 world, class_1309 attacker, class_238 aabb,
                                                                double reach) {
        List<class_1297> list1 = Lists.newArrayList();

        list1.addAll(getReflectableEntitiesWithinAABB(attacker));
        list1.addAll(getExtinguishableEntitiesWithinAABB(attacker));

        list1.addAll(world.method_8390(class_1309.class, aabb.method_1014(5), e -> true /*e.isMultipartEntity()*/).stream()
                /*.flatMap(e -> (e.isMultipartEntity()) ? Stream.of(e.getParts()) : Stream.of(e))*/.filter(t -> {
                    boolean result = false;
                    var check = new AttackablePredicate();
                    //if (t instanceof LivingEntity living) {
                    //result = check.test(living);
                    result = check.test(t);
                    //} else if (t instanceof PartEntity<?> part) {
                    //if (part.getParent() instanceof LivingEntity living)
                    //    result = check.test(living) && part.distanceToSqr(attacker) < (reach * reach);
                    //}
                    return result;
                }).toList());

        class_4051 predicate = getAreaAttackPredicate(reach);

        list1.addAll(world.method_18467(class_1309.class, aabb).stream()
                /*.flatMap(e -> (e.isMultipartEntity()) ? Stream.of(e.getParts()) : Stream.of(e))*/.filter(t -> {
                    boolean result = false;
                    //if (t instanceof LivingEntity living) {
                    //    result = predicate.test(attacker, living);
                    result = predicate.method_18419(attacker, t);
                    //} else if (t instanceof PartEntity<?> part) {
                    //    if (part.getParent() instanceof LivingEntity living)
                    //        result = predicate.test(attacker, living) && part.distanceToSqr(attacker) < (reach * reach);
                    // }
                    return result;
                }).toList());

        return list1;
    }

    public static <E extends class_1297 & IShootable> List<class_1297> getTargettableEntitiesWithinAABB(class_1937 world,
                                                                                                double reach, E owner) {
        class_238 aabb = owner.method_5829().method_1014(reach);

        List<class_1297> list1 = Lists.newArrayList();

        list1.addAll(world.method_18467(class_1510.class, aabb.method_1014(5)).stream()
                .flatMap(d -> Arrays.stream(d.method_5690())).filter(e -> (e.method_5858(owner) < (reach * reach)))
                .collect(Collectors.toList()));

        class_1309 user;
        if (owner.getShooter() instanceof class_1309)
            user = (class_1309) owner.getShooter();
        else
            user = null;

        list1.addAll(getReflectableEntitiesWithinAABB(world, reach, owner));

        class_4051 predicate = getAreaAttackPredicate(0); // reach check has already been completed

        list1.addAll(world.method_8390(class_1309.class, aabb, (e) -> true).stream()
                .filter(t -> predicate.method_18419(user, t)).collect(Collectors.toList()));

        return list1;
    }

    public static <E extends class_1297 & IShootable> List<class_1297> getReflectableEntitiesWithinAABB(class_1937 world,
                                                                                                double reach, E owner) {
        class_238 aabb = owner.method_5829().method_1014(reach);

        return Stream
                .of(world.method_18467(class_1676.class, aabb).stream()
                        .filter(e -> (e.method_24921()/* getThrower() */ == null
                                || e.method_24921()/* getThrower() */ != owner.getShooter())))
                /*
                 * world.getEntitiesWithinAABB(DamagingProjectileEntity.class, aabb).stream()
                 * .filter(e-> (e.shootingEntity == null || e.shootingEntity !=
                 * owner.getShooter())), world.getEntitiesWithinAABB(AbstractArrowEntity.class,
                 * aabb).stream() .filter(e->e.getShooter() == null || e.getShooter() !=
                 * owner.getShooter()))
                 */
                .flatMap(s -> s).filter(e -> (e.method_5858(owner) < (reach * reach)) && e != owner)
                .collect(Collectors.toList());
    }

    public static class_238 getResolvedAxisAligned(class_238 bb, class_243 dir, double reach) {
        final double padding = 1.0;

        if (dir == class_243.field_1353) {
            bb = bb.method_1014(reach * 2);
        } else {
            bb = bb.method_997(dir.method_1021(reach * 0.5)).method_1014(reach);
        }

        bb = bb.method_1014(padding);

        return bb;
    }

    public static double getResolvedReach(class_1309 user) {
        double reach = 4.0D; /* 4 block */
        class_1324 attrib = user.method_5996(PortingLibAttributes.ENTITY_REACH);
        if (attrib != null) {
            reach = attrib.method_6194() - 1;
        }
        return reach;
    }

    public static void onInputChange(InputCommandEvent event) {

        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        class_3222 sender = event.getEntity();


        class_1799 stack = sender.method_6047();
        if (stack.method_7960())
            return;
        if (!(stack.method_7909() instanceof ItemSlashBlade))
            return;

        // SneakHold & Middle Click
        if (!(!old.contains(InputCommand.M_DOWN) && current.contains(InputCommand.M_DOWN)
                && current.contains(InputCommand.SNEAK)))
            return;
        CapabilitySlashBlade.BLADESTATE.maybeGet(stack).ifPresent(s -> {
            class_1297 tmp = s.getTargetEntity(sender.method_37908());
            if (tmp == null)
                return;
            if (!(tmp instanceof class_1309))
                return;

            class_1309 target = (class_1309) tmp;

            if (target.method_6065() == sender)
                return;

            target.method_6015(sender);

            if (target.method_37908() instanceof class_3218) {
                class_3218 sw = (class_3218) target.method_37908();

                sw.method_14166(sender, class_2398.field_11231, false, target.method_23317(),
                        target.method_23318() + target.method_5751(), target.method_23321(), 5, target.method_17681() * 1.5,
                        target.method_17682(), target.method_17681() * 1.5, 0.02D);
            }
        });
    }

    public static class SlashBladeTargetingConditions extends class_4051 {

        public SlashBladeTargetingConditions() {
            super(true);
        }

        @Override
        public boolean method_18419(@Nullable class_1309 attacker, class_1309 target) {
            boolean isAttackable = false;

            isAttackable |= isAttackable(target.method_6065(), attacker);

            if (!isAttackable && target instanceof class_1308)
                isAttackable |= isAttackable(((class_1308) target).method_5968(), attacker);

            if (isAttackable)
                target.method_5780(AttackableTag);

            return super.method_18419(attacker, target);
        }
    }

}
