package mods.flammpfeil.slashblade.ability;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.entity.*;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.init.SBStatTypes;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.util.*;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class SummonedSwordArts {
    private static final class SingletonHolder {
        private static final SummonedSwordArts instance = new SummonedSwordArts();
    }

    public static SummonedSwordArts getInstance() {
        return SingletonHolder.instance;
    }

    private SummonedSwordArts() {
    }

    public void register() {
        InputCommandEvent.CALLBACK.register(this::onInputChange);
    }

    public static final class_2960 ADVANCEMENT_SUMMONEDSWORDS = new class_2960(SlashBlade.MODID,
            "arts/shooting/summonedswords");
    public static final class_2960 ADVANCEMENT_SPIRAL_SWORDS = new class_2960(SlashBlade.MODID,
            "arts/shooting/spiral_swords");
    public static final class_2960 ADVANCEMENT_STORM_SWORDS = new class_2960(SlashBlade.MODID,
            "arts/shooting/storm_swords");
    public static final class_2960 ADVANCEMENT_BLISTERING_SWORDS = new class_2960(SlashBlade.MODID,
            "arts/shooting/blistering_swords");
    public static final class_2960 ADVANCEMENT_HEAVY_RAIN_SWORDS = new class_2960(SlashBlade.MODID,
            "arts/shooting/heavy_rain_swords");

    public void onInputChange(InputCommandEvent event) {

        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        class_3222 sender = event.getEntity();

        class_1799 blade = sender.method_6047();
        var bladeState = CapabilitySlashBlade.BLADESTATE.maybeGet(blade).orElse(new SlashBladeState(blade));

        if (bladeState.isBroken() || bladeState.isSealed()
                || !SwordType.from(blade).contains(SwordType.BEWITCHED))
            return;

        int powerLevel = class_1890
                .method_8225(class_1893.field_9103, blade);
        if (powerLevel <= 0)
            return;

        InputCommand targetCommand = InputCommand.M_DOWN;


        boolean onDown = !old.contains(targetCommand) && current.contains(targetCommand);

        final Long pressTime = event.getState().getLastPressTime(targetCommand);

        // basic summoned swords
        if (onDown) {

            CapabilityInputState.INPUT_STATE.maybeGet(sender).ifPresent(input -> {

                // SpiralSwords command
                input.getScheduler().schedule("SpiralSwords", pressTime + 10, (rawEntity, queue, now) -> {
                    if (!(rawEntity instanceof class_3222))
                        return;
                    class_3222 entity = (class_3222) rawEntity;

                    InputCommand targetCommnad = InputCommand.M_DOWN;
                    boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet(entity)
                            .filter(input3 -> input3.getCommands().contains(targetCommnad)
                                    && (!InputCommand.anyMatch(input3.getCommands(), InputCommand.move)
                                    || !input3.getCommands().contains(InputCommand.SNEAK))
                                    && input3.getLastPressTime(targetCommnad) == pressTime)
                            .isPresent();

                    if (!inputSucceed)
                        return;

                    // spiralSwords
                    boolean alreadySummoned = entity.method_5685().stream()
                            .anyMatch(e -> e instanceof EntitySpiralSwords);

                    if (alreadySummoned) {
                        // fire
                        List<class_1297> list = entity.method_5685().stream()
                                .filter(e -> e instanceof EntitySpiralSwords).toList();

                        list.stream().forEach(e -> {
                            ((EntitySpiralSwords) e).doFire();
                        });
                    } else {
                        // summon
                        CapabilitySlashBlade.BLADESTATE.maybeGet(entity.method_6047()).ifPresent((state) -> {

                            if (state.getProudSoulCount() < SlashBladeConfig.SUMMON_SWORD_ART_COST.get())
                                return;
                            state.setProudSoulCount(
                                    state.getProudSoulCount() - SlashBladeConfig.SUMMON_SWORD_ART_COST.get());

                            //圆环幻影剑
                            AdvancementHelper.grantCriterion(entity, ADVANCEMENT_SPIRAL_SWORDS);

                            class_1937 worldIn = entity.method_37908();

                            int rank = CapabilityConcentrationRank.RANK_POINT.maybeGet(entity)
                                    .map(r -> r.getRank(worldIn.method_8510()).level).orElse(0);

                            int count = 6;

                            if (IConcentrationRank.ConcentrationRanks.S.level <= rank) {
                                count = 8;
                            }

                            for (int i = 0; i < count; i++) {
                                EntitySpiralSwords ss = new EntitySpiralSwords(
                                        SBEntityTypes.SpiralSwords, worldIn);
                                ss.method_33574(entity.method_19538());
                                ss.method_7432(entity);
                                ss.setColor(state.getColorCode());
                                ss.setRoll(0);
                                ss.setDamage(powerLevel);
                                // force riding
                                ss.method_5873(entity, true);

                                ss.setDelay(360 / count * i);

                                worldIn.method_8649(ss);

                                entity.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2F,
                                        1.45F);
                            }
                        });
                    }
                });

                // StormSwords command
                input.getScheduler().schedule("StormSwords", pressTime + 10, (rawEntity, queue, now) -> {
                    if (!(rawEntity instanceof class_3222))
                        return;
                    class_3222 entity = (class_3222) rawEntity;

                    InputCommand targetCommnad = InputCommand.M_DOWN;
                    boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet(entity)
                            .filter(input4 -> input4.getCommands().contains(targetCommnad)
                                    && input4.getCommands().contains(InputCommand.SNEAK)
                                    && input4.getCommands().contains(InputCommand.BACK)
                                    && !input4.getCommands().contains(InputCommand.FORWARD)
                                    && input4.getLastPressTime(targetCommnad) == pressTime)
                            .isPresent();
                    if (!inputSucceed)
                        return;

                    // summon
                    CapabilitySlashBlade.BLADESTATE.maybeGet(entity.method_6047()).ifPresent((state) -> {

                        class_1937 worldIn = entity.method_37908();
                        class_1297 target = state.getTargetEntity(worldIn);

                        if (target == null || !target.method_5805() || target.method_31481()) return;
                        if (state.getProudSoulCount() < SlashBladeConfig.SUMMON_SWORD_ART_COST.get())
                            return;
                        state.setProudSoulCount(
                                state.getProudSoulCount() - SlashBladeConfig.SUMMON_SWORD_ART_COST.get());
                        //烈风环影剑
                        AdvancementHelper.grantCriterion(entity, ADVANCEMENT_STORM_SWORDS);

                        int rank = CapabilityConcentrationRank.RANK_POINT.maybeGet(entity)
                                .map(r -> r.getRank(worldIn.method_8510()).level).orElse(0);

                        int count = 6;

                        if (IConcentrationRank.ConcentrationRanks.S.level <= rank) {
                            count = 8;
                        }

                        for (int i = 0; i < count; i++) {
                            EntityStormSwords ss = new EntityStormSwords(SBEntityTypes.StormSwords,
                                    worldIn);

                            ss.method_33574(entity.method_19538());
                            ss.method_7432(entity);
                            ss.setColor(state.getColorCode());
                            ss.setRoll(0);
                            ss.setDamage(powerLevel);
                            // force riding
                            ss.method_5873(target, true);
                            ss.setDelay(360 / count * i);
                            worldIn.method_8649(ss);

                            entity.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2F,
                                    1.45F);
                        }
                    });
                });

                // BlisteringSwords command
                input.getScheduler().schedule("BlisteringSwords", pressTime + 10, (rawEntity, queue, now) -> {
                    if (!(rawEntity instanceof class_3222))
                        return;
                    class_3222 entity = (class_3222) rawEntity;

                    InputCommand targetCommnad = InputCommand.M_DOWN;
                    boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet(entity)
                            .filter(input1 -> input1.getCommands().contains(targetCommnad)
                                    && input1.getCommands().contains(InputCommand.SNEAK)
                                    && input1.getCommands().contains(InputCommand.FORWARD)
                                    && input1.getLastPressTime(InputCommand.BACK) + 20 < now
                                    && input1.getLastPressTime(targetCommnad) == pressTime)
                            .isPresent();
                    if (!inputSucceed)
                        return;

                    // summon
                    CapabilitySlashBlade.BLADESTATE.maybeGet(entity.method_6047()).ifPresent((state) -> {

                        class_1937 worldIn = entity.method_37908();

                        if (state.getProudSoulCount() < SlashBladeConfig.SUMMON_SWORD_ART_COST.get())
                            return;
                        state.setProudSoulCount(
                                state.getProudSoulCount() - SlashBladeConfig.SUMMON_SWORD_ART_COST.get());
                        //急袭幻影剑
                        AdvancementHelper.grantCriterion(entity, ADVANCEMENT_BLISTERING_SWORDS);

                        int rank = CapabilityConcentrationRank.RANK_POINT.maybeGet(entity)
                                .map(r -> r.getRank(worldIn.method_8510()).level).orElse(0);

                        int count = 6;

                        if (IConcentrationRank.ConcentrationRanks.S.level <= rank) {
                            count = 8;
                        }

                        for (int i = 0; i < count; i++) {
                            EntityBlisteringSwords ss = new EntityBlisteringSwords(
                                    SBEntityTypes.BlisteringSwords, worldIn);

                            ss.method_33574(entity.method_19538());
                            ss.method_7432(entity);
                            ss.setColor(state.getColorCode());
                            ss.setRoll(0);
                            ss.setDamage(powerLevel);
                            // force riding
                            ss.method_5873(entity, true);

                            ss.setDelay(i);

                            worldIn.method_8649(ss);

                            entity.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2F,
                                    1.45F);
                        }
                    });
                });

                // BlisteringSwords command
                input.getScheduler().schedule("HeavyRainSwords", pressTime + 10, (rawEntity, queue, now) -> {
                    if (!(rawEntity instanceof class_3222))
                        return;
                    class_3222 entity = (class_3222) rawEntity;

                    InputCommand targetCommnad = InputCommand.M_DOWN;
                    boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet(entity)
                            .filter(input2 -> input2.getCommands().contains(targetCommnad)
                                    && input2.getCommands().contains(InputCommand.SNEAK)
                                    && input2.getCommands().contains(InputCommand.FORWARD)
                                    && input2.getLastPressTime(InputCommand.BACK) + 30 > now
                                    && input2.getLastPressTime(targetCommnad) == pressTime)
                            .isPresent();
                    if (!inputSucceed)
                        return;

                    // summon
                    CapabilitySlashBlade.BLADESTATE.maybeGet(entity.method_6047()).ifPresent((state) -> {

                        class_1937 worldIn = entity.method_37908();
                        class_1297 target = state.getTargetEntity(worldIn);
                        if (state.getProudSoulCount() < SlashBladeConfig.SUMMON_SWORD_ART_COST.get())
                            return;
                        state.setProudSoulCount(
                                state.getProudSoulCount() - SlashBladeConfig.SUMMON_SWORD_ART_COST.get());

                        //五月雨
                        AdvancementHelper.grantCriterion(entity, ADVANCEMENT_HEAVY_RAIN_SWORDS);

                        int rank = CapabilityConcentrationRank.RANK_POINT.maybeGet(entity)
                                .map(r -> r.getRank(worldIn.method_8510()).level).orElse(0);

                        class_243 basePos;

                        if (target != null) {
                            basePos = target.method_19538();
                        } else {
                            class_243 forwardDir = calculateViewVector(0, entity.method_36454());
                            basePos = entity.method_30950(0).method_1019(forwardDir.method_1021(5));
                        }

                        float yOffset = 7;
                        basePos = basePos.method_1031(0, yOffset, 0);

                        {// no random pos
                            EntityHeavyRainSwords ss = new EntityHeavyRainSwords(
                                    SBEntityTypes.HeavyRainSwords, worldIn);

                            ss.method_7432(entity);
                            ss.setColor(state.getColorCode());
                            ss.setRoll(0);
                            ss.setDamage(powerLevel);
                            // force riding
                            ss.method_5873(entity, true);

                            ss.setDelay(0);

                            ss.method_33574(basePos);

                            ss.method_36457(-90);

                            worldIn.method_8649(ss);
                        }

                        int count = 9 + Math.min(rank - 1, 0);
                        int multiplier = 2;
                        for (int i = 0; i < count; i++)
                            for (int l = 0; l < multiplier; l++) {
                                EntityHeavyRainSwords ss = new EntityHeavyRainSwords(
                                        SBEntityTypes.HeavyRainSwords, worldIn);

                                ss.method_7432(entity);
                                ss.setColor(state.getColorCode());
                                ss.setRoll(0);
                                ss.setDamage(powerLevel);
                                // force riding
                                ss.method_5873(entity, true);

                                ss.setDelay(i);

                                ss.setSpread(basePos);

                                ss.method_36457(-90);

                                worldIn.method_8649(ss);

                                entity.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2F,
                                        1.45F);
                            }
                    });
                });

            });

            CapabilitySlashBlade.BLADESTATE.maybeGet(blade).ifPresent((state) -> {

                if (state.getProudSoulCount() < SlashBladeConfig.SUMMON_SWORD_COST.get())
                    return;
                state.setProudSoulCount(state.getProudSoulCount() - SlashBladeConfig.SUMMON_SWORD_COST.get());
                //幻影剑
                AdvancementHelper.grantCriterion(sender, ADVANCEMENT_SUMMONEDSWORDS);

                Optional<class_1297> foundTarget = findTarget(sender, state.getTargetEntity(sender.method_37908()));

                class_1937 worldIn = sender.method_37908();
                class_243 targetPos = foundTarget.map((e) -> new class_243(e.method_23317(), e.method_23318() + e.method_5751() * 0.5, e.method_23321()))
                        .orElseGet(() -> {
                            class_243 start = sender.method_5836(1.0f);
                            class_243 end = start.method_1019(sender.method_5720().method_1021(40));
                            class_239 result = worldIn.method_17742(new class_3959(start, end, class_3959.class_3960.field_17558,
                                    class_3959.class_242.field_1348, sender));
                            return result.method_17784();
                        });

                int counter = StatHelper.increase(sender, SBStatTypes.SWORD_SUMMONED, 1);
                boolean sided = counter % 2 == 0;

                EntityAbstractSummonedSword ss = new EntityAbstractSummonedSword(
                        SBEntityTypes.SummonedSword, worldIn);

                class_243 pos = sender.method_5836(1.0f)
                        .method_1019(VectorHelper.getVectorForRotation(0.0f, sender.method_5705(0) + 90).method_1021(sided ? 1 : -1));
                ss.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
                ss.setDamage(powerLevel);
                class_243 dir = targetPos.method_1020(pos).method_1029();
                ss.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 3.0f, 0.0f);
                // ss.setDamage(counter);
                ss.method_7432(sender);
                ss.setColor(state.getColorCode());
                ss.setRoll(sender.method_6051().method_43057() * 360.0f);
                worldIn.method_8649(ss);

                sender.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2F, 1.45F);
            });
        }
    }

    public Optional<class_1297> findTarget(class_3222 sender, class_1297 lockedT) {
        Optional<class_1297> foundTarget = Stream.of(Optional.ofNullable(lockedT),
                        RayTraceHelper
                                .rayTrace(sender.method_37908(), sender, sender.method_5836(1.0f), sender.method_5720(),
                                        12, 12, (e) -> true)
                                .filter(r -> r.method_17783() == class_239.class_240.field_1331).filter(r -> {
                                    class_3966 er = (class_3966) r;
                                    class_1297 target = er.method_17782();

                                    boolean isMatch = true;
                                    if (target instanceof class_1309)
                                        isMatch = TargetSelector.lockon.method_18419(sender, (class_1309) target);

                                    if (target instanceof IShootable)
                                        isMatch = ((IShootable) target).getShooter() != sender;

                                    return isMatch;
                                }).map(r -> ((class_3966) r).method_17782()))
                .filter(Optional::isPresent).map(Optional::get).findFirst();
        return foundTarget;
    }

    class_243 calculateViewVector(float x, float y) {
        float f = x * ((float) Math.PI / 180F);
        float f1 = -y * ((float) Math.PI / 180F);
        float f2 = class_3532.method_15362(f1);
        float f3 = class_3532.method_15374(f1);
        float f4 = class_3532.method_15362(f);
        float f5 = class_3532.method_15374(f);
        return new class_243(f3 * f4, -f5, f2 * f4);
    }
}
