package mods.flammpfeil.slashblade.capability.slashblade;

import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

import javax.annotation.Nonnull;
import java.awt.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * Reference implementation of {@link ISlashBladeState}. Use/extend this or
 * implement your own.
 * <p>
 */
public class SlashBladeState extends ItemComponent implements ISlashBladeState {
    private static final String IS_EMPTY = "isEmpty";

    public SlashBladeState(class_1799 blade) {
        super(blade);
    }

    private class_2487 getBladeState() {
        return stack.method_7911("bladeState");
    }

    @Override
    public long getLastActionTime() {
        return getBladeState().method_10537(LAST_ACTION_TIME);
    }

    @Override
    public void setLastActionTime(long lastActionTime) {
        getBladeState().method_10544(LAST_ACTION_TIME, lastActionTime);
    }

    @Override
    public boolean onClick() {
        return getBladeState().method_10577(ON_CLICK);
    }

    @Override
    public void setOnClick(boolean onClick) {
        getBladeState().method_10556(ON_CLICK, onClick);
    }

    @Override
    public float getFallDecreaseRate() {
        return getBladeState().method_10583(FALL_DECREASE_RATE);
    }

    @Override
    public void setFallDecreaseRate(float fallDecreaseRate) {
        getBladeState().method_10548(FALL_DECREASE_RATE, fallDecreaseRate);
    }

    @Override
    public float getAttackAmplifier() {
        return getBladeState().method_10583(ATTACK_AMPLIFIER);
    }

    @Override
    public void setAttackAmplifier(float attackAmplifier) {
        getBladeState().method_10548(ATTACK_AMPLIFIER, attackAmplifier);
    }

    @Override
    @Nonnull
    public class_2960 getComboSeq() {
        if (getBladeState().method_10558(CURRENT_COMBO).isEmpty())
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        class_2960 location = class_2960.method_12829(getBladeState().method_10558(CURRENT_COMBO));
        return location != null && ComboStateRegistry.COMBO_STATE.method_10250(location) ? location : ComboStateRegistry.getId(ComboStateRegistry.NONE);
    }

    @Override
    public void setComboSeq(class_2960 comboSeq) {
        if (ComboStateRegistry.COMBO_STATE.method_10250(comboSeq)) {
            getBladeState().method_10582(CURRENT_COMBO, comboSeq.toString());
        } else {
            class_2960 id = ComboStateRegistry.getId(ComboStateRegistry.NONE);
            getBladeState().method_10582(CURRENT_COMBO, id.toString());
        }
    }

    @Override
    public boolean isBroken() {
        return getBladeState().method_10577(IS_BROKEN);
    }

    @Override
    public void setBroken(boolean broken) {
        getBladeState().method_10556(IS_BROKEN, broken);
    }

    @Override
    public boolean isSealed() {
        return getBladeState().method_10577(IS_SEALED);
    }

    @Override
    public void setSealed(boolean sealed) {
        getBladeState().method_10556(IS_SEALED, sealed);
    }

    @Override
    public float getBaseAttackModifier() {
        return getBladeState().method_10583(BASE_ATTACK_MODIFIER);
    }

    @Override
    public void setBaseAttackModifier(float baseAttackModifier) {
        getBladeState().method_10548(BASE_ATTACK_MODIFIER, baseAttackModifier);
    }

    @Override
    public int getKillCount() {
        return getBladeState().method_10550(KILL_COUNT);
    }

    @Override
    public void setKillCount(int killCount) {
        getBladeState().method_10569(KILL_COUNT, killCount);
    }

    @Override
    public int getRefine() {
        return getBladeState().method_10550(REPAIR_COUNTER);
    }

    @Override
    public void setRefine(int refine) {
        getBladeState().method_10569(REPAIR_COUNTER, refine);
    }

    @Override
    public class_2960 getSlashArtsKey() {
        if (getBladeState().method_10558(SPECIAL_ATTACK_TYPE).isEmpty())
            return SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.JUDGEMENT_CUT);
        class_2960 location = class_2960.method_12829(getBladeState().method_10558(SPECIAL_ATTACK_TYPE));
        return location != null ? location : SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.JUDGEMENT_CUT);
    }

    @Override
    public void setSlashArtsKey(class_2960 key) {
        if (SlashArtsRegistry.SLASH_ARTS.method_10250(key)) {
            getBladeState().method_10582(SPECIAL_ATTACK_TYPE, key.toString());
        } else {
            class_2960 id = SlashArtsRegistry.SLASH_ARTS.method_10221(SlashArtsRegistry.JUDGEMENT_CUT);
            getBladeState().method_10582(SPECIAL_ATTACK_TYPE, id.toString());
        }
    }

    @Override
    public boolean isDefaultBewitched() {
        return getBladeState().method_10577(IS_DEFAULT_BEWITCHED);
    }

    @Override
    public void setDefaultBewitched(boolean defaultBewitched) {
        getBladeState().method_10556(IS_DEFAULT_BEWITCHED, defaultBewitched);
    }

    @Override
    public @NotNull String getTranslationKey() {
        return getBladeState().method_10558(TRANSLATION_KEY);
    }

    @Override
    public void setTranslationKey(String translationKey) {
        String key = Optional.ofNullable(translationKey).orElse("");
        getBladeState().method_10582(TRANSLATION_KEY, key);
    }

    @Override
    @Nonnull
    public CarryType getCarryType() {
        return EnumSetConverter.fromOrdinal(CarryType.values(), getBladeState().method_10550(STANDBY_RENDER_TYPE), CarryType.PSO2);
    }

    @Override
    public void setCarryType(CarryType carryType) {
        getBladeState().method_10569(STANDBY_RENDER_TYPE, carryType.ordinal());
    }

    @Override
    public @NotNull Color getEffectColor() {
        if (getBladeState().method_10545(SUMMONED_SWORD_COLOR))
            return new Color(getBladeState().method_10550(SUMMONED_SWORD_COLOR));
        return new Color(0x3333FF);
    }

    @Override
    public void setEffectColor(Color effectColor) {
        getBladeState().method_10569(SUMMONED_SWORD_COLOR, effectColor.getRGB());
    }

    @Override
    public boolean isEffectColorInverse() {
        return getBladeState().method_10577(SUMMONED_SWORD_COLOR_INVERSE);
    }

    @Override
    public void setEffectColorInverse(boolean effectColorInverse) {
        getBladeState().method_10556(SUMMONED_SWORD_COLOR_INVERSE, effectColorInverse);
    }

    @Override
    public @NotNull class_243 getAdjust() {
        if (getBladeState().method_10545(ADJUST_XYZ))
            return NBTHelper.getVector3d(getOrCreateRootTag(), ADJUST_XYZ);
        return class_243.field_1353;
    }

    @Override
    public void setAdjust(class_243 adjust) {
        getBladeState().method_10566(ADJUST_XYZ, NBTHelper.newDoubleNBTList(adjust));
    }

    @Override
    public @NotNull Optional<class_2960> getTexture() {
        class_2960 location = class_2960.method_12829(getBladeState().method_10558(TEXTURE_NAME));
        if (location != null && location.method_12832().isEmpty())
            return Optional.empty();
        return Optional.ofNullable(location);
    }

    @Override
    public void setTexture(class_2960 texture) {
        if (texture != null) {
            getBladeState().method_10582(TEXTURE_NAME, texture.toString());
        }
    }

    @Override
    public @NotNull Optional<class_2960> getModel() {
        class_2960 location = class_2960.method_12829(getBladeState().method_10558(MODEL_NAME));
        if (location != null && location.method_12832().isEmpty())
            return Optional.empty();
        return Optional.ofNullable(location);
    }

    @Override
    public void setModel(class_2960 model) {
        if (model != null) {
            getBladeState().method_10582(MODEL_NAME, model.toString());
        }
    }

    @Override
    public int getTargetEntityId() {
        return getBladeState().method_10550(TARGET_ENTITY);
    }

    @Override
    public void setTargetEntityId(int id) {
        getBladeState().method_10569(TARGET_ENTITY, id);
    }

    @Override
    public class_2960 getComboRoot() {
        if (getBladeState().method_10558(COMBO_ROOT).isEmpty())
            return ComboStateRegistry.getId((ComboStateRegistry.STANDBY));
        class_2960 location = class_2960.method_12829(getBladeState().method_10558(COMBO_ROOT));
        return location != null && ComboStateRegistry.COMBO_STATE.method_10250(location) ? location : ComboStateRegistry.getId((ComboStateRegistry.STANDBY));
    }

    @Override
    public void setComboRoot(class_2960 rootLoc) {
        if (ComboStateRegistry.COMBO_STATE.method_10250(rootLoc)) {
            getBladeState().method_10582(COMBO_ROOT, rootLoc.toString());
        } else {
            class_2960 id = ComboStateRegistry.getId(ComboStateRegistry.STANDBY);
            getBladeState().method_10582(COMBO_ROOT, id.toString());
        }
    }

    @Override
    public int getMaxDamage() {
        return getBladeState().method_10550(MAX_DAMAGE);
    }

    @Override
    public void setMaxDamage(int damage) {
        getBladeState().method_10569(MAX_DAMAGE, damage);
    }

    @Override
    public int getDamage() {
        return getBladeState().method_10550(DAMAGE);
    }

    @Override
    public void setDamage(int damage) {
        int count = Math.max(0, damage);
        getBladeState().method_10569(DAMAGE, count);
    }

    @Override
    public int getProudSoulCount() {
        return getBladeState().method_10550(PROUD_SOUL);
    }

    @Override
    public void setProudSoulCount(int psCount) {
        int count = Math.max(0, psCount);
        getBladeState().method_10569(PROUD_SOUL, count);
    }

    @Override
    public List<class_2960> getSpecialEffects() {
        List<class_2960> result = new ArrayList<>();
        getBladeState().method_10554(SPECIAL_EFFECTS, class_2520.field_33258).forEach(tag -> {
            class_2960 se = class_2960.method_12829(tag.method_10714());
            if (se != null && SpecialEffectsRegistry.SPECIAL_EFFECT.method_10250(se))
                result.add(se);
        });
        return result;
    }

    @Override
    public void setSpecialEffects(class_2499 list) {
        getBladeState().method_10566(SPECIAL_EFFECTS, list);
    }

    @Override
    public boolean addSpecialEffect(class_2960 se) {
        if (SpecialEffectsRegistry.SPECIAL_EFFECT.method_10250(se)) {
            if (!getBladeState().method_10545(SPECIAL_EFFECTS))
                getBladeState().method_10566(SPECIAL_EFFECTS, new class_2499());
            return getBladeState().method_10554(SPECIAL_EFFECTS, class_2520.field_33258).add(class_2519.method_23256(se.toString()));
        }
        return false;
    }

    @Override
    public boolean removeSpecialEffect(class_2960 se) {
        return getBladeState().method_10554(SPECIAL_EFFECTS, class_2520.field_33258).remove(class_2519.method_23256(se.toString()));
    }

    @Override
    public boolean hasSpecialEffect(class_2960 se) {
        if (SpecialEffectsRegistry.SPECIAL_EFFECT.method_10250(se)) {
            return getBladeState().method_10554(SPECIAL_EFFECTS, class_2520.field_33258).contains(class_2519.method_23256(se.toString()));
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return getBladeState().method_10577(IS_EMPTY);
    }

    @Override
    public void setNonEmpty() {
        getBladeState().method_10556(IS_EMPTY, false);
    }
}
