package mods.flammpfeil.slashblade.client;

import cn.sh1rocu.slashblade.mixin.accessor.LivingEntityRendererAccessor;
import mods.flammpfeil.slashblade.client.renderer.LockonCircleRender;
import mods.flammpfeil.slashblade.client.renderer.gui.RankRenderer;
import mods.flammpfeil.slashblade.client.renderer.layers.LayerMainBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModel;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.compat.playerAnim.PlayerAnimationOverrider;
import mods.flammpfeil.slashblade.event.client.AdvancementsRecipeRenderer;
import mods.flammpfeil.slashblade.event.client.SneakingMotionCanceller;
import mods.flammpfeil.slashblade.event.client.UserPoseOverrider;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.apache.logging.log4j.util.LoaderUtil;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Environment(EnvType.CLIENT)
public class ClientHandler {
    public static void doClientStuff() {
        SneakingMotionCanceller.getInstance().register();

        if (LoaderUtil.isClassAvailable("dev.kosmx.playerAnim.api.layered.AnimationStack")) {
            PlayerAnimationOverrider.getInstance().register();
        } else {
            UserPoseOverrider.getInstance().register();
        }
        LockonCircleRender.getInstance().register();
        AdvancementsRecipeRenderer.getInstance().register();


        RankRenderer.getInstance().register();

        class_5272.method_27879(SBItems.slashblade, new class_2960("slashblade:user"),
                (itemStack, level, livingEntity, i) -> {
                    BladeModel.user = livingEntity;
                    return 0;
                });

        class_5272.method_27879(SBItems.slashblade_bamboo, new class_2960("slashblade:user"),
                (itemStack, level, livingEntity, i) -> {
                    BladeModel.user = livingEntity;
                    return 0;
                });

        class_5272.method_27879(SBItems.slashblade_silverbamboo, new class_2960("slashblade:user"),
                (itemStack, level, livingEntity, i) -> {
                    BladeModel.user = livingEntity;
                    return 0;
                });

        class_5272.method_27879(SBItems.slashblade_white, new class_2960("slashblade:user"),
                (itemStack, level, livingEntity, i) -> {
                    BladeModel.user = livingEntity;
                    return 0;
                });

        class_5272.method_27879(SBItems.slashblade_wood, new class_2960("slashblade:user"),
                (itemStack, level, livingEntity, i) -> {
                    BladeModel.user = livingEntity;
                    return 0;
                });


        registerKeyMapping();
    }

    public static void onCreativeTagBuilding(class_1761 group, FabricItemGroupEntries entries) {
        BladeModelManager.getClientSlashBladeRegistry().method_40270()
                .sorted(SlashBladeDefinition.COMPARATOR).forEach(entry -> {
                    if (!Objects.equals(class_7923.field_44687.method_10221(group), entry.comp_349().getCreativeGroup()))
                        return;

                    if (!entry.comp_349().getBlade().method_7960())
                        entries.method_45420(entry.comp_349().getBlade());
                });
    }

    public static void registerKeyMapping() {
        KeyBindingHelper.registerKeyBinding(SlashBladeKeyMappings.KEY_SPECIAL_MOVE);
        KeyBindingHelper.registerKeyBinding(SlashBladeKeyMappings.KEY_SUMMON_BLADE);
    }

    private static final Set<class_1792> blades = new HashSet<>() {{
        add(SBItems.slashblade);
        add(SBItems.slashblade_white);
        add(SBItems.slashblade_wood);
        add(SBItems.slashblade_silverbamboo);
        add(SBItems.slashblade_bamboo);
    }};

    public static class_1087 Baked(class_1087 bakedModel, ModelModifier.AfterBake.Context context) {
        for (class_1792 blade : blades) {
            class_1091 modelLoc = new class_1091(class_7923.field_41178.method_10221(blade), "inventory");
            if (context.id() instanceof class_1091 contextModelId && contextModelId.equals(modelLoc)) {
                return bakeBlade(bakedModel, context.loader());
            }
        }
        return bakedModel;
    }

    public static class_1087 bakeBlade(class_1087 bakedModel, class_1088 bakery) {
        return new BladeModel(bakedModel, bakery);
    }

    public static void addLayers(Map<class_1299<?>, class_897<?>> renderers, Map<String, class_897<? extends class_1657>> skinMap) {
        addPlayerLayer(skinMap, "default");
        addPlayerLayer(skinMap, "slim");

        for (class_1299<?> type : class_7923.field_41177) {
            addEntityLayer(renderers, type);
        }

//        addEntityLayer(renderers, EntityType.ZOMBIE);
//        addEntityLayer(renderers, EntityType.HUSK);
//        addEntityLayer(renderers, EntityType.ZOMBIE_VILLAGER);
//
//        addEntityLayer(renderers, EntityType.WITHER_SKELETON);
//        addEntityLayer(renderers, EntityType.SKELETON);
//        addEntityLayer(renderers, EntityType.STRAY);
//
//        addEntityLayer(renderers, EntityType.PIGLIN);
//        addEntityLayer(renderers, EntityType.PIGLIN_BRUTE);
//        addEntityLayer(renderers, EntityType.ZOMBIFIED_PIGLIN);
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    public static void addPlayerLayer(Map<String, class_897<? extends class_1657>> skinMap, String skin) {
        class_897<? extends class_1657> renderer = skinMap.get(skin);

        if (renderer instanceof class_922 livingRenderer) {
            ((LivingEntityRendererAccessor) livingRenderer).sb$addLayer(new LayerMainBlade<>(livingRenderer));
        }
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    private static void addEntityLayer(Map<class_1299<?>, class_897<?>> renderers, class_1299 type) {
        class_897<?> renderer = renderers.get(type);

        if (renderer instanceof class_922 livingRenderer) {
            ((LivingEntityRendererAccessor) livingRenderer).sb$addLayer(new LayerMainBlade<>(livingRenderer));
        }
    }
}
