package mods.flammpfeil.slashblade.client.renderer.entity;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import javax.annotation.Nullable;

@Environment(EnvType.CLIENT)
public class DriveRenderer<T extends EntityDrive> extends class_897<T> {

    private static final class_2960 TEXTURE = SlashBlade.prefix("model/util/ss.png");
    private static final class_2960 MODEL = SlashBlade.prefix("model/util/drive.obj");

    @Nullable
    @Override
    public class_2960 getTextureLocation(T entity) {
        return entity.getTextureLoc();
    }

    public DriveRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 bufferIn,
                       int packedLightIn) {

        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack)) {
            float lifetime = entity.getLifetime();
            double deathTime = lifetime;
            double baseAlpha = (Math.min(deathTime, Math.max(0, (lifetime - (entity.field_6012))))
                    / deathTime);
            baseAlpha = Math.max(0, -Math.pow(baseAlpha - 1, 4.0) + 0.75);

            matrixStack.method_22907(
                    class_7833.field_40716.rotationDegrees(class_3532.method_17821(partialTicks, entity.field_5982, entity.method_36454()) - 90.0F));
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_17821(partialTicks, entity.field_6004, entity.method_36455())));
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(entity.getRotationRoll()));

            float scale = 0.015f;
            matrixStack.method_22905(scale, scale, scale);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0F));
            int color = entity.getColor() & 0xFFFFFF;
            int alpha = ((0xFF & (int) (0xFF * baseAlpha)) << 24);
            WavefrontObject model = BladeModelManager.getInstance().getModel(MODEL);

            BladeRenderState.setCol(color | alpha);
            BladeRenderState.renderOverridedLuminous(class_1799.field_8037, model, "base", TEXTURE, matrixStack, bufferIn,
                    packedLightIn);
        }
    }
}
