package mods.flammpfeil.slashblade.event.handler;

import cn.sh1rocu.slashblade.api.event.LivingKnockBackEvent;
import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_5134;

public class KnockBackHandler {

    static final String NBT_KEY = "knockback_factor";

    public static void setCancel(class_1309 target) {
        setFactor(target, 0, 0, 0);
    }

    public static void setSmash(class_1309 target, double horizontalFactor) {
        setFactor(target, horizontalFactor, 0, 0);
    }

    public static void setVertical(class_1309 target, double verticalFactor) {
        setFactor(target, 0, verticalFactor, -verticalFactor);
    }

    public static void setFactor(class_1309 target, double horizontalFactor, double verticalFactor,
                                 double addFallDistance) {
        NBTHelper.putVector3d(((EntityExtension) target).sb$getPersistentData(), NBT_KEY,
                new class_243(horizontalFactor, verticalFactor, addFallDistance));
    }

    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        class_1309 target = event.getEntity();

        class_2487 nbt = ((EntityExtension) target).sb$getPersistentData();

        if (!nbt.method_10545(NBT_KEY))
            return;

        class_243 factor = NBTHelper.getVector3d(nbt, NBT_KEY);
        nbt.method_10551(NBT_KEY);

        if (target.field_6017 < 0)
            target.field_6017 = 0;

        // z = falldistance factor
        target.field_6017 += factor.field_1350;

        // movement factor is resistable
        if ((target.method_6051().method_43058() < target.method_5996(class_5134.field_23718).method_6194()))
            return;

        target.field_6007 = true;

        class_243 motion = target.method_18798();

        // x = strength multiplier
        if (factor.field_1352 == 0) {
            event.setCanceled(true);

            motion = motion.method_18805(0, 1, 0);
        } else
            event.setStrength((float) (event.getStrength() * factor.field_1352));

        // y = vertical factor

        if (0 < factor.field_1351) {
            target.method_24830(false);
            event.getEntity().method_18800(motion.field_1352, Math.max(motion.field_1351, factor.field_1351), motion.field_1350);
        } else if (factor.field_1351 < 0) {
            event.getEntity().method_18800(motion.field_1352, Math.min(motion.field_1351, factor.field_1351), motion.field_1350);
        }
    }
}
