package mods.flammpfeil.slashblade.item;

import com.mojang.serialization.Codec;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import net.minecraft.class_1799;
import java.util.EnumSet;

public enum SwordType {
    NONE, EDGEFRAGMENT, BROKEN, ENCHANTED, BEWITCHED, FIERCEREDGE, NOSCABBARD, SEALED,
    ;

    public static final Codec<SwordType> CODEC = Codec.STRING.xmap(string -> SwordType.valueOf(string.toUpperCase()),
            instance -> instance.name().toLowerCase());

    public static EnumSet<SwordType> from(class_1799 itemStackIn) {
        EnumSet<SwordType> types = EnumSet.noneOf(SwordType.class);

        CapabilitySlashBlade.BLADESTATE.maybeGet(itemStackIn).ifPresentOrElse(s -> {
            if (s.isBroken())
                types.add(BROKEN);

            if (s.isSealed())
                types.add(SEALED);

            if (!s.isSealed() && itemStackIn.method_7942()
                    && (itemStackIn.method_7938() || s.isDefaultBewitched()))
                types.add(BEWITCHED);

            if (s.getKillCount() >= 1000)
                types.add(FIERCEREDGE);

        }, () -> {
            types.add(NOSCABBARD);
            types.add(EDGEFRAGMENT);
        });

        if (itemStackIn.method_7942())
            types.add(ENCHANTED);

        if (itemStackIn.method_7909() instanceof ItemSlashBladeDetune) {
            types.remove(SwordType.ENCHANTED);
            types.remove(SwordType.BEWITCHED);
        }

        return types;
    }
}
