package mods.flammpfeil.slashblade.network;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.event.BladeMotionEvent;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.class_742;
import java.util.Collection;
import java.util.UUID;

public class MotionBroadcastMessage {
    public static final class_2960 ID = SlashBlade.prefix("s2c_motion_broadcast");

    public static void send(UUID playerId, String combo, Collection<class_3222> players) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(playerId);
        buf.method_10814(combo);
        players.forEach(player -> ServerPlayNetworking.send(player, ID, buf));
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID playerId = buf.method_10790();
        String combo = buf.method_19772();
        client.execute(() -> setPoint(playerId, combo));
    }

    @Environment(EnvType.CLIENT)
    public static void setPoint(UUID playerId, String combo) {
        class_1657 target = class_310.method_1551().field_1687.method_18470(playerId);

        if (target == null)
            return;
        if (!(target instanceof class_742))
            return;

        class_2960 state = class_2960.method_12829(combo);
        if (state == null || !ComboStateRegistry.COMBO_STATE.method_10250(state))
            return;

        BladeMotionEvent.CALLBACK.invoker().onBladeMotion(new BladeMotionEvent(target, state));
    }
}