package mods.flammpfeil.slashblade.registry.slashblade;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeCreativeGroup;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeRegistryEvent;
import mods.flammpfeil.slashblade.init.SBItems;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880.class_6883;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.Comparator;
import java.util.List;

public class SlashBladeDefinition {

    public static final Codec<SlashBladeDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                    class_2960.field_25139.optionalFieldOf("item", SlashBlade.prefix("slashblade"))
                            .forGetter(SlashBladeDefinition::getItemName),
                    class_2960.field_25139.fieldOf("name").forGetter(SlashBladeDefinition::getName),
                    RenderDefinition.CODEC.fieldOf("render").forGetter(SlashBladeDefinition::getRenderDefinition),
                    PropertiesDefinition.CODEC.fieldOf("properties").forGetter(SlashBladeDefinition::getStateDefinition),
                    EnchantmentDefinition.CODEC.listOf().optionalFieldOf("enchantments", Lists.newArrayList())
                            .forGetter(SlashBladeDefinition::getEnchantments),
                    class_2960.field_25139.optionalFieldOf("creativeGroup", class_7923.field_44687.method_10221(SlashBladeCreativeGroup.SLASHBLADE_GROUP))
                            .forGetter(SlashBladeDefinition::getCreativeGroup))
            .apply(instance, SlashBladeDefinition::new));

    public static final class_5321<class_2378<SlashBladeDefinition>> REGISTRY_KEY = class_5321
            .method_29180(SlashBlade.prefix("named_blades"));

    private final class_2960 item;
    private final class_2960 name;
    private final RenderDefinition renderDefinition;
    private final PropertiesDefinition stateDefinition;
    private final List<EnchantmentDefinition> enchantments;

    private final class_2960 creativeGroup;

    public SlashBladeDefinition(class_2960 name, RenderDefinition renderDefinition,
                                PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments) {
        this(SlashBlade.prefix("slashblade"), name, renderDefinition, stateDefinition, enchantments,
                class_7923.field_44687.method_10221(SlashBladeCreativeGroup.SLASHBLADE_GROUP));
    }

    public SlashBladeDefinition(class_2960 name, RenderDefinition renderDefinition,
                                PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments,
                                class_2960 creativeGroup) {
        this(SlashBlade.prefix("slashblade"), name, renderDefinition, stateDefinition, enchantments, creativeGroup);
    }

    public SlashBladeDefinition(class_2960 item, class_2960 name, RenderDefinition renderDefinition,
                                PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments) {
        this(item, name, renderDefinition, stateDefinition, enchantments,
                class_7923.field_44687.method_10221(SlashBladeCreativeGroup.SLASHBLADE_GROUP));
    }

    public SlashBladeDefinition(class_2960 item, class_2960 name, RenderDefinition renderDefinition,
                                PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments,
                                class_2960 creativeGroup) {
        this.item = item;
        this.name = name;
        this.renderDefinition = renderDefinition;
        this.stateDefinition = stateDefinition;
        this.enchantments = enchantments;
        this.creativeGroup = creativeGroup;
    }

    public class_2960 getItemName() {
        return item;
    }

    public class_2960 getName() {
        return name;
    }

    public String getTranslationKey() {
        return class_156.method_646("item", this.getName());
    }

    public RenderDefinition getRenderDefinition() {
        return renderDefinition;
    }

    public PropertiesDefinition getStateDefinition() {
        return stateDefinition;
    }

    public List<EnchantmentDefinition> getEnchantments() {
        return enchantments;
    }

    public class_1799 getBlade() {
        return getBlade(getItem());
    }

    public class_1799 getBlade(class_1792 bladeItem) {
        SlashBladeRegistryEvent.Pre event = new SlashBladeRegistryEvent.Pre(this);
        SlashBladeRegistryEvent.PRE.invoker().onPre(event);
        if (event.isCanceled())
            return class_1799.field_8037;

        class_1799 result = new class_1799(bladeItem);
        var state = CapabilitySlashBlade.BLADESTATE.maybeGet(result).orElse(new SlashBladeState(result));
        state.setNonEmpty();
        state.setBaseAttackModifier(this.stateDefinition.getBaseAttackModifier());
        state.setMaxDamage(this.stateDefinition.getMaxDamage());
        state.setComboRoot(this.stateDefinition.getComboRoot());
        state.setSlashArtsKey(this.stateDefinition.getSpecialAttackType());

        this.stateDefinition.getSpecialEffects().forEach(state::addSpecialEffect);

        this.stateDefinition.getDefaultType().forEach(type -> {
            switch (type) {
                case BEWITCHED -> state.setDefaultBewitched(true);
                case BROKEN -> {
                    result.method_7974(result.method_7936() - 1);
                    state.setBroken(true);
                }
                case SEALED -> state.setSealed(true);
                default -> {
                }
            }
        });

        state.setModel(this.renderDefinition.getModelName());
        state.setTexture(this.renderDefinition.getTextureName());
        state.setColorCode(this.renderDefinition.getSummonedSwordColor());
        state.setEffectColorInverse(this.renderDefinition.isSummonedSwordColorInverse());
        state.setCarryType(this.renderDefinition.getStandbyRenderType());
        if (!this.getName().equals(SlashBlade.prefix("none")))
            state.setTranslationKey(this.getTranslationKey());

        for (var instance : this.enchantments) {
            var enchantment = class_7923.field_41176.method_10223(instance.getEnchantmentID());
            result.method_7978(enchantment, instance.getEnchantmentLevel());

        }
        var postRegistry = new SlashBladeRegistryEvent.Post(this, result);
        SlashBladeRegistryEvent.POST.invoker().onPost(postRegistry);
        return postRegistry.getBlade();
    }

    public class_1792 getItem() {
        @Nullable
        class_1792 value = class_7923.field_41178.method_10223(this.item);
        if (value == null)
            return SBItems.slashblade;
        return value;
    }

    public class_2960 getCreativeGroup() {
        return creativeGroup;
    }

    public static final BladeComparator COMPARATOR = new BladeComparator();

    private static class BladeComparator implements Comparator<class_6883<SlashBladeDefinition>> {
        @Override
        public int compare(class_6883<SlashBladeDefinition> left, class_6883<SlashBladeDefinition> right) {

            class_2960 leftKey = left.method_40237().method_29177();
            class_2960 rightKey = right.method_40237().method_29177();
            boolean checkSame = leftKey.method_12836().equalsIgnoreCase(rightKey.method_12836());
            if (!checkSame) {
                if (leftKey.method_12836().equalsIgnoreCase(SlashBlade.MODID))
                    return -1;

                if (rightKey.method_12836().equalsIgnoreCase(SlashBlade.MODID))
                    return 1;
            }
            String leftName = leftKey.toString();
            String rightName = rightKey.toString();

            return leftName.compareToIgnoreCase(rightName);
        }
    }
}
