/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import cn.sh1rocu.slashblade.api.event.LivingKnockBackEvent;
import cn.sh1rocu.slashblade.util.ItemPredicateRegistry;
import com.google.common.base.CaseFormat;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.SlashBladeCreativeGroup;
import mods.flammpfeil.slashblade.ability.EnemyStep;
import mods.flammpfeil.slashblade.ability.Guard;
import mods.flammpfeil.slashblade.ability.KickJump;
import mods.flammpfeil.slashblade.ability.LockOnManager;
import mods.flammpfeil.slashblade.ability.SlayerStyleArts;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.ability.SummonedSwordArts;
import mods.flammpfeil.slashblade.ability.SuperSlashArts;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.advancement.SlashBladeItemPredicate;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntityBlisteringSwords;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.entity.EntityHeavyRainSwords;
import mods.flammpfeil.slashblade.entity.EntityJudgementCut;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.EntitySpiralSwords;
import mods.flammpfeil.slashblade.entity.EntityStormSwords;
import mods.flammpfeil.slashblade.event.BladeMotionEventBroadcaster;
import mods.flammpfeil.slashblade.event.handler.AllowFlightOverrwrite;
import mods.flammpfeil.slashblade.event.handler.FallHandler;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.event.handler.KillCounter;
import mods.flammpfeil.slashblade.event.handler.KnockBackHandler;
import mods.flammpfeil.slashblade.event.handler.RankPointHandler;
import mods.flammpfeil.slashblade.event.handler.RefineHandler;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.init.SBStatTypes;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.recipe.RecipeSerializerRegistry;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.ModAttributes;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboCommands;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlashBlade {
    public static final String MODID = "slashblade";
    public static final Logger LOGGER = LogManager.getLogger();

    public static class_2960 prefix(String path) {
        return new class_2960(MODID, path);
    }

    public static void init() {
        ForgeConfigRegistry.INSTANCE.register(MODID, ModConfig.Type.COMMON, (IConfigSpec)SlashBladeConfig.COMMON_CONFIG);
        SBItems.init();
        SBEntityTypes.init();
        SBStatTypes.init();
        SlashBlade.setup();
        ModAttributes.init();
        NetworkManager.registerC2SPackets();
        ComboStateRegistry.init();
        SlashArtsRegistry.init();
        SlashBladeCreativeGroup.init();
        RecipeSerializerRegistry.init();
        SpecialEffectsRegistry.init();
        ItemPredicateRegistry.register(SlashBlade.prefix(MODID), SlashBladeItemPredicate::new);
    }

    private static void setup() {
        LivingKnockBackEvent.CALLBACK.register(KnockBackHandler::onLivingKnockBack);
        FallHandler.getInstance().register();
        LockOnManager.getInstance().register();
        Guard.getInstance().register();
        StunManager.init();
        RefineHandler.getInstance().register();
        KillCounter.getInstance().register();
        RankPointHandler.getInstance().register();
        AllowFlightOverrwrite.getInstance().register();
        BladeMotionEventBroadcaster.getInstance().register();
        InputCommandEvent.CALLBACK.register(TargetSelector::onInputChange);
        SummonedSwordArts.getInstance().register();
        SlayerStyleArts.getInstance().register();
        Untouchable.getInstance().register();
        EnemyStep.getInstance().register();
        KickJump.getInstance().register();
        SuperSlashArts.getInstance().register();
        ComboCommands.initDefaultStandByCommands();
    }

    public static class_2378<SlashBladeDefinition> getSlashBladeDefinitionRegistry(class_1937 level) {
        if (level.method_8608()) {
            return BladeModelManager.getClientSlashBladeRegistry();
        }
        return level.method_30349().method_30530(SlashBladeDefinition.REGISTRY_KEY);
    }

    public static class_7225.class_7226<SlashBladeDefinition> getSlashBladeDefinitionRegistry(class_7225.class_7874 access) {
        return access.method_46762(SlashBladeDefinition.REGISTRY_KEY);
    }

    public static class RegistryEvents {
        public static final class_2960 BladeItemEntityLoc = new class_2960("slashblade", RegistryEvents.classToString(BladeItemEntity.class));
        public static class_1299<BladeItemEntity> BladeItem;
        public static final class_2960 BladeStandEntityLoc;
        public static class_1299<BladeStandEntity> BladeStand;
        public static final class_2960 SummonedSwordLoc;
        public static final class_2960 SpiralSwordsLoc;
        public static class_1299<EntitySpiralSwords> SpiralSwords;
        public static final class_2960 StormSwordsLoc;
        public static class_1299<EntityStormSwords> StormSwords;
        public static final class_2960 BlisteringSwordsLoc;
        public static class_1299<EntityBlisteringSwords> BlisteringSwords;
        public static final class_2960 HeavyRainSwordsLoc;
        public static class_1299<EntityHeavyRainSwords> HeavyRainSwords;
        public static final class_2960 JudgementCutLoc;
        public static class_1299<EntityJudgementCut> JudgementCut;
        public static final class_2960 SlashEffectLoc;
        public static class_1299<EntitySlashEffect> SlashEffect;
        public static final class_2960 DriveLoc;
        public static class_1299<EntityDrive> Drive;

        private static String classToString(Class<? extends class_1297> entityClass) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", "");
        }

        static {
            BladeStandEntityLoc = new class_2960(SlashBlade.MODID, RegistryEvents.classToString(BladeStandEntity.class));
            SummonedSwordLoc = new class_2960(SlashBlade.MODID, RegistryEvents.classToString(EntityAbstractSummonedSword.class));
            SpiralSwordsLoc = new class_2960(SlashBlade.MODID, RegistryEvents.classToString(EntitySpiralSwords.class));
            StormSwordsLoc = new class_2960(SlashBlade.MODID, RegistryEvents.classToString(EntityStormSwords.class));
            BlisteringSwordsLoc = new class_2960(SlashBlade.MODID, RegistryEvents.classToString(EntityBlisteringSwords.class));
            HeavyRainSwordsLoc = new class_2960(SlashBlade.MODID, RegistryEvents.classToString(EntityHeavyRainSwords.class));
            JudgementCutLoc = new class_2960(SlashBlade.MODID, RegistryEvents.classToString(EntityJudgementCut.class));
            SlashEffectLoc = new class_2960(SlashBlade.MODID, RegistryEvents.classToString(EntitySlashEffect.class));
            DriveLoc = new class_2960(SlashBlade.MODID, RegistryEvents.classToString(EntityDrive.class));
        }
    }
}

