/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import dev.onyxstudios.cca.api.v3.component.Component;
import java.awt.Color;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.event.BladeMotionEvent;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public interface ISlashBladeState
extends Component {
    public static final String LAST_ACTION_TIME = "lastActionTime";
    public static final String TARGET_ENTITY = "TargetEntity";
    public static final String ON_CLICK = "_onClick";
    public static final String FALL_DECREASE_RATE = "fallDecreaseRate";
    public static final String ATTACK_AMPLIFIER = "AttackAmplifier";
    public static final String CURRENT_COMBO = "currentCombo";
    public static final String DAMAGE = "Damage";
    public static final String MAX_DAMAGE = "maxDamage";
    public static final String PROUD_SOUL = "proudSoul";
    public static final String IS_BROKEN = "isBroken";
    public static final String IS_SEALED = "isSealed";
    public static final String BASE_ATTACK_MODIFIER = "baseAttackModifier";
    public static final String KILL_COUNT = "killCount";
    public static final String REPAIR_COUNTER = "RepairCounter";
    public static final String SPECIAL_ATTACK_TYPE = "SpecialAttackType";
    public static final String IS_DEFAULT_BEWITCHED = "isDefaultBewitched";
    public static final String TRANSLATION_KEY = "translationKey";
    public static final String STANDBY_RENDER_TYPE = "StandbyRenderType";
    public static final String SUMMONED_SWORD_COLOR = "SummonedSwordColor";
    public static final String SUMMONED_SWORD_COLOR_INVERSE = "SummonedSwordColorInverse";
    public static final String ADJUST_XYZ = "adjustXYZ";
    public static final String TEXTURE_NAME = "TextureName";
    public static final String MODEL_NAME = "ModelName";
    public static final String COMBO_ROOT = "ComboRoot";
    public static final String SPECIAL_EFFECTS = "SpecialEffects";

    public long getLastActionTime();

    public void setLastActionTime(long var1);

    default public long getElapsedTime(class_1309 user) {
        long ticks = Math.max(0L, user.method_37908().method_8510() - this.getLastActionTime());
        if (user.method_37908().method_8608()) {
            ticks = Math.max(0L, ticks + 1L);
        }
        return ticks;
    }

    public boolean onClick();

    public void setOnClick(boolean var1);

    public float getFallDecreaseRate();

    public void setFallDecreaseRate(float var1);

    public float getAttackAmplifier();

    public void setAttackAmplifier(float var1);

    @Nonnull
    public class_2960 getComboSeq();

    public void setComboSeq(class_2960 var1);

    public boolean isBroken();

    public void setBroken(boolean var1);

    public boolean isSealed();

    public void setSealed(boolean var1);

    public float getBaseAttackModifier();

    public void setBaseAttackModifier(float var1);

    public int getProudSoulCount();

    public void setProudSoulCount(int var1);

    public int getKillCount();

    public void setKillCount(int var1);

    public int getRefine();

    public void setRefine(int var1);

    @Nonnull
    default public SlashArts getSlashArts() {
        class_2960 key = this.getSlashArtsKey();
        SlashArts result = null;
        if (key != null) {
            SlashArts slashArts = result = SlashArtsRegistry.SLASH_ARTS.method_10250(key) ? (SlashArts)SlashArtsRegistry.SLASH_ARTS.method_10223(key) : SlashArtsRegistry.JUDGEMENT_CUT;
        }
        if (key == SlashArtsRegistry.SLASH_ARTS.method_10221((Object)SlashArtsRegistry.NONE)) {
            result = null;
        }
        return result != null ? result : SlashArtsRegistry.JUDGEMENT_CUT;
    }

    public void setSlashArtsKey(class_2960 var1);

    public class_2960 getSlashArtsKey();

    public boolean isDefaultBewitched();

    public void setDefaultBewitched(boolean var1);

    @NotNull
    public String getTranslationKey();

    public void setTranslationKey(String var1);

    @NotNull
    public CarryType getCarryType();

    public void setCarryType(CarryType var1);

    @NotNull
    public Color getEffectColor();

    public void setEffectColor(Color var1);

    public boolean isEffectColorInverse();

    public void setEffectColorInverse(boolean var1);

    default public void setColorCode(int colorCode) {
        this.setEffectColor(new Color(colorCode));
    }

    default public int getColorCode() {
        return this.getEffectColor().getRGB();
    }

    @NotNull
    public class_243 getAdjust();

    public void setAdjust(class_243 var1);

    @NotNull
    public Optional<class_2960> getTexture();

    public void setTexture(class_2960 var1);

    @NotNull
    public Optional<class_2960> getModel();

    public void setModel(class_2960 var1);

    public int getTargetEntityId();

    public void setTargetEntityId(int var1);

    @Nullable
    default public class_1297 getTargetEntity(class_1937 world) {
        int id = this.getTargetEntityId();
        if (id < 0) {
            return null;
        }
        return world.method_8469(id);
    }

    default public void setTargetEntityId(class_1297 target) {
        if (target != null) {
            this.setTargetEntityId(target.method_5628());
        } else {
            this.setTargetEntityId(-1);
        }
    }

    default public int getFullChargeTicks(class_1309 user) {
        return 9;
    }

    default public boolean isCharged(class_1309 user) {
        if (!SwordType.from(user.method_6047()).contains((Object)SwordType.ENCHANTED)) {
            return false;
        }
        if (this.isBroken() || this.isSealed()) {
            return false;
        }
        int elapsed = user.method_6048();
        return this.getFullChargeTicks(user) < elapsed;
    }

    default public class_2960 progressCombo(class_1309 user, boolean isVirtual) {
        class_2960 resolved;
        class_2960 currentloc = this.resolvCurrentComboState(user);
        ComboState current = (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(currentloc);
        if (current == null) {
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        }
        class_2960 next = current.getNext(user);
        if (!next.equals((Object)ComboStateRegistry.getId(ComboStateRegistry.NONE)) && next.equals((Object)currentloc)) {
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        }
        class_2960 rootNext = ((ComboState)ComboStateRegistry.COMBO_STATE.method_10223(this.getComboRoot())).getNext(user);
        ComboState nextCS = (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(next);
        ComboState rootNextCS = (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(rootNext);
        class_2960 class_29602 = resolved = nextCS.getPriority() <= rootNextCS.getPriority() ? next : rootNext;
        if (!isVirtual) {
            this.updateComboSeq(user, resolved);
        }
        return resolved;
    }

    default public class_2960 progressCombo(class_1309 user) {
        return this.progressCombo(user, false);
    }

    default public class_2960 doChargeAction(class_1309 user, int elapsed) {
        SlashArts.ArtsType result;
        if (elapsed <= 2) {
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        }
        if (this.isBroken() || this.isSealed()) {
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        }
        Map.Entry<Integer, class_2960> currentloc = this.resolvCurrentComboStateTicks(user);
        ComboState current = (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(currentloc.getValue());
        if (current == null) {
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        }
        if (currentloc.getValue() != ComboStateRegistry.getId(ComboStateRegistry.NONE) && current.getNext(user) == currentloc.getValue()) {
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        }
        int fullChargeTicks = this.getFullChargeTicks(user);
        int justReceptionSpan = SlashArts.getJustReceptionSpan(user);
        int justChargePeriod = fullChargeTicks + justReceptionSpan;
        ImmutableRangeMap charge_accept = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Integer.valueOf(fullChargeTicks)), (Object)SlashArts.ArtsType.Fail).put(Range.closedOpen((Comparable)Integer.valueOf(fullChargeTicks), (Comparable)Integer.valueOf(justChargePeriod)), (Object)SlashArts.ArtsType.Jackpot).put(Range.atLeast((Comparable)Integer.valueOf(justChargePeriod)), (Object)SlashArts.ArtsType.Success).build();
        SlashArts.ArtsType type = (SlashArts.ArtsType)((Object)charge_accept.get((Comparable)Integer.valueOf(elapsed)));
        if (type != SlashArts.ArtsType.Jackpot && (result = current.releaseAction(user, currentloc.getKey())) != SlashArts.ArtsType.Fail) {
            type = result;
        }
        class_2960 csloc = this.getSlashArts().doArts(type, user);
        SlashBladeEvent.ChargeActionEvent event = new SlashBladeEvent.ChargeActionEvent(user, elapsed, this, csloc, type);
        ((SlashBladeEvent.ChargeAction)SlashBladeEvent.CHARGE_ACTION.invoker()).onChargeAction(event);
        if (event.isCanceled()) {
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        }
        csloc = event.getComboState();
        ComboState cs = (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(csloc);
        if (csloc != ComboStateRegistry.getId(ComboStateRegistry.NONE) && !currentloc.getValue().equals((Object)csloc) && current.getPriority() > cs.getPriority()) {
            if (type == SlashArts.ArtsType.Jackpot) {
                AdvancementHelper.grantedIf(class_1893.field_23071, user);
            }
            this.updateComboSeq(user, csloc);
        }
        return csloc;
    }

    default public void updateComboSeq(class_1309 entity, class_2960 loc) {
        ((BladeMotionEvent.Callback)BladeMotionEvent.CALLBACK.invoker()).onBladeMotion(new BladeMotionEvent(entity, loc));
        this.setComboSeq(loc);
        this.setLastActionTime(entity.method_37908().method_8510());
        ComboState cs = (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(loc);
        cs.clickAction(entity);
    }

    default public class_2960 resolvCurrentComboState(class_1309 user) {
        if (!(user.method_6047().method_7909() instanceof ItemSlashBlade)) {
            return ComboStateRegistry.getId(ComboStateRegistry.NONE);
        }
        return this.resolvCurrentComboStateTicks(user).getValue();
    }

    default public Map.Entry<Integer, class_2960> resolvCurrentComboStateTicks(class_1309 user) {
        int time;
        class_2960 current = ComboStateRegistry.COMBO_STATE.method_10250(this.getComboSeq()) ? this.getComboSeq() : ComboStateRegistry.getId(ComboStateRegistry.NONE);
        ComboState currentCS = ComboStateRegistry.COMBO_STATE.method_10223(current) != null ? (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(current) : ComboStateRegistry.NONE;
        for (time = (int)TimeValueHelper.getMSecFromTicks(this.getElapsedTime(user)); !current.equals((Object)ComboStateRegistry.getId(ComboStateRegistry.NONE)) && currentCS.getTimeoutMS() < time; time -= currentCS.getTimeoutMS()) {
            current = currentCS.getNextOfTimeout(user);
            this.updateComboSeq(user, current);
        }
        int ticks = (int)TimeValueHelper.getTicksFromMSec(time);
        return new AbstractMap.SimpleImmutableEntry<Integer, class_2960>(ticks, current);
    }

    public class_2960 getComboRoot();

    public void setComboRoot(class_2960 var1);

    public int getDamage();

    public void setDamage(int var1);

    public int getMaxDamage();

    public void setMaxDamage(int var1);

    public List<class_2960> getSpecialEffects();

    public void setSpecialEffects(class_2499 var1);

    public boolean addSpecialEffect(class_2960 var1);

    public boolean removeSpecialEffect(class_2960 var1);

    public boolean hasSpecialEffect(class_2960 var1);

    public boolean isEmpty();

    public void setNonEmpty();
}

