/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.api.extension.ItemEntityRendererExtension;
import java.util.EnumSet;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.item.SwordType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_916;

@Environment(value=EnvType.CLIENT)
public class BladeItemEntityRenderer
extends class_916
implements ItemEntityRendererExtension {
    public BladeItemEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public boolean sb$shouldSpreadItems() {
        return false;
    }

    @Override
    public boolean sb$shouldBob() {
        return false;
    }

    public void method_3996(class_1542 itemIn, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        this.field_4673 = 0.0f;
        if (!itemIn.method_6983().method_7960()) {
            this.renderBlade(itemIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else {
            partialTicks = (float)((double)itemIn.field_7203 * 20.0 - (double)itemIn.method_6985());
            super.method_3996(itemIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private void renderBlade(class_1542 itemIn, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        block29: {
            if (itemIn instanceof BladeItemEntity) {
                BladeItemEntity bladeItem = (BladeItemEntity)itemIn;
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn);){
                    matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(entityYaw));
                    class_1799 current = itemIn.method_6983();
                    EnumSet<SwordType> types = SwordType.from(current);
                    ((EntityExtension)itemIn).sb$getPersistentData();
                    class_2960 modelLocation = CapabilitySlashBlade.BLADESTATE.maybeGet((Object)current).map(state -> state.getModel().orElseGet(bladeItem::getModel)).orElseGet(bladeItem::getModel);
                    class_2960 textureLocation = CapabilitySlashBlade.BLADESTATE.maybeGet((Object)current).map(state -> state.getTexture().orElseGet(bladeItem::getTexture)).orElseGet(bladeItem::getTexture);
                    WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
                    float scale = 0.00625f;
                    try (MSAutoCloser msac2 = MSAutoCloser.pushMatrix(matrixStackIn);){
                        String renderTarget;
                        float heightOffset;
                        float xOffset = 0.0f;
                        if (types.contains((Object)SwordType.EDGEFRAGMENT)) {
                            heightOffset = 225.0f;
                            xOffset = 200.0f;
                            renderTarget = "blade_fragment";
                        } else if (types.contains((Object)SwordType.BROKEN)) {
                            heightOffset = 100.0f;
                            xOffset = 30.0f;
                            renderTarget = "blade_damaged";
                        } else {
                            heightOffset = 225.0f;
                            xOffset = 120.0f;
                            renderTarget = "blade";
                        }
                        if (itemIn.method_5799()) {
                            matrixStackIn.method_46416(0.0f, 0.025f, 0.0f);
                            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(itemIn.field_7203));
                            matrixStackIn.method_22905(scale, scale, scale);
                            matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                        } else if (!itemIn.method_24828()) {
                            matrixStackIn.method_22905(scale, scale, scale);
                            float speed = -81.0f;
                            matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees(speed * ((float)itemIn.field_6012 + partialTicks)));
                            matrixStackIn.method_46416(xOffset, 0.0f, 0.0f);
                        } else {
                            matrixStackIn.method_22905(scale, scale, scale);
                            matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees(60.0f + (float)Math.toDegrees((double)itemIn.field_7203 / 6.0)));
                            matrixStackIn.method_46416(heightOffset, 0.0f, 0.0f);
                        }
                        BladeRenderState.renderOverrided(current, model, renderTarget, textureLocation, matrixStackIn, bufferIn, packedLightIn);
                        BladeRenderState.renderOverridedLuminous(current, model, renderTarget + "_luminous", textureLocation, matrixStackIn, bufferIn, packedLightIn);
                    }
                    if (!itemIn.method_5799() && (!itemIn.method_24828() || types.contains((Object)SwordType.NOSCABBARD))) break block29;
                    msac2 = MSAutoCloser.pushMatrix(matrixStackIn);
                    try {
                        matrixStackIn.method_46416(0.0f, 0.025f, 0.0f);
                        matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(itemIn.field_7203));
                        if (!itemIn.method_5799()) {
                            matrixStackIn.method_22904(0.75, 0.0, -0.4);
                        }
                        matrixStackIn.method_22905(scale, scale, scale);
                        matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                        String renderTarget = "sheath";
                        BladeRenderState.renderOverrided(current, model, renderTarget, textureLocation, matrixStackIn, bufferIn, packedLightIn);
                        BladeRenderState.renderOverridedLuminous(current, model, renderTarget + "_luminous", textureLocation, matrixStackIn, bufferIn, packedLightIn);
                    }
                    finally {
                        if (msac2 != null) {
                            msac2.close();
                        }
                    }
                }
            }
        }
    }
}

