/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;

@Environment(value=EnvType.CLIENT)
public class SlashEffectRenderer<T extends EntitySlashEffect>
extends class_897<T> {
    private static final class_2960 modelLocation = new class_2960("slashblade", "model/util/slash.obj");
    private static final class_2960 textureLocation = new class_2960("slashblade", "model/util/slash.png");

    @Nullable
    public class_2960 getTextureLocation(T entity) {
        return textureLocation;
    }

    public SlashEffectRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn);){
            float windscale;
            MSAutoCloser msacb;
            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(-class_3532.method_16439((float)partialTicks, (float)((EntitySlashEffect)entity).field_5982, (float)entity.method_36454()) - 90.0f));
            matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)((EntitySlashEffect)entity).field_6004, (float)entity.method_36455())));
            matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(((EntitySlashEffect)entity).getRotationRoll()));
            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
            int lifetime = ((EntitySlashEffect)entity).getLifetime();
            float progress = Math.min((float)lifetime, (float)((EntitySlashEffect)entity).field_6012 + partialTicks) / (float)lifetime;
            double deathTime = lifetime;
            double baseAlpha = Math.min(deathTime, (double)Math.max(0.0f, (float)(lifetime - ((EntitySlashEffect)entity).field_6012) - partialTicks)) / deathTime;
            baseAlpha = -Math.pow(baseAlpha - 1.0, 4.0) + 1.0;
            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(((EntitySlashEffect)entity).getRotationOffset() - 135.0f * progress));
            matrixStackIn.method_22905(1.0f, 0.25f, 1.0f);
            float baseScale = 1.2f;
            matrixStackIn.method_22905(baseScale, baseScale, baseScale);
            float yscale = 0.03f;
            float scale = ((EntitySlashEffect)entity).getBaseSize() * class_3532.method_16439((float)progress, (float)0.03f, (float)0.035f);
            int color = ((EntitySlashEffect)entity).getColor() & 0xFFFFFF;
            IConcentrationRank.ConcentrationRanks rank = ((EntitySlashEffect)entity).getRankCode();
            if (rank.level < IConcentrationRank.ConcentrationRanks.C.level) {
                color = 0x555555;
            }
            class_2960 rl = this.getTextureLocation(entity);
            int alpha = (0xFF & (int)(255.0 * baseAlpha)) << 24;
            if (IConcentrationRank.ConcentrationRanks.S.level <= rank.level) {
                msacb = MSAutoCloser.pushMatrix(matrixStackIn);
                try {
                    windscale = ((EntitySlashEffect)entity).getBaseSize() * class_3532.method_16439((float)progress, (float)0.035f, (float)0.03f);
                    matrixStackIn.method_22905(windscale, yscale, windscale);
                    Face.setAlphaOverride(Face.alphaOverrideYZZ);
                    Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.8f + progress * 0.3f);
                    BladeRenderState.setCol(0x222222 | alpha);
                    BladeRenderState.renderOverridedColorWrite(class_1799.field_8037, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
                }
                finally {
                    if (msacb != null) {
                        msacb.close();
                    }
                }
            }
            if (IConcentrationRank.ConcentrationRanks.D.level <= rank.level) {
                msacb = MSAutoCloser.pushMatrix(matrixStackIn);
                try {
                    matrixStackIn.method_22905(scale, yscale, scale);
                    Face.setAlphaOverride(Face.alphaOverrideYZZ);
                    Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.35f + progress * -0.15f);
                    BladeRenderState.setCol(color | alpha);
                    BladeRenderState.renderOverridedColorWrite(class_1799.field_8037, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
                }
                finally {
                    if (msacb != null) {
                        msacb.close();
                    }
                }
            }
            if (IConcentrationRank.ConcentrationRanks.B.level <= rank.level) {
                msacb = MSAutoCloser.pushMatrix(matrixStackIn);
                try {
                    windscale = ((EntitySlashEffect)entity).getBaseSize() * class_3532.method_16439((float)progress, (float)0.03f, (float)0.0375f);
                    matrixStackIn.method_22905(windscale, yscale, windscale);
                    Face.setAlphaOverride(Face.alphaOverrideYZZ);
                    Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.5f + progress * -0.2f);
                    BladeRenderState.setCol(0x404040 | alpha);
                    BladeRenderState.renderOverridedLuminous(class_1799.field_8037, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
                }
                finally {
                    if (msacb != null) {
                        msacb.close();
                    }
                }
            }
            msacb = MSAutoCloser.pushMatrix(matrixStackIn);
            try {
                matrixStackIn.method_22905(scale, yscale, scale);
                Face.setAlphaOverride(Face.alphaOverrideYZZ);
                Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.35f + progress * -0.15f);
                BladeRenderState.setCol(color | alpha);
                BladeRenderState.renderOverridedLuminous(class_1799.field_8037, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
            }
            finally {
                if (msacb != null) {
                    msacb.close();
                }
            }
        }
    }
}

