/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import cn.sh1rocu.slashblade.api.extension.IEntityAdditionalSpawnData;
import java.util.List;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1844;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

public class EntityDrive
extends EntityAbstractSummonedSword {
    private static final class_2940<Integer> COLOR = class_2945.method_12791(EntityDrive.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> FLAGS = class_2945.method_12791(EntityDrive.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> RANK = class_2945.method_12791(EntityDrive.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ROTATION_OFFSET = class_2945.method_12791(EntityDrive.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ROTATION_ROLL = class_2945.method_12791(EntityDrive.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> BASESIZE = class_2945.method_12791(EntityDrive.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SPEED = class_2945.method_12791(EntityDrive.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> LIFETIME = class_2945.method_12791(EntityDrive.class, (class_2941)class_2943.field_13320);
    private KnockBacks action = KnockBacks.cancel;
    private double damage = 7.0;

    public KnockBacks getKnockBack() {
        return this.action;
    }

    public void setKnockBack(KnockBacks action) {
        this.action = action;
    }

    public void setKnockBackOrdinal(int ordinal) {
        this.action = 0 <= ordinal && ordinal < KnockBacks.values().length ? KnockBacks.values()[ordinal] : KnockBacks.cancel;
    }

    public EntityDrive(class_1299<? extends Projectile> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.method_5875(true);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)0x3333FF);
        this.field_6011.method_12784(FLAGS, (Object)0);
        this.field_6011.method_12784(RANK, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LIFETIME, (Object)Float.valueOf(10.0f));
        this.field_6011.method_12784(ROTATION_OFFSET, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(BASESIZE, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(SPEED, (Object)Float.valueOf(0.5f));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        NBTHelper.getNBTCoupler(compound).put("RotationOffset", Float.valueOf(this.getRotationOffset())).put("RotationRoll", Float.valueOf(this.getRotationRoll())).put("BaseSize", Float.valueOf(this.getBaseSize())).put("Speed", Float.valueOf(this.getSpeed())).put("Color", this.getColor()).put("Rank", Float.valueOf(this.getRank())).put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("Lifetime", Float.valueOf(this.getLifetime())).put("Knockback", this.getKnockBack().ordinal());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        NBTHelper.getNBTCoupler(compound).get("RotationOffset", this::setRotationOffset, new Float[0]).get("RotationRoll", this::setRotationRoll, new Float[0]).get("BaseSize", this::setBaseSize, new Float[0]).get("Speed", this::setSpeed, new Float[0]).get("Color", this::setColor, new Integer[0]).get("Rank", this::setRank, new Float[0]).get("damage", v -> {
            this.damage = v;
        }, this.damage).get("crit", this::setIsCritical, new Boolean[0]).get("clip", this::setNoClip, new Boolean[0]).get("Lifetime", this::setLifetime, new Float[0]).get("Knockback", this::setKnockBackOrdinal, new Integer[0]);
    }

    @Override
    public class_2596<class_2602> method_18002() {
        return IEntityAdditionalSpawnData.getEntitySpawningPacket((class_1297)this);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityDrive.method_5824()) * d0;
    }

    @Override
    protected void removeFlags(EntityAbstractSummonedSword.FlagsState value) {
        this.flags.remove((Object)value);
        this.refreshFlags();
    }

    private void refreshFlags() {
        if (this.method_37908().method_8608()) {
            int newValue = (Integer)this.field_6011.method_12789(FLAGS);
            if (this.intFlags != newValue) {
                this.intFlags = newValue;
                this.flags = EnumSetConverter.convertToEnumSet(EntityAbstractSummonedSword.FlagsState.class, this.intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_6011.method_12778(FLAGS, (Object)newValue);
                this.intFlags = newValue;
            }
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.tryDespawn();
    }

    @Override
    protected void tryDespawn() {
        if (!this.method_37908().method_8608() && this.getLifetime() < (float)this.field_6012) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    @Override
    public int getColor() {
        return (Integer)this.method_5841().method_12789(COLOR);
    }

    @Override
    public void setColor(int value) {
        this.method_5841().method_12778(COLOR, (Object)value);
    }

    public float getRank() {
        return ((Float)this.method_5841().method_12789(RANK)).floatValue();
    }

    public void setRank(float value) {
        this.method_5841().method_12778(RANK, (Object)Float.valueOf(value));
    }

    public IConcentrationRank.ConcentrationRanks getRankCode() {
        return IConcentrationRank.ConcentrationRanks.getRankFromLevel(this.getRank());
    }

    public float getRotationOffset() {
        return ((Float)this.method_5841().method_12789(ROTATION_OFFSET)).floatValue();
    }

    public void setRotationOffset(float value) {
        this.method_5841().method_12778(ROTATION_OFFSET, (Object)Float.valueOf(value));
    }

    public float getRotationRoll() {
        return ((Float)this.method_5841().method_12789(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float value) {
        this.method_5841().method_12778(ROTATION_ROLL, (Object)Float.valueOf(value));
    }

    public float getBaseSize() {
        return ((Float)this.method_5841().method_12789(BASESIZE)).floatValue();
    }

    public void setBaseSize(float value) {
        this.method_5841().method_12778(BASESIZE, (Object)Float.valueOf(value));
    }

    public float getSpeed() {
        return ((Float)this.method_5841().method_12789(SPEED)).floatValue();
    }

    public void setSpeed(float value) {
        this.method_5841().method_12778(SPEED, (Object)Float.valueOf(value));
    }

    public float getLifetime() {
        return ((Float)this.method_5841().method_12789(LIFETIME)).floatValue();
    }

    public void setLifetime(float value) {
        this.method_5841().method_12778(LIFETIME, (Object)Float.valueOf(value));
    }

    @Override
    @Nullable
    public class_1297 getShooter() {
        return this.method_24921();
    }

    @Override
    public void setShooter(class_1297 shooter) {
        this.method_7432(shooter);
    }

    @Override
    public List<class_1293> getPotionEffects() {
        List effects = class_1844.method_8066((class_2487)this.sb$getPersistentData());
        if (effects.isEmpty()) {
            effects.add(new class_1293(class_1294.field_5899, 1, 1));
        }
        return effects;
    }

    @Override
    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        class_1282 damagesource;
        class_1297 targetEntity = entityHitResult.method_17782();
        float damageValue = (float)this.getDamage();
        class_1297 shooter = this.getShooter();
        if (shooter == null) {
            damagesource = this.method_48923().method_48815((class_1297)this, (class_1297)this);
        } else {
            damagesource = this.method_48923().method_48815((class_1297)this, shooter);
            if (shooter instanceof class_1309) {
                class_1297 hits = targetEntity;
                ((class_1309)shooter).method_6114(hits);
            }
        }
        int fireTime = targetEntity.method_20802();
        if (this.method_5809() && !(targetEntity instanceof class_1560)) {
            targetEntity.method_5639(5);
        }
        targetEntity.field_6008 = 0;
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            damageValue = (float)((double)damageValue * living.method_26825(class_5134.field_23721));
            if (living instanceof class_1657) {
                class_1657 player = (class_1657)living;
                IConcentrationRank.ConcentrationRanks rankBonus = CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)player).map(rp -> rp.getRank(player.method_5770().method_8510())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
                float rankDamageBonus = (float)rankBonus.level / 2.0f;
                if (IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
                    int refine = CapabilitySlashBlade.BLADESTATE.maybeGet((Object)player.method_6047()).map(ISlashBladeState::getRefine).orElse(0);
                    int level = player.field_7520;
                    rankDamageBonus = (float)Math.max((double)rankDamageBonus, (double)Math.min(level, refine) * (Double)SlashBladeConfig.REFINE_DAMAGE_MULTIPLIER.get());
                }
                damageValue += rankDamageBonus;
            }
            damageValue = (float)((double)damageValue * ((double)AttackManager.getSlashBladeDamageScale(living) * (Double)SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER.get()));
            if (this.getIsCritical()) {
                damageValue += (float)this.field_5974.method_43048(class_3532.method_15386((float)damageValue) / 2 + 2);
            }
        }
        if (targetEntity.method_5643(damagesource, damageValue)) {
            class_1297 hits = targetEntity;
            if (hits instanceof class_1309) {
                class_1309 targetLivingEntity = (class_1309)hits;
                StunManager.setStun(targetLivingEntity);
                if (!this.method_37908().method_8608() && shooter instanceof class_1309) {
                    class_1890.method_8210((class_1309)targetLivingEntity, (class_1297)shooter);
                    class_1890.method_8213((class_1309)((class_1309)shooter), (class_1297)targetLivingEntity);
                }
                this.affectEntity(targetLivingEntity, this.getPotionEffects(), 1.0);
                if (shooter != null && targetLivingEntity != shooter && targetLivingEntity instanceof class_1657 && shooter instanceof class_3222) {
                    ((class_3222)shooter).method_17356(this.getHitEntityPlayerSound(), class_3419.field_15248, 0.18f, 0.45f);
                }
            }
            this.method_5783(this.getHitEntitySound(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
        } else {
            targetEntity.method_20803(fireTime);
        }
    }

    @Override
    protected void method_24920(class_3965 blockraytraceresult) {
        this.method_31745(class_1297.class_5529.field_26999);
    }

    @Override
    @Nullable
    public class_3966 getRayTrace(class_243 p_213866_1_, class_243 p_213866_2_) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)p_213866_1_, (class_243)p_213866_2_, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), entity -> !entity.method_7325() && entity.method_5805() && entity.method_5863() && entity != this.getShooter());
    }
}

